/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypeResultVO;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchema;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchemaField;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.WhiteList;
import com.digiwin.dap.middleware.iam.mapper.OrgTypeMapper;
import com.digiwin.dap.middleware.iam.mapper.RoleMapper;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaFieldRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicySchemaCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Order(value=43606)
@Service
public class UpgradeDatabaseV43605ToV43606Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43605ToV43606Service.class);
    private static final String DICT_ID = "wecom_provider";
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private DictService dictService;
    @Autowired
    private DataPolicySchemaCrudService dataPolicySchemaCrudService;
    @Autowired
    private DataPolicySchemaFieldRepository dataPolicySchemaFieldRepository;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private OrgTypeMapper orgTypeMapper;
    @Autowired
    private WhiteListService whiteListService;

    public String version() {
        return "4.36.6.0";
    }

    public void update() {
        LOGGER.info("436600\uff0c\u5347\u7ea7\u5f00\u59cb --->>>");
        this.tenantMetadataColumnCrudService.saveDefaultAll();
        this.updateDict();
        this.updateDictData();
        this.insertDevAPISchema();
        this.updateRoleVisible();
        this.updateOrgType();
        this.updateDigiWhiteList();
        LOGGER.info("436600\uff0c\u5347\u7ea7\u7ed3\u675f <<<---");
    }

    private void updateDigiWhiteList() {
        try {
            WhiteList whiteList = new WhiteList();
            whiteList.setId("ALLOW_GRANT_ADMIN");
            whiteList.setName("\u5141\u8bb8\u8bbe\u7f6e99990000\u8d85\u7ba1\u7684\u7528\u6237id");
            whiteList.setContent("cathy@digiwin.com;emmabi@digiwin.com");
            this.whiteListService.insertOrUpdateWhiteList(whiteList);
        }
        catch (Exception e) {
            LOGGER.error("updateDigiWhiteList failed", (Throwable)e);
        }
    }

    private void updateRoleVisible() {
        LOGGER.info("\u89d2\u8272\u66f4\u65b0\u5f00\u59cb:{}", (Object)LocalDateTime.now());
        this.roleMapper.updateRoleVisible(Arrays.asList("integration", "KanBanSchedule"), false);
        LOGGER.info("\u89d2\u8272\u66f4\u65b0\u7ed3\u675f:{}", (Object)LocalDateTime.now());
    }

    private void updateOrgType() {
        LOGGER.info("\u7ec4\u7ec7\u66f4\u65b0\u5f00\u59cb:{}", (Object)LocalDateTime.now());
        List companyTenants = this.orgTypeMapper.findTenantInfoNotInId("company");
        List factoryTenants = this.orgTypeMapper.findTenantInfoNotInId("factory");
        List departmentTenants = this.orgTypeMapper.findTenantInfoNotInId("department");
        String insertSql = "insert into orgtype(sid,tenant_sid,id,name,orgcatalog_sid,uri) values";
        int size = 0;
        if (companyTenants.size() > 0) {
            size += companyTenants.size();
            this.batchUpdate(insertSql, companyTenants, "(%s,%s,'company','\u516c\u53f8',%s,'drn:iam:orgtype:defaultOrgCatalog:company')");
        }
        if (factoryTenants.size() > 0) {
            size += factoryTenants.size();
            this.batchUpdate(insertSql, factoryTenants, "(%s,%s,'factory','\u5de5\u5382',%s,'drn:iam:orgtype:defaultOrgCatalog:factory')");
        }
        if (departmentTenants.size() > 0) {
            size += departmentTenants.size();
            this.batchUpdate(insertSql, departmentTenants, "(%s,%s,'department','\u90e8\u95e8',%s,'drn:iam:orgtype:defaultOrgCatalog:department')");
        }
        LOGGER.info("\u7ec4\u7ec7\u66f4\u65b0\u7ed3\u675f:{}-{}", (Object)size, (Object)LocalDateTime.now());
    }

    private void batchUpdate(String insertHeaderSql, List<OrgTypeResultVO> tenants, String valueSql) {
        ArrayList<String> insertValueSqlList = new ArrayList<String>();
        int count = (int)Math.ceil((double)tenants.size() / 1000.0);
        if (count > 0) {
            int beginIndex = 0;
            for (int i = 1; i < count + 1; ++i) {
                for (int j = beginIndex; j < 1000 * i && tenants.size() > j; ++j) {
                    if (ObjectUtils.isEmpty((Object)tenants.get(j).getOrgCatalogSid()) || 0L >= tenants.get(j).getOrgCatalogSid()) continue;
                    long sid = SnowFlake.getInstance().newId();
                    String insertValue = String.format(valueSql, sid, tenants.get(j).getTenantSid(), tenants.get(j).getOrgCatalogSid());
                    insertValueSqlList.add(insertValue);
                }
                String insertAllSql = String.format("%s%s", insertHeaderSql, String.join((CharSequence)",", insertValueSqlList));
                this.jdbcTemplate.execute(insertAllSql);
                insertValueSqlList.clear();
                beginIndex = 1000 * i;
            }
        }
    }

    private void updateDict() {
        List dictList = this.dictService.selectDictList(null);
        List dictIdList = dictList.stream().map(Dict::getId).collect(Collectors.toList());
        LOGGER.info("dictIdList = {}", dictIdList);
        if (!dictIdList.contains(DICT_ID)) {
            Dict dict = new Dict();
            dict.setId(DICT_ID);
            dict.setName("\u4f01\u5fae\u670d\u52a1\u5546");
            dict.setRemark("\u4f01\u5fae\u670d\u52a1\u5546");
            this.dictService.insertDict(dict);
        }
    }

    private void updateDictData() {
        DictData data;
        DictDataDTO dictDataDTO = new DictDataDTO(DICT_ID, null);
        List dictDataList = this.dictDataService.selectDictDataList(dictDataDTO);
        LOGGER.info("dictDataList.size() = {}", (Object)dictDataList.size());
        List dictDatas = dictDataList.stream().map(DictData::getDictKey).collect(Collectors.toList());
        if (!dictDatas.contains("corpId")) {
            data = new DictData();
            data.setDictId(DICT_ID);
            data.setDictKey("corpId");
            data.setDictValue("wwec1531c6ca6af19f");
            data.setRemark("\u670d\u52a1\u5546\u4f01\u5faeid");
            this.dictDataService.insertDictData(data);
        }
        if (!dictDatas.contains("secret")) {
            data = new DictData();
            data.setDictId(DICT_ID);
            data.setDictKey("secret");
            data.setDictValue("YVFXGq9BWHZ-XH7xfca4C9V4HCF_UmSpcxoK0j3j3MUwuow6wxMAKinKH_xX7hg3");
            data.setRemark("\u670d\u52a1\u5546\u4f01\u5faesecret");
            this.dictDataService.insertDictData(data);
        }
        if (!dictDatas.contains("buyerUserId")) {
            data = new DictData();
            data.setDictId(DICT_ID);
            data.setDictKey("buyerUserId");
            data.setDictValue("BD51F5BE53947141BE2D1B6C2505A7F6");
            data.setRemark("\u670d\u52a1\u5546\u4f01\u5fae\u4e0b\u5355\u4eba");
            this.dictDataService.insertDictData(data);
        }
    }

    private void insertDevAPISchema() {
        this.clearDevAPISchema();
        DataPolicySchema schema = new DataPolicySchema();
        schema.setActionId("dev-interface-management");
        schema.setTableId("api_project");
        schema.setTableName("API\u63a5\u53e3\u7ba1\u7406");
        schema.setTableNameUS("API Interface Management");
        schema.setTableNameTW("API\u4ecb\u9762\u7ba1\u7406");
        EntityUtils.setCreateFields((BaseEntity)schema);
        long sid1 = this.dataPolicySchemaCrudService.create((BaseEntity)schema);
        this.insertDevAPISchemaField(sid1);
        DataPolicySchema schema2 = new DataPolicySchema();
        schema2.setActionId("dev-api-policy");
        schema2.setTableId("api_project");
        schema2.setTableName("API\u7b56\u7565\u7ba1\u7406");
        schema2.setTableNameUS("API Policy Management");
        schema2.setTableNameTW("API\u7b56\u7565\u7ba1\u7406");
        EntityUtils.setCreateFields((BaseEntity)schema2);
        long sid2 = this.dataPolicySchemaCrudService.create((BaseEntity)schema2);
        this.insertDevAPISchemaField(sid2);
        DataPolicySchema schema3 = new DataPolicySchema();
        schema3.setActionId("dev-api-subscription");
        schema3.setTableId("api_project");
        schema3.setTableName("API\u8ba2\u9605\u7ba1\u7406");
        schema3.setTableNameUS("API Subscription Management");
        schema3.setTableNameTW("API\u8a02\u95b1\u7ba1\u7406");
        EntityUtils.setCreateFields((BaseEntity)schema3);
        long sid3 = this.dataPolicySchemaCrudService.create((BaseEntity)schema3);
        this.insertDevAPISchemaField(sid3);
        Sys boss = (Sys)this.sysRepository.findById("BOSS");
        Sys devAPI = (Sys)this.sysRepository.findById("devAPI");
        if (boss != null && devAPI != null) {
            devAPI.setBackUri(boss.getBackUri());
            this.sysCrudService.update((BaseEntity)devAPI);
        }
    }

    private void clearDevAPISchema() {
        DataPolicySchema oldData = this.dataPolicySchemaCrudService.findByActionIdAndTableId("dev-interface-management", "api_project");
        if (oldData != null) {
            this.dataPolicySchemaCrudService.deleteById(oldData.getSid());
            this.dataPolicySchemaFieldRepository.deleteByIdAndSchemaSid("projectId", Long.valueOf(oldData.getSid()));
        }
        if ((oldData = this.dataPolicySchemaCrudService.findByActionIdAndTableId("dev-api-policy", "api_project")) != null) {
            this.dataPolicySchemaCrudService.deleteById(oldData.getSid());
            this.dataPolicySchemaFieldRepository.deleteByIdAndSchemaSid("projectId", Long.valueOf(oldData.getSid()));
        }
        if ((oldData = this.dataPolicySchemaCrudService.findByActionIdAndTableId("dev-api-subscription", "api_project")) != null) {
            this.dataPolicySchemaCrudService.deleteById(oldData.getSid());
            this.dataPolicySchemaFieldRepository.deleteByIdAndSchemaSid("projectId", Long.valueOf(oldData.getSid()));
        }
    }

    private void insertDevAPISchemaField(long schemaSid) {
        DataPolicySchemaField field = new DataPolicySchemaField();
        field.setSchemaSid(schemaSid);
        field.setDataSource(Integer.valueOf(1));
        field.setDataType("STRING");
        field.setFilterType("in");
        field.setId("projectId");
        field.setName("\u9879\u76eeID");
        field.setNameUS("project id");
        field.setNameTW("\u9805\u76eeID");
        field.setValueParams(this.envProperties.getRamUri().replace("local", "") + "/api/ram/v2/project/code/item");
        EntityUtils.setCreateFields((BaseEntity)field);
        this.dataPolicySchemaFieldRepository.save((Object)field);
    }
}

