/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.SysNoticeType;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeTypeCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43609)
@Service
public class UpgradeDatabaseV43608ToV43609Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43608ToV43609Service.class);
    private static final String DICT_ID = "huawei_license";
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private SysNoticeTypeCrudService sysNoticeTypeCrudService;
    @Autowired
    private DictService dictService;

    public String version() {
        return "4.36.9.0";
    }

    public void update() {
        logger.info("4369\u6570\u636e\u5347\u7ea7\u5f00\u59cb -->>>");
        try {
            this.newSysNoticeType();
            this.updateDict();
            logger.info("4369\u6570\u636e\u5347\u7ea7\u7ed3\u675f <<<---");
        }
        catch (Exception e) {
            throw new BusinessException("V4369\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
    }

    private void newSysNoticeType() {
        String type = "AUTH_USER";
        List all = this.sysNoticeTypeCrudService.findAll();
        if (all.stream().noneMatch(a -> type.equals(a.getId()))) {
            SysNoticeType sysNoticeType = new SysNoticeType();
            sysNoticeType.setId(type);
            sysNoticeType.setPath("/api/app/user/auth/notice");
            sysNoticeType.setDescription("\u9489\u9489\u7528\u6237\u6388\u6743\u5e94\u7528\u901a\u77e5");
            if ("TW".equals(this.envProperties.getCountry())) {
                sysNoticeType.setDescription("\u91d8\u91d8\u7528\u6236\u6388\u6b0a\u61c9\u7528\u7a0b\u5f0f\u901a\u77e5");
            }
            this.sysNoticeTypeCrudService.create((BaseEntity)sysNoticeType);
        }
    }

    private void updateDict() {
        List dictList = this.dictService.selectDictList(null);
        List dictIdList = dictList.stream().map(Dict::getId).collect(Collectors.toList());
        if (!dictIdList.contains(DICT_ID)) {
            Dict dict = new Dict();
            dict.setId(DICT_ID);
            dict.setName("License\u7c7b\u5546\u54c1\u63a5\u5165");
            dict.setRemark("License\u6388\u6743\u7801\u548cIAM\u79df\u6237\u5bf9\u5e94\u5173\u7cfb");
            this.dictService.insertDict(dict);
        }
    }
}

