/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middle.stream.domain.SysNoticeEnum;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.SysNoticeType;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeTypeCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43610)
@Service
public class UpgradeDatabaseV43609ToV43610Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43609ToV43610Service.class);
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private DictService dictService;
    @Autowired
    private SysNoticeTypeCrudService sysNoticeTypeCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserMapper userMapper;

    public String version() {
        return "4.36.10.0";
    }

    public void update() {
        logger.info("43610\u6570\u636e\u5347\u7ea7\u5f00\u59cb -->>>");
        try {
            this.updateDict();
            this.updateDictAndData();
            this.newSysNoticeType();
            this.updateUsers();
            logger.info("43610\u6570\u636e\u5347\u7ea7\u7ed3\u675f <<<---");
        }
        catch (Exception e) {
            throw new BusinessException("V43610\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
    }

    private void updateUsers() {
        List updateUsers = this.userMapper.getAdUserWithDefaultPassword();
        this.userMapper.updatePasswordChangedState(updateUsers);
        ArrayList deleteKeys = new ArrayList(updateUsers.size());
        updateUsers.forEach(u -> deleteKeys.add(String.format("dap:entity:user:%s", u)));
        RedisUtils.delete(deleteKeys);
    }

    private void updateDictAndData() {
        Dict dict = this.dictService.selectDictById("DeployArea");
        if (Objects.isNull(dict)) {
            Dict deployAreaDict = new Dict();
            deployAreaDict.setId("DeployArea");
            deployAreaDict.setName("\u90e8\u7f72\u4e91\u533a");
            deployAreaDict.setRemark("IAM\u90e8\u7f72\u4e91\u533a\u53ca\u8bbf\u95ee\u5730\u5740");
            this.dictService.insertDict(deployAreaDict);
        }
        HashMap<String, String> deployAreaMap = new HashMap<String, String>();
        deployAreaMap.put("Huawei-Isvlt_isvlt", "https://devuser-iam-isvlt.digiwincloud.com.cn");
        deployAreaMap.put("Huawei-Edu_edu", "https://iam-edu.digiwincloud.com.cn");
        deployAreaMap.put("Azure-Edu_edu", "https://iam-edu.digiwincloud.com");
        for (String deployArea : deployAreaMap.keySet()) {
            DictDataDTO condition = new DictDataDTO();
            condition.setDictId("DeployArea");
            condition.setDictKey(deployArea);
            DictData dictData = this.dictDataService.selectDictData(condition);
            if (dictData != null) continue;
            DictData data = new DictData();
            data.setDictId("DeployArea");
            data.setDictKey(deployArea);
            data.setDictValue((String)deployAreaMap.get(deployArea));
            this.dictDataService.insertDictData(data);
        }
    }

    private void updateDict() {
        DictDataDTO condition = new DictDataDTO();
        String comeFrom = "source_type";
        String key = "intelly";
        condition.setDictId(comeFrom);
        condition.setDictKey(key);
        DictData dictData = this.dictDataService.selectDictData(condition);
        if (dictData == null) {
            DictData data = new DictData();
            data.setDictId(comeFrom);
            data.setDictKey(key);
            data.setDictValue("\u667a\u5ba2\u4e2d\u5fc3");
            this.dictDataService.insertDictData(data);
        }
    }

    private void newSysNoticeType() {
        String type = SysNoticeEnum.DELETE_CORP.name();
        List all = this.sysNoticeTypeCrudService.findAll();
        if (all.stream().noneMatch(a -> type.equals(a.getId()))) {
            SysNoticeType sysNoticeType = new SysNoticeType();
            sysNoticeType.setId(type);
            sysNoticeType.setPath(SysNoticeEnum.DELETE_CORP.path());
            sysNoticeType.setDescription("\u5220\u9664\u8fd0\u8425\u5355\u5143\u901a\u77e5");
            if ("TW".equals(this.envProperties.getCountry())) {
                sysNoticeType.setDescription("\u522a\u9664\u904b\u71df\u55ae\u5143\u901a\u77e5");
            }
            this.sysNoticeTypeCrudService.create((BaseEntity)sysNoticeType);
        }
    }
}

