/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantMetadata;
import com.digiwin.dap.middleware.iam.entity.TenantMetadataColumn;
import com.digiwin.dap.middleware.iam.mapper.SysInTenantMapper;
import com.digiwin.dap.middleware.iam.repository.TenantMetadataRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43611)
@Service
public class UpgradeDatabaseV43610ToV43611Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43610ToV43611Service.class);
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private TenantMetadataRepository tenantMetadataRepository;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private SysInTenantMapper sysInTenantMapper;

    public String version() {
        return "4.36.11.0";
    }

    public void update() {
        LOGGER.info("4361100\uff0c\u5347\u7ea7\u5f00\u59cb --->>>");
        this.updateDingding();
        this.updateAppTokenExpireInfo();
        LOGGER.info("4361100\uff0c\u5347\u7ea7\u7ed3\u675f <<<---");
    }

    private void updateAppTokenExpireInfo() {
        Map allowTenantAdjustSysTokenExpireInfo = this.getAllowTenantAdjustSysTokenExpireInfo();
        for (Map.Entry stringLongEntry : allowTenantAdjustSysTokenExpireInfo.entrySet()) {
            String sysId = (String)stringLongEntry.getKey();
            Long expireTime = (Long)stringLongEntry.getValue();
            Sys sys = (Sys)this.sysCrudService.findById(sysId);
            if (!Objects.nonNull(sys)) continue;
            sys.setTokenExpire(expireTime.longValue());
            sys.setCustomizeTokenExpired(true);
            sys.setAllowTenantAdjustTime(true);
            this.sysCrudService.update((BaseEntity)sys);
            this.sysInTenantMapper.updateTokenExpire(Long.valueOf(sys.getSid()), expireTime);
        }
        Map notAllowTenantAdjustSysTokenExpireInfo = this.getNotAllowTenantAdjustSysTokenExpireInfo();
        for (Map.Entry stringLongEntry : notAllowTenantAdjustSysTokenExpireInfo.entrySet()) {
            String sysId = (String)stringLongEntry.getKey();
            Long expireTime = (Long)stringLongEntry.getValue();
            Sys sys = (Sys)this.sysCrudService.findById(sysId);
            if (!Objects.nonNull(sys)) continue;
            sys.setTokenExpire(expireTime.longValue());
            sys.setCustomizeTokenExpired(true);
            sys.setAllowTenantAdjustTime(false);
            this.sysCrudService.update((BaseEntity)sys);
            this.sysInTenantMapper.updateTokenExpire(Long.valueOf(sys.getSid()), expireTime);
        }
    }

    private Map<String, Long> getAllowTenantAdjustSysTokenExpireInfo() {
        HashMap<String, Long> appTokenExpireMap = new HashMap<String, Long>();
        appTokenExpireMap.put("digiwincloud", 1440L);
        appTokenExpireMap.put("boss", 1440L);
        appTokenExpireMap.put("devAPI", 1440L);
        appTokenExpireMap.put("devOM", 1440L);
        appTokenExpireMap.put("ISV", 1440L);
        appTokenExpireMap.put("athena", 480L);
        appTokenExpireMap.put("athena-lcdp", 1200L);
        appTokenExpireMap.put("KMO", 1440L);
        appTokenExpireMap.put("KBS", 1440L);
        appTokenExpireMap.put("KCP", 1440L);
        appTokenExpireMap.put("KSE", 1440L);
        appTokenExpireMap.put("KSD", 1440L);
        appTokenExpireMap.put("TipBiuBI", 1440L);
        appTokenExpireMap.put("DCC", 360L);
        return appTokenExpireMap;
    }

    private Map<String, Long> getNotAllowTenantAdjustSysTokenExpireInfo() {
        HashMap<String, Long> appTokenExpireMap = new HashMap<String, Long>();
        appTokenExpireMap.put("ops", 240L);
        appTokenExpireMap.put("KCF", 1440L);
        appTokenExpireMap.put("KAI-WIS", 1440L);
        appTokenExpireMap.put("KAI-SKC", 1440L);
        appTokenExpireMap.put("dmp", 1440L);
        appTokenExpireMap.put("ASSC-BSP", 120L);
        appTokenExpireMap.put("ASSC-CRS", 120L);
        appTokenExpireMap.put("ASSC-CSS", 120L);
        appTokenExpireMap.put("ASSC-DSA", 120L);
        appTokenExpireMap.put("ASSC-ISA", 120L);
        appTokenExpireMap.put("ASSC-KBS", 120L);
        appTokenExpireMap.put("ASSC-PCT", 120L);
        appTokenExpireMap.put("ASSC-PPU", 120L);
        appTokenExpireMap.put("ASSC-SLS", 120L);
        appTokenExpireMap.put("ASSC-SSM", 120L);
        appTokenExpireMap.put("DEC", 1440L);
        appTokenExpireMap.put("ServiceCloud", 1440L);
        appTokenExpireMap.put("AIEOM", 1440L);
        appTokenExpireMap.put("DCDP", 1440L);
        appTokenExpireMap.put("WHA", 120L);
        appTokenExpireMap.put("SCC", 1440L);
        return appTokenExpireMap;
    }

    private void updateDingding() {
        this.tenantMetadataColumnCrudService.saveDefaultAll();
        TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"corpId", ComeFromEnum.DINGDING.getId()});
        if (column != null) {
            List ding = this.tenantRepository.findByComeFromIn(Collections.singletonList(ComeFromEnum.DINGDING.getId())).stream().filter(a -> a.getId().startsWith("ding")).collect(Collectors.toList());
            for (Tenant tenant : ding) {
                TenantMetadata tenantMetadata = this.tenantMetadataRepository.findByTenantSidAndColumnSid(tenant.getSid(), column.getSid());
                if (tenantMetadata != null) continue;
                TenantMetadata metadata = new TenantMetadata();
                metadata.setColumnSid(column.getSid());
                metadata.setTenantSid(tenant.getSid());
                metadata.setValue(tenant.getId());
                this.tenantMetadataCrudService.create((BaseEntity)metadata);
            }
        }
    }
}

