/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.OauthApi;
import com.digiwin.dap.middleware.iam.entity.OauthScopeApi;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysNoticeType;
import com.digiwin.dap.middleware.iam.repository.OauthApiRepository;
import com.digiwin.dap.middleware.iam.repository.OauthScopeApiRepository;
import com.digiwin.dap.middleware.iam.repository.OauthScopeRepository;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeTypeCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43612)
@Service
public class UpgradeDatabaseV43611ToV43612Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43611ToV43612Service.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private SysNoticeTypeCrudService sysNoticeTypeCrudService;
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private OauthApiRepository oauthApiRepository;
    @Autowired
    private OauthScopeRepository oauthScopeRepository;
    @Autowired
    private OauthScopeApiRepository oauthScopeApiRepository;

    public String version() {
        return "4.36.12.0";
    }

    public void update() {
        LOGGER.info("4361200\uff0c\u5347\u7ea7\u5f00\u59cb --->>>");
        this.updateTenantMeta();
        this.newSysNoticeType();
        this.updateAppTokenExpireInfo();
        this.createOAuthApi();
        LOGGER.info("43612200\uff0c\u5347\u7ea7\u7ed3\u675f <<<---");
    }

    private void updateTenantMeta() {
        this.tenantMetadataColumnCrudService.saveDefaultAll();
    }

    private void newSysNoticeType() {
        String type = "APP_PACK_NEW";
        List all = this.sysNoticeTypeCrudService.findAll();
        if (all.stream().noneMatch(a -> type.equals(a.getId()))) {
            SysNoticeType sysNoticeType = new SysNoticeType();
            sysNoticeType.setId(type);
            sysNoticeType.setPath("/api/app/tenant/purchase/pack");
            if ("TW".equals(this.envProperties.getCountry())) {
                sysNoticeType.setDescription("\u7d44\u5408\u5546\u54c1\u8cfc\u8cb7\u901a\u77e5");
            } else {
                sysNoticeType.setDescription("\u7ec4\u5408\u5546\u54c1\u8d2d\u4e70\u901a\u77e5");
            }
            this.sysNoticeTypeCrudService.create((BaseEntity)sysNoticeType);
        }
    }

    private void updateAppTokenExpireInfo() {
        Map allowTenantAdjustSysTokenExpireInfo = this.getAllowTenantAdjustSysTokenExpireInfo();
        for (Map.Entry stringLongEntry : allowTenantAdjustSysTokenExpireInfo.entrySet()) {
            String sysId = (String)stringLongEntry.getKey();
            Long expireTime = (Long)stringLongEntry.getValue();
            Sys sys = (Sys)this.sysCrudService.findById(sysId);
            if (!Objects.nonNull(sys)) continue;
            sys.setTokenExpire(expireTime.longValue());
            sys.setCustomizeTokenExpired(true);
            sys.setAllowTenantAdjustTime(true);
            this.sysCrudService.update((BaseEntity)sys);
        }
    }

    private Map<String, Long> getAllowTenantAdjustSysTokenExpireInfo() {
        HashMap<String, Long> appTokenExpireMap = new HashMap<String, Long>();
        appTokenExpireMap.put("athena-lcdp", 1440L);
        appTokenExpireMap.put("BM-OPT", 1440L);
        appTokenExpireMap.put("PSDT", 1440L);
        return appTokenExpireMap;
    }

    private void createOAuthApi() {
        List oauthScope;
        OauthApi oauthApi = new OauthApi();
        oauthApi.setApi("/api/iam/v2/user/current");
        oauthApi.setModule("iam");
        oauthApi.setMethod("GET");
        OauthApi result = this.oauthApiRepository.findFirstByModuleAndApi(oauthApi.getModule(), oauthApi.getApi());
        if (result == null) {
            result = (OauthApi)this.oauthApiRepository.save((Object)oauthApi);
        }
        if (!(oauthScope = this.oauthScopeRepository.findAll()).isEmpty()) {
            OauthApi finalResult = result;
            oauthScope.forEach(o -> {
                OauthScopeApi oauthScopeApi = new OauthScopeApi();
                oauthScopeApi.setScopeSid(o.getSid());
                oauthScopeApi.setApiSid(finalResult.getSid());
                OauthScopeApi oldOauthScopeApi = this.oauthScopeApiRepository.findFirstByScopeSidAndApiSid(oauthScopeApi.getScopeSid(), oauthScopeApi.getApiSid());
                if (oldOauthScopeApi == null) {
                    this.oauthScopeApiRepository.save((Object)oauthScopeApi);
                }
            });
        }
    }
}

