/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.datapolicy.ActionIdEnum;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataTypeEnum;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchema;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchemaField;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaFieldRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43702)
@Service
public class UpgradeDatabaseV43701ToV43702Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43701ToV43702Service.class);
    @Autowired
    private DataPolicySchemaRepository dataPolicySchemaRepository;
    @Autowired
    private DataPolicySchemaFieldRepository dataPolicySchemaFieldRepository;
    @Autowired
    private EnvProperties envProperties;

    public String version() {
        return "4.37.2.0";
    }

    public void update() {
        LOGGER.info("437200\uff0c\u5347\u7ea7\u5f00\u59cb --->>>");
        this.createDataPolicySchema();
        LOGGER.info("437200\uff0c\u5347\u7ea7\u7ed3\u675f <<<---");
    }

    private void createDataPolicySchema() {
        try {
            DataPolicySchemaField field;
            DataPolicySchema schema = this.dataPolicySchemaRepository.findByActionIdAndTableId(ActionIdEnum.BOSS_API_PRODUCT_SUBSCRIBE.getId(), "statistic_invoke_log");
            if (null == schema) {
                schema = new DataPolicySchema(ActionIdEnum.BOSS_API_PRODUCT_SUBSCRIBE.getId(), "statistic_invoke_log", "API\u8c03\u7528\u7edf\u8ba1", "API\u8abf\u7528\u7d71\u8a08", "API INVOKE COUNT");
                schema.setSid(SnowFlake.getInstance().newId());
                EntityUtils.setCreateFields((BaseEntity)schema);
                this.dataPolicySchemaRepository.save((Object)schema);
            }
            if (null == (field = this.dataPolicySchemaFieldRepository.findByIdAndSchemaSid("productTenantId", Long.valueOf(schema.getSid())))) {
                field = new DataPolicySchemaField("productTenantId", "\u5f52\u5c5e\u5f00\u53d1\u5546\u79df\u6237", "\u6b78\u5c6c\u958b\u767c\u5546\u79df\u6236", "Developer's Tenant", DataTypeEnum.STRING.toString(), Integer.valueOf(1), "eq", this.envProperties.getIamUri() + "/api/iam/v2/tenant/code/item", schema.getSid());
                EntityUtils.setCreateFields((BaseEntity)field);
                this.dataPolicySchemaFieldRepository.save((Object)field);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u6570\u636e\u6743\u9650\u5143\u6570\u636e\u5347\u7ea7\u5931\u8d25" + e);
        }
    }
}

