/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.WhiteList;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43703)
@Service
public class UpgradeDatabaseV43702ToV43703Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43702ToV43703Service.class);
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;

    public String version() {
        return "4.37.3.0";
    }

    public void update() {
        LOGGER.info("437300\uff0c\u5347\u7ea7\u5f00\u59cb --->>>");
        this.updateDict();
        this.updateDevSysInTenant();
        LOGGER.info("437300\uff0c\u5347\u7ea7\u7ed3\u675f <<<---");
    }

    private void updateDict() {
        DictDataDTO condition = new DictDataDTO();
        String comeFrom = "source_type";
        String key = "ServiceCloud-A1";
        condition.setDictId(comeFrom);
        condition.setDictKey(key);
        DictData dictData = this.dictDataService.selectDictData(condition);
        if (dictData == null) {
            DictData data = new DictData();
            data.setDictId(comeFrom);
            data.setDictKey(key);
            data.setDictValue("\u670d\u52a1\u4e91-A1");
            this.dictDataService.insertDictData(data);
        }
    }

    private void updateDevSysInTenant() {
        Sys sys;
        List appIdList = this.whiteListService.getWhiteList("WHITE_LIST_AUTO_AUTH_TENANT_APPS");
        if (!appIdList.contains("dev")) {
            appIdList.add("dev");
            WhiteList body = new WhiteList();
            body.setId("WHITE_LIST_AUTO_AUTH_TENANT_APPS");
            body.setContent(String.join((CharSequence)";", appIdList));
            LOGGER.info("\u66f4\u65b0\u767d\u540d\u5355\uff1a{}", (Object)body.getContent());
            this.whiteListService.insertOrUpdateWhiteList(body);
        }
        if ((sys = (Sys)this.sysRepository.findById("dev")) == null) {
            LOGGER.warn("dev \u5e94\u7528\u4e0d\u5b58\u5728\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0...");
            return;
        }
        List sids = this.tenantMapper.getSidsByAppSidNotInSysInTenant(Long.valueOf(sys.getSid()));
        LOGGER.info("\u9700\u8981\u66f4\u65b0\u7684\u79df\u6237sids.size() = {}", (Object)sids.size());
        ArrayList<SysInTenant> sysInTenants = new ArrayList<SysInTenant>();
        for (Long tenantSid : sids) {
            SysInTenant sysInTenant = new SysInTenant();
            sysInTenant.setSysSid(sys.getSid());
            sysInTenant.setTenantSid(tenantSid.longValue());
            sysInTenant.setTokenExpire(sys.getTokenExpire());
            sysInTenants.add(sysInTenant);
        }
        if (!sysInTenants.isEmpty()) {
            this.sysInTenantCrudService.saveAll(sysInTenants);
        }
    }
}

