/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.iam.constant.enums.TeamEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Order(value=43704)
@Service
public class UpgradeDatabaseV43703ToV43704Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43703ToV43704Service.class);
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private DictDataService dictDataService;

    public String version() {
        return "4.37.4.0";
    }

    public void update() {
        LOGGER.info("437400\uff0c\u5347\u7ea7\u5f00\u59cb --->>>");
        this.updateTenantEnterpriseType();
        this.updateTenantTeam();
        this.updateDictData();
        LOGGER.info("437400\uff0c\u5347\u7ea7\u7ed3\u675f <<<---");
    }

    private void updateDictData() {
        DictDataDTO condition = new DictDataDTO();
        String dictId = "source_type";
        String key = "DIXC";
        condition.setDictId(dictId);
        condition.setDictKey(key);
        DictData dictData = this.dictDataService.selectDictData(condition);
        if (dictData == null) {
            DictData data = new DictData();
            data.setDictId(dictId);
            data.setDictKey(key);
            data.setDictValue("\u4f53\u9a8c\u4e2d\u5fc3");
            this.dictDataService.insertDictData(data);
        }
    }

    private void updateTenantEnterpriseType() {
        Specification & Serializable condition = (Specification & Serializable)(root, query, cb) -> {
            Predicate predicate = cb.conjunction();
            predicate.getExpressions().add(root.get("enterpriseType").in(Arrays.asList(2, 3, 4)));
            return predicate;
        };
        List tenants = this.tenantRepository.findAll((Specification)condition);
        if (CollectionUtils.isEmpty((Collection)tenants)) {
            return;
        }
        LOGGER.info("\u66f4\u65b0\u79df\u6237\u7c7b\u578b\u7684\u6570\u91cf\u4e3a: {}", (Object)tenants.size());
        Iterator iterator = tenants.iterator();
        while (iterator.hasNext()) {
            Tenant tenant = (Tenant)iterator.next();
            if (Integer.valueOf(2).equals(tenant.getEnterpriseType())) {
                tenant.setEnterpriseType(TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue());
                continue;
            }
            if (Arrays.asList(3, 4).contains(tenant.getEnterpriseType())) {
                tenant.setEnterpriseType(TenantEnterpriseTypeEnum.ENTERPRISE_TENANT.getValue());
                continue;
            }
            iterator.remove();
        }
        this.tenantRepository.saveAll((Iterable)tenants);
    }

    private void updateTenantTeam() {
        Specification & Serializable condition = (Specification & Serializable)(root, query, cb) -> {
            Predicate predicate = cb.conjunction();
            predicate.getExpressions().add(cb.equal((Expression)root.get("enterpriseType"), (Object)0));
            predicate.getExpressions().add(cb.equal((Expression)root.get("teamId"), (Object)TeamEnum.INTERNAL_ISV.getId()));
            return predicate;
        };
        List tenants = this.tenantRepository.findAll((Specification)condition);
        if (CollectionUtils.isEmpty((Collection)tenants)) {
            return;
        }
        LOGGER.info("\u66f4\u65b0\u79df\u6237\u56e2\u961f\u7c7b\u578b\u7684\u6570\u91cf\u4e3a: {}", (Object)tenants.size());
        tenants.forEach(tenant -> tenant.setTeamId(TeamEnum.SELF_DEV_ENTERPRISE_CUSTOMERS.getId()));
        this.tenantRepository.saveAll((Iterable)tenants);
    }
}

