/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.WhiteList;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43705)
@Service
public class UpgradeDatabaseV43704ToV43705Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43704ToV43705Service.class);
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private DictService dictService;
    @Autowired
    private DictDataService dictDataService;

    public String version() {
        return "4.37.5.0";
    }

    public void update() {
        LOGGER.info("437500\uff0c\u5347\u7ea7\u5f00\u59cb --->>>");
        this.updateWhiteList();
        Sys sys = (Sys)this.sysCrudService.findById("dev");
        if (sys != null) {
            sys.setDoubleCheck(true);
            this.sysCrudService.update((BaseEntity)sys);
        }
        this.updateTenantVersion();
        this.createDict();
        LOGGER.info("437500\uff0c\u5347\u7ea7\u7ed3\u675f <<<---");
    }

    private void updateWhiteList() {
        List notSyncAdminTenants = this.whiteListService.getWhiteList("THIRD_NOT_SYNC_ADMIN_TENANTS");
        if (!notSyncAdminTenants.contains("88888888")) {
            notSyncAdminTenants.add("88888888");
            WhiteList body = new WhiteList();
            body.setId("THIRD_NOT_SYNC_ADMIN_TENANTS");
            body.setName("\u7b2c\u4e09\u65b9\u5e73\u53f0\u4e0d\u540c\u6b65\u7ba1\u7406\u5458\u7684\u79df\u6237");
            body.setContent(String.join((CharSequence)";", notSyncAdminTenants));
            LOGGER.info("\u66f4\u65b0\u767d\u540d\u5355\uff1a{}", (Object)body.getContent());
            this.whiteListService.insertOrUpdateWhiteList(body);
        }
    }

    private void updateTenantVersion() {
        this.tenantMapper.updateVersion();
    }

    private void createDict() {
        Dict dict = this.dictService.selectDictById("user_purpose");
        if (null == dict) {
            dict = new Dict();
            dict.setSid(SnowFlake.getInstance().newId());
            dict.setId("user_purpose");
            dict.setName("\u7528\u6237\u7528\u9014");
            this.dictService.insertDict(dict);
        }
        DictDataDTO condition = new DictDataDTO();
        condition.setDictId("user_purpose");
        List dictDataList = this.dictDataService.selectDictDataList(condition);
        this.insertDictData(dictDataList, "formal", "\u4e00\u822c\u7528\u6237", Integer.valueOf(0));
        this.insertDictData(dictDataList, "test", "\u6d4b\u8bd5", Integer.valueOf(1));
    }

    private void insertDictData(List<DictData> dictDataList, String dictKey, String dictValue, Integer sort) {
        if (!dictDataList.stream().anyMatch(d -> d.getDictKey().equals(dictKey))) {
            DictData data = new DictData();
            data.setDictId("user_purpose");
            data.setDictKey(dictKey);
            data.setDictValue(dictValue);
            data.setDictSort(sort);
            this.dictDataService.insertDictData(data);
        }
    }
}

