/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43706)
@Service
public class UpgradeDatabaseV43705ToV43706Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43705ToV43706Service.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private TenantMapper tenantMapper;

    public String version() {
        return "4.37.6.0";
    }

    public void update() {
        LOGGER.info("437600\uff0c\u5347\u7ea7\u5f00\u59cb --->>>");
        this.createDict();
        this.userMapper.updateUserPurpose();
        this.tenantMapper.updateVersion();
        LOGGER.info("437600\uff0c\u5347\u7ea7\u7ed3\u675f <<<---");
    }

    private void createDict() {
        Dict dict = this.dictService.selectDictById("user_purpose");
        if (null == dict) {
            dict = new Dict();
            dict.setSid(SnowFlake.getInstance().newId());
            dict.setId("user_purpose");
            dict.setName("\u7528\u6237\u7528\u9014");
            this.dictService.insertDict(dict);
        }
        DictDataDTO condition = new DictDataDTO();
        condition.setDictId("user_purpose");
        List dictDataList = this.dictDataService.selectDictDataList(condition);
        this.insertDictData(dictDataList, "normal", "\u4e00\u822c\u7528\u6237", Integer.valueOf(0));
    }

    private void insertDictData(List<DictData> dictDataList, String dictKey, String dictValue, Integer sort) {
        DictData matchDictData;
        if (!dictDataList.stream().anyMatch(d -> d.getDictKey().equals(dictKey))) {
            DictData data = new DictData();
            data.setDictId("user_purpose");
            data.setDictKey(dictKey);
            data.setDictValue(dictValue);
            data.setDictSort(sort);
            this.dictDataService.insertDictData(data);
        }
        if (null != (matchDictData = (DictData)dictDataList.stream().filter(d -> "formal".equalsIgnoreCase(d.getDictKey())).findFirst().orElse(null))) {
            this.dictDataService.deleteDictDataBySid(Long.valueOf(matchDictData.getSid()));
        }
    }
}

