/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middle.stream.domain.SysNoticeEnum;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.constant.enums.IamSysNoticeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.SysNotice;
import com.digiwin.dap.middleware.iam.entity.SysNoticeType;
import com.digiwin.dap.middleware.iam.entity.WhiteList;
import com.digiwin.dap.middleware.iam.repository.WhiteListRepository;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeCrudService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeTypeCrudService;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.MailTypeEnum;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.EnvUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43707)
@Service
public class UpgradeDatabaseV43706ToV43707Service
extends AbstractUpdateDatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeDatabaseV43706ToV43707Service.class);
    @Autowired
    private WhiteListRepository whiteListRepository;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private SysNoticeCrudService sysNoticeCrudService;
    @Autowired
    private SysNoticeTypeCrudService sysNoticeTypeCrudService;
    @Autowired
    private DictService dictService;
    @Autowired
    private DictDataService dictDataService;

    public String version() {
        return "4.37.7.0";
    }

    public void update() {
        LOGGER.info("43707\u6570\u636e\u5347\u7ea7\u5f00\u59cb -->>>");
        this.createWhiteList();
        this.initSysNotice();
        this.initSysNoticeInLanding();
        this.createDictData();
        LOGGER.info("43707\u6570\u636e\u5347\u7ea7\u7ed3\u675f <<<---");
    }

    private void createDictData() {
        DictData data;
        Dict dict = this.dictService.selectDictById(MailTypeEnum.PASSWORD_SEND.name());
        if (null == dict) {
            dict = new Dict();
            dict.setId(MailTypeEnum.PASSWORD_SEND.name());
            dict.setName("\u4f01\u4e1a\u7528\u6237\u53d1\u9001\u5bc6\u7801");
            this.dictService.insertDict(dict);
        }
        if (null == (data = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.PASSWORD_SEND.name(), "athena")))) {
            data = new DictData();
            data.setDictId(MailTypeEnum.PASSWORD_SEND.name());
            data.setDictKey("athena");
            data.setDictValue(MailTypeEnum.ATHENA_PASSWORD_SEND.name());
            this.dictDataService.insertDictData(data);
        }
        if (null == (dict = this.dictService.selectDictById(MailTypeEnum.INVITE_DIGIWIN_USER_REGISTER.name()))) {
            dict = new Dict();
            dict.setId(MailTypeEnum.INVITE_DIGIWIN_USER_REGISTER.name());
            dict.setName("\u9080\u8bf7\u9f0e\u6377\u7528\u6237\u52a0\u5165\u79df\u6237");
            this.dictService.insertDict(dict);
        }
        if (null == (data = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.INVITE_DIGIWIN_USER_REGISTER.name(), "athena")))) {
            data = new DictData();
            data.setDictId(MailTypeEnum.INVITE_DIGIWIN_USER_REGISTER.name());
            data.setDictKey("athena");
            data.setDictValue(MailTypeEnum.ATHENA_DIGIWIN_USER_REGISTER.name());
            this.dictDataService.insertDictData(data);
        }
        if (null == (data = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.INVITE_DIGIWIN_USER_REGISTER.name(), "dev")))) {
            data = new DictData();
            data.setDictId(MailTypeEnum.INVITE_DIGIWIN_USER_REGISTER.name());
            data.setDictKey("dev");
            data.setDictValue(MailTypeEnum.DEV_INVITE_DIGIWIN_USER_LOGIN.name());
            this.dictDataService.insertDictData(data);
        }
        if (null == (data = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.INVITE_DIGIWIN_USER_REGISTER.name(), "ISV")))) {
            data = new DictData();
            data.setDictId(MailTypeEnum.INVITE_DIGIWIN_USER_REGISTER.name());
            data.setDictKey("ISV");
            data.setDictValue(MailTypeEnum.ISV_INVITE_DIGIWIN_USER_LOGIN.name());
            this.dictDataService.insertDictData(data);
        }
        if (null == (dict = this.dictService.selectDictById(MailTypeEnum.INVITE_USER_REGISTER.name()))) {
            dict = new Dict();
            dict.setId(MailTypeEnum.INVITE_USER_REGISTER.name());
            dict.setName("\u9080\u8bf7\u9f0e\u6377\u7528\u6237\u6ce8\u518c\u5e76\u4e14\u52a0\u5165\u79df\u6237");
            this.dictService.insertDict(dict);
        }
        if (null == (data = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.INVITE_USER_REGISTER.name(), "athena")))) {
            data = new DictData();
            data.setDictId(MailTypeEnum.INVITE_USER_REGISTER.name());
            data.setDictKey("athena");
            data.setDictValue(MailTypeEnum.ATHENA_INVITE_USER_REGISTER.name());
            this.dictDataService.insertDictData(data);
        }
        if (null == (dict = this.dictService.selectDictById(MailTypeEnum.INVITE_USER_LOGIN.name()))) {
            dict = new Dict();
            dict.setId(MailTypeEnum.INVITE_USER_LOGIN.name());
            dict.setName("\u9080\u8bf7\u7528\u6237\u767b\u5f55\u52a0\u5165");
            this.dictService.insertDict(dict);
        }
        if (null == (data = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.INVITE_USER_LOGIN.name(), "athena")))) {
            data = new DictData();
            data.setDictId(MailTypeEnum.INVITE_USER_LOGIN.name());
            data.setDictKey("athena");
            data.setDictValue(MailTypeEnum.ATHENA_INVITE_USER_LOGIN.name());
            this.dictDataService.insertDictData(data);
        }
        if (null == (dict = this.dictService.selectDictById(MailTypeEnum.USER_APPLY_JOIN_TENANT.name()))) {
            dict = new Dict();
            dict.setId(MailTypeEnum.USER_APPLY_JOIN_TENANT.name());
            dict.setName("\u7528\u6237\u7533\u8bf7\u52a0\u5165\u79df\u6237");
            this.dictService.insertDict(dict);
        }
        if (null == (data = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.USER_APPLY_JOIN_TENANT.name(), "athena")))) {
            data = new DictData();
            data.setDictId(MailTypeEnum.USER_APPLY_JOIN_TENANT.name());
            data.setDictKey("athena");
            data.setDictValue(MailTypeEnum.ATHENA_USER_APPLY_JOIN_TENANT.name());
            this.dictDataService.insertDictData(data);
        }
    }

    private void initSysNoticeInLanding() {
        if (0 != this.envProperties.getCloud()) {
            ArrayList<SysNoticeType> sysNotices = new ArrayList<SysNoticeType>();
            for (SysNoticeEnum notice : SysNoticeEnum.values()) {
                SysNoticeType sysNoticeType;
                if (SysNoticeEnum.APP_EXPIRED.equals((Object)notice)) {
                    sysNoticeType = new SysNoticeType();
                    sysNoticeType.setId(notice.name());
                    sysNoticeType.setPath(notice.path());
                    sysNoticeType.setDescription("\u5e94\u7528\u8fc7\u671f\u901a\u77e5");
                    sysNotices.add(sysNoticeType);
                    continue;
                }
                if (SysNoticeEnum.EMP_DISABLE.equals((Object)notice)) {
                    sysNoticeType = new SysNoticeType();
                    sysNoticeType.setId(notice.name());
                    sysNoticeType.setPath(notice.path());
                    sysNoticeType.setDescription("\u5458\u5de5\u505c\u7528\u901a\u77e5");
                    sysNotices.add(sysNoticeType);
                    continue;
                }
                if (SysNoticeEnum.APP_MONTHLY.equals((Object)notice)) {
                    sysNoticeType = new SysNoticeType();
                    sysNoticeType.setId(notice.name());
                    sysNoticeType.setPath(notice.path());
                    sysNoticeType.setDescription("\u5305\u6708\u6392\u7a0b\u5f00\u901a\u901a\u77e5");
                    sysNotices.add(sysNoticeType);
                    continue;
                }
                if (SysNoticeEnum.AUTH_USER.equals((Object)notice)) {
                    sysNoticeType = new SysNoticeType();
                    sysNoticeType.setId(notice.name());
                    sysNoticeType.setPath(notice.path());
                    sysNoticeType.setDescription("\u9489\u9489\u7528\u6237\u6388\u6743\u5e94\u7528\u901a\u77e5");
                    sysNotices.add(sysNoticeType);
                    continue;
                }
                if (!SysNoticeEnum.DELETE_CORP.equals((Object)notice)) continue;
                sysNoticeType = new SysNoticeType();
                sysNoticeType.setId(notice.name());
                sysNoticeType.setPath(notice.path());
                sysNoticeType.setDescription("\u5220\u9664\u8fd0\u8425\u5355\u5143\u901a\u77e5");
                sysNotices.add(sysNoticeType);
            }
            this.sysNoticeTypeCrudService.saveAll(sysNotices);
        }
    }

    private void createWhiteList() {
        List whiteLists = this.whiteListRepository.findById("WHITE_LIST_APP_MANAGER_USER");
        if (whiteLists.isEmpty()) {
            WhiteList whiteList = new WhiteList();
            whiteList.setId("WHITE_LIST_APP_MANAGER_USER");
            whiteList.setName("mmc\u7f16\u8f91\u6240\u5c5e\u79df\u6237\u767d\u540d\u5355");
            whiteList.setContent("emmabi@digiwin.com;lihy0217@digiwin.com");
            EntityUtils.setCreateFields((BaseEntity)whiteList);
            this.whiteListRepository.save((Object)whiteList);
        } else {
            WhiteList whiteList = (WhiteList)whiteLists.get(0);
            List contents = whiteLists.stream().map(WhiteList::getContent).collect(Collectors.toList());
            if (!contents.stream().anyMatch(c -> c.contains("emmabi@digiwin.com;lihy0217@digiwin.com"))) {
                whiteList.setContent(String.format("%s;emmabi@digiwin.com;lihy0217@digiwin.com", whiteList.getContent()));
                EntityUtils.setModifyFields((BaseEntity)whiteList);
                this.whiteListRepository.save((Object)whiteList);
            }
        }
    }

    private void initSysNotice() {
        DeployAreaEnum currentArea = DeployAreaEnum.get((String)this.envProperties.getDeployArea());
        if (currentArea == null) {
            LOGGER.error("\u83b7\u53d6\u5f53\u524d\u90e8\u7f72\u533a\u57df\u5931\u8d25\uff0cDeployArea\uff1a{}\uff0c\u9000\u51fa\u540c\u6b65\u79df\u6237", (Object)this.envProperties.getDeployArea());
            return;
        }
        if (!Arrays.asList(DeployAreaEnum.AliyunProd, DeployAreaEnum.AzureProd).contains(currentArea)) {
            LOGGER.info("\u5f53\u524d\u90e8\u7f72\u533a\u57df\u4e3a{}\uff0c\u975e\u963f\u91cc\u4e91\u6216Azure\u751f\u4ea7\u73af\u5883\uff0c\u4e0d\u8fdb\u884c\u5e94\u7528\u901a\u77e5\u4e8b\u4ef6\u7684\u521d\u59cb\u5316", (Object)currentArea);
            return;
        }
        List internalList = this.sysNoticeCrudService.findBySysIdAndTypeId("INTERNAL_IAM", IamSysNoticeEnum.INTELLY_INTERNAL_TENANT_SYNC.name());
        List internaBackUrilList = internalList.stream().map(SysNotice::getBackUri).collect(Collectors.toList());
        List externalList = this.sysNoticeCrudService.findBySysIdAndTypeId("INTERNAL_IAM", IamSysNoticeEnum.INTELLY_EXTERNAL_TENANT_SYNC.name());
        List externalBackUriList = externalList.stream().map(SysNotice::getBackUri).collect(Collectors.toList());
        ArrayList<DeployAreaEnum> allAreas = new ArrayList<DeployAreaEnum>(Arrays.asList(DeployAreaEnum.AliyunTest, DeployAreaEnum.AliyunProd, DeployAreaEnum.AzureTest, DeployAreaEnum.AzureProd));
        allAreas.remove(currentArea);
        ArrayList<SysNotice> saveList = new ArrayList<SysNotice>();
        for (DeployAreaEnum anEnum : allAreas) {
            String backUri = EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)anEnum);
            if (internaBackUrilList.contains(backUri)) continue;
            SysNotice sysNotice = new SysNotice();
            sysNotice.setSysId("INTERNAL_IAM");
            sysNotice.setTypeId(IamSysNoticeEnum.INTELLY_INTERNAL_TENANT_SYNC.name());
            sysNotice.setPath("/api/iam/v2/tenant/intelly/sync");
            sysNotice.setEnable(true);
            sysNotice.setBackUri(backUri);
            sysNotice.setDescription(IamSysNoticeEnum.INTELLY_INTERNAL_TENANT_SYNC.getDesc());
            saveList.add(sysNotice);
        }
        List testAreaList = allAreas.stream().filter(x -> currentArea.getCloud().equals((Object)x.getCloud())).collect(Collectors.toList());
        for (DeployAreaEnum anEnum : testAreaList) {
            String backUri = EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)anEnum);
            if (externalBackUriList.contains(backUri)) continue;
            SysNotice sysNotice = new SysNotice();
            sysNotice.setSysId("INTERNAL_IAM");
            sysNotice.setTypeId(IamSysNoticeEnum.INTELLY_EXTERNAL_TENANT_SYNC.name());
            sysNotice.setPath("/api/iam/v2/tenant/intelly/sync");
            sysNotice.setEnable(true);
            sysNotice.setBackUri(EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)anEnum));
            sysNotice.setDescription(IamSysNoticeEnum.INTELLY_EXTERNAL_TENANT_SYNC.getDesc());
            saveList.add(sysNotice);
        }
        if (saveList.isEmpty()) {
            return;
        }
        this.sysNoticeCrudService.saveAll(saveList);
    }
}

