/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.datapolicy.ActionIdEnum;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchema;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchemaField;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.SourceType;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaFieldRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaRepository;
import com.digiwin.dap.middleware.iam.repository.RoleRepository;
import com.digiwin.dap.middleware.iam.service.source.SourceTypeCrudService;
import com.digiwin.dap.middleware.iam.util.SqlUtil;
import com.digiwin.dap.middleware.language.entity.LanguageResource;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=40400)
@Service
public class UpgradeDatabaseV43ToV44Service
extends AbstractUpdateDatabaseService {
    private static final String HASH = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43ToV44Service.class);
    @Autowired
    private DataPolicySchemaRepository dataPolicySchemaRepository;
    @Autowired
    private DataPolicySchemaFieldRepository dataPolicySchemaFieldRepository;
    @Autowired
    private SourceTypeCrudService sourceTypeCrudService;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private RoleRepository roleRepository;

    public String version() {
        return "4.4.0.0000";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        try {
            DataPolicySchemaField dataPolicySchemaField;
            DataPolicySchema dataPolicySchema = this.dataPolicySchemaRepository.findByActionIdAndTableId(ActionIdEnum.BOSS_NOTIFIER_MANAGEMENT.getId(), "notifier");
            if (dataPolicySchema != null && (dataPolicySchemaField = this.dataPolicySchemaFieldRepository.findByIdAndSchemaSid("appId", Long.valueOf(dataPolicySchema.getSid()))) != null) {
                String valueParam = "{\"zh-CN\":[{\"id\":\"Athena\",\"name\":\"\u96c5\u5178\u5a1c\"},{\"id\":\"dev\",\"name\":\"\u5f00\u53d1\u8005\u95e8\u6237\"},{\"id\":\"DigiwinCloud\",\"name\":\"\u4e91\u5e02\u573a\"},{\"id\":\"Servicer\",\"name\":\"\u670d\u52a1\u5546\"},{\"id\":\"ASSC\",\"name\":\"\u552e\u540e\u4e91\"}],\"zh-TW\":[{\"id\":\"Athena\",\"name\":\"\u96c5\u5178\u5a1c\"},{\"id\":\"dev\",\"name\":\"\u958b\u767c\u8005\u9580\u6236\"},{\"id\":\"DigiwinCloud\",\"name\":\"\u96f2\u5e02\u5834\"},{\"id\":\"Servicer\",\"name\":\"\u670d\u52d9\u5546\"},{\"id\":\"ASSC\",\"name\":\"\u552e\u5f8c\u96f2\"}],\"en-US\":[{\"id\":\"Athena\",\"name\":\"Athena\"},{\"id\":\"dev\",\"name\":\"dev\"},{\"id\":\"DigiwinCloud\",\"name\":\"DigiwinCloud\"},{\"id\":\"Servicer\",\"name\":\"Servicer\"},{\"id\":\"ASSC\",\"name\":\"ASSC\"}]}";
                dataPolicySchemaField.setValueParams(valueParam);
                EntityUtils.setModifyFields((BaseEntity)dataPolicySchemaField);
                this.dataPolicySchemaFieldRepository.save((Object)dataPolicySchemaField);
            }
            this.createSourceTypes();
            this.updateDefaultRoleMultiLanguage();
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private void createSourceTypes() {
        this.createSourceType("ServiceCloud", "\u670d\u52a1\u4e91", "\u670d\u52d9\u4e91", "ServiceCloud");
        this.createSourceType("DigiwinCloud", "\u9f0e\u6377\u4e91", "\u9f0e\u6377\u4e91", "DigiwinCloud");
        this.createSourceType("HuaWei", "\u534e\u4e3a", "\u83ef\u70ba", "HuaWei");
        this.createSourceType("digiwin-ad", "\u9f0e\u6377\u4e91AD", "\u9f0e\u6377\u4e91AD", "DigiwinCloud AD");
        this.createSourceType("BOSS", "BOSS", "BOSS", "BOSS");
        this.createSourceType("wechat", "\u5fae\u4fe1", "\u5fae\u4fe1", "wechat");
        this.createSourceType("fii", "fii", "fii", "wechat");
        this.createSourceType("E1", "E1", "E1", "E1");
    }

    private void createSourceType(String id, String name, String nameTW, String nameUS) {
        SourceType sourceType = new SourceType();
        sourceType.setId(id);
        sourceType.setName(name);
        long sid = this.sourceTypeCrudService.create((BaseEntity)sourceType);
        ArrayList<LanguageResource> languageResources = new ArrayList<LanguageResource>();
        LanguageResource languageResource = new LanguageResource(sid, "roleName", name, "zh-CN");
        languageResources.add(languageResource);
        languageResource = new LanguageResource(sid, "roleName", nameTW, "zh-TW");
        languageResources.add(languageResource);
        languageResource = new LanguageResource(sid, "roleName", nameUS, "en-US");
        languageResources.add(languageResource);
        this.languageCrudService.insertAll(languageResources);
    }

    private void updateDefaultRoleMultiLanguage() {
        List roles = this.roleRepository.findById("superadmin");
        this.batchUpdate(roles, "\u8d85\u7ea7\u7ba1\u7406\u5458", "\u8d85\u7d1a\u7ba1\u7406\u54e1", "super admin");
        roles = this.roleRepository.findById("integration");
        this.batchUpdate(roles, "\u96c6\u6210\u89d2\u8272", "\u96c6\u6210\u89d2\u8272", "integration");
        roles = this.roleRepository.findById("KanBanSchedule");
        this.batchUpdate(roles, "\u770b\u677f\u8c03\u5ea6\u89d2\u8272", "\u770b\u677f\u8abf\u5ea6\u89d2\u8272", "KanBan Schedule");
        roles = this.roleRepository.findById("endUser");
        this.batchUpdate(roles, "\u4e00\u822c\u7528\u6237", "\u4e00\u822c\u7528\u6236", "common user");
        roles = this.roleRepository.findById("superUser");
        this.batchUpdate(roles, "\u8fdb\u9636\u7528\u6237", "\u9032\u968e\u7528\u6236", "advanced user");
        roles = this.roleRepository.findById("mis");
        this.batchUpdate(roles, "\u7ba1\u7406\u8005", "\u7ba1\u7406\u8005", "manager");
    }

    private void batchUpdate(List<Role> roles, String name, String nameTW, String nameUS) {
        LinkedHashMap<String, String> mapSql = new LinkedHashMap<String, String>(3);
        mapSql.put("multi_language_resource", "insert into multi_language_resource(sid,data_sid,field_name,content,language,hash) values");
        ArrayList roleInsertValues = new ArrayList();
        roles.forEach(role -> {
            roleInsertValues.add(String.format("(%s,%s,'roleName','%s','%s','%s'),", SnowFlake.getInstance().newId(), role.getSid(), name, "zh-CN", HASH));
            roleInsertValues.add(String.format("(%s,%s,'roleName','%s','%s','%s'),", SnowFlake.getInstance().newId(), role.getSid(), nameTW, "zh-TW", HASH));
            roleInsertValues.add(String.format("(%s,%s,'roleName','%s','%s','%s'),", SnowFlake.getInstance().newId(), role.getSid(), nameUS, "en-US", HASH));
        });
        LinkedHashMap mapValue = new LinkedHashMap(3);
        mapValue.put("multi_language_resource", roleInsertValues);
        List resultSql = SqlUtil.packageSql(mapSql, mapValue);
        logger.info(String.format("\u66f4\u65b0%s\u7b14\u6570\u636e", roleInsertValues.size()));
        for (String result : resultSql) {
            this.jdbcTemplate.execute(result);
        }
    }
}

