/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.WhiteList;
import com.digiwin.dap.middleware.iam.repository.WhiteListRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=40700)
@Service
public class UpgradeDatabaseV46ToV47Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV46ToV47Service.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private WhiteListRepository whiteListRepository;

    public String version() {
        return "4.7.0.0000";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        try {
            this.updateUserCellPhone();
            this.createGroundUri();
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private void updateUserCellPhone() {
        try {
            String sql = "TW".equals(this.envProperties.getCountry()) ? "update user set cellphone_prefix='+886' where (cellphone_prefix is null or cellphone_prefix='') and telephone  like '0%'  and  length(telephone)=10;" : "update user set cellphone_prefix='+86' where (cellphone_prefix is null or cellphone_prefix='')  and telephone  like '1%'  and  length(telephone)=11;";
            this.jdbcTemplate.update(sql);
            logger.info(String.format("\u56fd\u7801\u9ed8\u8ba4\u503c\u6570\u636e\u5347\u7ea7\u7ed3\u675f\uff0c\u5347\u7ea7\u8bed\u53e5\uff1a%s", sql));
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private void createGroundUri() {
        List whiteLists = this.whiteListRepository.findById("WHITE_GROUND_IAM_URI");
        if (whiteLists == null || whiteLists.size() == 0) {
            WhiteList whiteList = new WhiteList();
            whiteList.setId("WHITE_GROUND_IAM_URI");
            whiteList.setName("\u5730\u7aefiam\u5730\u5740");
            whiteList.setContent("/api/permission/data/values;/api/permission/data/schemas;");
            EntityUtils.setCreateFields((BaseEntity)whiteList);
            this.whiteListRepository.save((Object)whiteList);
        }
    }
}

