/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.entity.WhiteList;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.DevSysRepository;
import com.digiwin.dap.middleware.iam.repository.UserInTenantRepository;
import com.digiwin.dap.middleware.iam.repository.WhiteListRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Order(value=40800)
@Service
public class UpgradeDatabaseV47ToV48Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV47ToV48Service.class);
    private static int version48 = 408000000;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DevSysRepository devSysRepository;
    @Autowired
    private WhiteListRepository whiteListRepository;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserInTenantRepository userInTenantRepository;

    public String version() {
        return "4.8.0.0000";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        try {
            this.createBOSSWhiteApiUri();
            this.updateAesUser();
            this.updateDevSysSysCategory();
            this.updateUserInTenantDueDate();
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private void updateUserInTenantDueDate() {
        List users = this.userMapper.getUsersByNotDueDate(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
        if (!CollectionUtils.isEmpty((Collection)users)) {
            for (User user : users) {
                List userInTenants = this.userInTenantRepository.findByUserSid(Long.valueOf(user.getSid()));
                if (CollectionUtils.isEmpty((Collection)userInTenants)) continue;
                for (UserInTenant userInTenant : userInTenants) {
                    userInTenant.setDueDate(user.getDueDate());
                }
                this.userInTenantRepository.update((Iterable)userInTenants);
            }
        }
    }

    private void updateDevSysSysCategory() {
        List devSysList = this.devSysRepository.findAll();
        for (DevSys devSys : devSysList) {
            if (devSys.getSysCategory() != null) continue;
            devSys.setSysCategory(Integer.valueOf(0));
        }
        this.devSysRepository.update((Iterable)devSysList);
    }

    private void createBOSSWhiteApiUri() {
        List whiteLists = this.whiteListRepository.findById("WHITE_BOSS_API_URIS");
        if (whiteLists == null || whiteLists.size() == 0) {
            WhiteList whiteList = new WhiteList();
            whiteList.setId("WHITE_BOSS_API_URIS");
            whiteList.setName("BOSS\u767d\u540d\u5355\u63a5\u53e3\u5730\u5740");
            whiteList.setContent("/api/permission/data/values;/api/permission/data/schemas;/api/boss/v1/users/check/user/tenant/auth;/api/boss/v1/users/enterprise");
            EntityUtils.setCreateFields((BaseEntity)whiteList);
            this.whiteListRepository.save((Object)whiteList);
        }
    }

    private void updateAesUser() {
        logger.error(">>>> user name telephone \u52a0\u5bc6\u5347\u7ea7\u5f00\u59cb");
        String aseUserSql = "update user set name = HEX(AES_ENCRYPT(name, '${aesKey}')),telephone= = HEX(AES_ENCRYPT(telephone,'${aesKey}'))";
        this.jdbcTemplate.update(aseUserSql);
        logger.error("SQL\u6267\u884c\u5b8c\u6bd5 {}", (Object)aseUserSql);
        this.redisTemplate.opsForValue().set((Object)"iam:middleware:version", (Object)version48, Duration.ofDays(90L));
        Object newRedisVersion = this.redisTemplate.opsForValue().get((Object)"iam:middleware:version");
        logger.error("Redis\u7f13\u5b58\u8bbe\u7f6e\u5b8c\u6bd5 {}={}", (Object)"iam:middleware:version", newRedisVersion);
        logger.error("<<<< user name telephone \u52a0\u5bc6\u5347\u7ea7\u7ed3\u675f");
    }
}

