/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.dump.upgrade;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.datapolicy.ActionIdEnum;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataTypeEnum;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchema;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchemaField;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaFieldRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaRepository;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicySchemaCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=40900)
@Service
public class UpgradeDatabaseV48ToV49Service
extends AbstractUpdateDatabaseService {
    private static final String HASH = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV48ToV49Service.class);
    @Autowired
    private DataPolicySchemaRepository dataPolicySchemaRepository;
    @Autowired
    private DataPolicySchemaFieldRepository dataPolicySchemaFieldRepository;
    @Autowired
    private DataPolicySchemaCrudService dataPolicySchemaCrudService;
    @Autowired
    private EnvProperties envProperties;

    public String version() {
        return "4.9.0.0000";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        try {
            DataPolicySchemaField dataPolicySchemaField;
            DataPolicySchema dataPolicySchema = this.dataPolicySchemaRepository.findByActionIdAndTableId(ActionIdEnum.ISV_GOODS.getId(), "goods");
            if (dataPolicySchema == null) {
                dataPolicySchema = new DataPolicySchema();
                dataPolicySchema.setActionId(ActionIdEnum.ISV_GOODS.getId());
                dataPolicySchema.setTableId("goods");
                dataPolicySchema.setTableName("\u5546\u54c1\u7ba1\u7406");
                dataPolicySchema.setTableNameTW("\u5546\u54c1\u7ba1\u7406");
                dataPolicySchema.setTableNameUS("Goods Management");
                long dataSchemaSid = this.dataPolicySchemaCrudService.create((BaseEntity)dataPolicySchema);
                dataPolicySchema.setSid(dataSchemaSid);
            }
            if ((dataPolicySchemaField = this.dataPolicySchemaFieldRepository.findByIdAndSchemaSid("goodsCode", Long.valueOf(dataPolicySchema.getSid()))) == null) {
                String apiUri1 = String.format("%s/api/gmc/v2/goods/code/item", this.envProperties.getGmcUri());
                dataPolicySchemaField = this.createSchemaFieldEntity(dataPolicySchema.getSid(), "goodsCode", "\u5546\u54c1\u7f16\u7801", "\u5546\u54c1\u7de8\u78bc", "goods code", Integer.valueOf(1), apiUri1);
                this.dataPolicySchemaFieldRepository.save((Object)dataPolicySchemaField);
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private DataPolicySchemaField createSchemaFieldEntity(long schemaSid, String id, String name, String nameTW, String nameUS, Integer dataSource, String values) {
        DataPolicySchemaField dataPolicySchemaField = new DataPolicySchemaField();
        dataPolicySchemaField.setSchemaSid(schemaSid);
        dataPolicySchemaField.setId(id);
        dataPolicySchemaField.setName(name);
        dataPolicySchemaField.setNameTW(nameTW);
        dataPolicySchemaField.setNameUS(nameUS);
        dataPolicySchemaField.setDataType(DataTypeEnum.STRING.toString());
        dataPolicySchemaField.setDataSource(dataSource);
        dataPolicySchemaField.setFilterType("in");
        dataPolicySchemaField.setValueParams(values);
        return dataPolicySchemaField;
    }
}

