/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.ram.impl;

import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.web.MappingRegistry;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import com.digiwin.dap.middleware.iam.domain.auth.AccessTenant;
import com.digiwin.dap.middleware.iam.domain.auth.AccessUser;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.entity.ServiceTenantTrustRelation;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysCrudService;
import com.digiwin.dap.middleware.iam.service.permission.AuthService;
import com.digiwin.dap.middleware.iam.service.service.permission.SpTenantTrustRelationService;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.ram.AccessSecurityService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessSecurityServiceImpl
implements AccessSecurityService {
    @Autowired
    private CacService cacService;
    @Autowired
    private AuthService authService;
    @Autowired(required=false)
    private RamCoreService ramCoreService;
    @Autowired
    private CommonCacheService commonCacheService;
    @Autowired
    private DevSysCrudService devSysCrudService;
    @Autowired
    private SpTenantTrustRelationService spTenantTrustRelationService;

    public boolean noneCheck(String appId, String method, String path) {
        MappingRegistry mappingRegistry = this.ramCoreService.getPattern(appId, "None");
        PatternVO matched = MatcherUtils.matches((String)method, (String)path, (MappingRegistry)mappingRegistry);
        if (matched != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void serviceCheck(AccessUser accessUser) {
        MappingRegistry mappingRegistry = this.ramCoreService.getPattern(accessUser.getAppId());
        PatternVO pattern = MatcherUtils.matches((String)accessUser.getMethod(), (String)accessUser.path(), (MappingRegistry)mappingRegistry);
        if (pattern != null) {
            List actionIds = this.ramCoreService.findPolicyIdByRoute(accessUser.getSysId(), PolicyType.Function.name(), pattern.getMethod(), pattern.path());
            boolean match = this.getPolicyIds(accessUser).stream().anyMatch(actionIds::contains);
            if (match) {
                return;
            }
        }
        String errMsg = String.format("\u7528\u6237[%s]\u6ca1\u6709\u8bbf\u95ee\u5e94\u7528[%s]\u63a5\u53e3[%s-%s](%s)\u6743\u9650", accessUser.getUserId(), accessUser.getAppId(), accessUser.getMethod(), accessUser.getPath(), accessUser.getTableName());
        throw new UnauthorizedException((ErrorHandler)CommonErrorCode.USER_TOKEN_INVALID, errMsg);
    }

    public boolean trustChainCheck(AccessTenant accessTenant) {
        DevSys accessSys = (DevSys)this.devSysCrudService.findById(accessTenant.getSysId());
        DevSys apiSys = (DevSys)this.devSysCrudService.findById(accessTenant.getAppId());
        if (apiSys == null) {
            throw new UnauthorizedException((ErrorHandler)CommonErrorCode.USER_TOKEN_INVALID);
        }
        if (accessSys != null && Objects.equals(accessSys.getTenantSid(), apiSys.getTenantSid())) {
            return true;
        }
        if (accessTenant.getTenantSid() == apiSys.getTenantSid().longValue()) {
            return true;
        }
        ServiceTenantTrustRelation tenantTrustRelation = this.spTenantTrustRelationService.findByOwnerSidAndTargetId(apiSys.getTenantSid().longValue(), accessTenant.getTenantSid());
        return tenantTrustRelation != null;
    }

    public void authCheck(AccessTenant accessTenant) {
        List policyIds = this.getPolicyIds(accessTenant);
        if (!policyIds.isEmpty()) {
            MappingRegistry mappingRegistry = this.ramCoreService.getPattern(accessTenant.getAppId());
            PatternVO pattern = MatcherUtils.matches((String)accessTenant.getMethod(), (String)accessTenant.getPath(), (MappingRegistry)mappingRegistry);
            if (pattern != null) {
                List actionIds = this.ramCoreService.findPolicyIdByRoute(accessTenant.getSysId(), PolicyType.Function.name(), pattern.getMethod(), pattern.getPath());
                boolean match = policyIds.stream().anyMatch(actionIds::contains);
                if (match) {
                    return;
                }
            }
        }
        String errMsg = String.format("\u79df\u6237[%s]\u6ca1\u6709\u8bbf\u95ee\u5e94\u7528[%s]\u63a5\u53e3[%s-%s]\u6743\u9650", accessTenant.getTenantId(), accessTenant.getAppId(), accessTenant.getMethod(), accessTenant.getPath());
        throw new UnauthorizedException((ErrorHandler)CommonErrorCode.USER_TOKEN_INVALID, errMsg);
    }

    private List<String> getPolicyIds(AccessTenant accessTenant) {
        ArrayList<String> policyIds = new ArrayList<String>();
        policyIds.add("drn:iam:app:" + accessTenant.getAppId());
        AuthorizationResultVO authorization = this.cacService.queryAllAuthorization(accessTenant.getTenantId(), accessTenant.getAppId());
        if (authorization != null) {
            List moduleIds = authorization.getEnabledModules().stream().filter(p -> LocalDateTime.now().isBefore(p.getExpiredTime())).map(p -> "drn:iam:app:" + accessTenant.getAppId() + ":" + p.getId()).collect(Collectors.toList());
            policyIds.addAll(moduleIds);
        }
        return policyIds;
    }

    private List<String> getPolicyIds(AccessUser accessUser) {
        return new ArrayList<String>();
    }
}

