/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.ram.impl;

import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.support.iam.DefaultRamHandlerSupport;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.iam.domain.permission.CalcUser;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionPolicy;
import com.digiwin.dap.middleware.iam.domain.permission.UserPermissionResult;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuEffect;
import com.digiwin.dap.middleware.iam.domain.sys.tree.SysNode;
import com.digiwin.dap.middleware.iam.service.auth.AppAuthCheckService;
import com.digiwin.dap.middleware.iam.service.permission.AuthActionService;
import com.digiwin.dap.middleware.iam.service.permission.AuthService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthCheckServiceImpl
extends DefaultRamHandlerSupport {
    @Autowired
    private AuthService authService;
    @Autowired
    private AuthActionService authActionService;
    @Autowired
    private AppAuthCheckService appAuthCheckService;

    public AuthResult getAuthResult(AuthResult authResult, AccessUser request) {
        return this.appAuthCheckService.getAppAuth(request.isPlatform(), request.getSysId(), request.getTenantId(), request.getUserId(), authResult.getTenants());
    }

    public List<String> getUserFunction(AccessUser request) {
        CalcUser calcUser = new CalcUser();
        calcUser.setUserSid(request.getUserSid());
        calcUser.setUserId(request.getUserId());
        calcUser.setTenantSid(request.getTenantSid());
        calcUser.setTenantId(request.getTenantId());
        calcUser.setAppSid(request.getSysSid());
        calcUser.setAppId(request.getSysId());
        calcUser.setInside(request.isInside());
        SysNode sysData = this.authActionService.getSysData(calcUser);
        UserPermissionResult userPermission = this.authService.getUserPermission(calcUser, sysData);
        List permissions = this.authService.fillAction(calcUser, sysData, userPermission, MenuEffect.allow);
        return this.uris(request.getSysId(), permissions);
    }

    public List<String> uris(String app, List<PermissionPolicy> permissions) {
        ArrayList<String> uris = new ArrayList<String>();
        if (permissions.isEmpty()) {
            return uris;
        }
        String appId = "drn:iam:app:" + app;
        uris.add(appId);
        List moduleIds = permissions.stream().map(p -> appId + ":" + p.getModuleId()).distinct().collect(Collectors.toList());
        uris.addAll(moduleIds);
        permissions.forEach(action -> {
            uris.add(action.getTarget());
            action.getConditions().forEach((key, value) -> value.entrySet().stream().filter(condition -> "allow".equals(condition.getValue())).map(condition -> key + ":" + (String)condition.getKey()).forEach(uris::add));
        });
        return uris;
    }
}

