/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.ram.impl;

import com.digiwin.dap.middle.ram.domain.enums.PolicyCategory;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.RouteVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.GrantCond;
import com.digiwin.dap.middle.ram.domain.vo.condition.GrantPolicyCond;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyCond;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyRouteCond;
import com.digiwin.dap.middle.ram.domain.vo.condition.RouteCond;
import com.digiwin.dap.middle.ram.entity.BaseEntity;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.mapper.RamGrantMapper;
import com.digiwin.dap.middle.ram.mapper.RamGrantPolicyMapper;
import com.digiwin.dap.middle.ram.mapper.RamPolicyMapper;
import com.digiwin.dap.middle.ram.mapper.RamRouteMapper;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.service.base.RamRouteCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder;
import com.digiwin.dap.middle.ram.support.security.auth.AuthPolicyHandler;
import com.digiwin.dap.middle.ram.util.WebUtils;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.ram.RamUpgradePolicyDTO;
import com.digiwin.dap.middleware.iam.domain.service.permission.MetadataApiVO;
import com.digiwin.dap.middleware.iam.domain.tenant.GroundNoAuthUserVO;
import com.digiwin.dap.middleware.iam.mapper.RamMapper;
import com.digiwin.dap.middleware.iam.support.auth.RamService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteRamUpgradeService;
import com.digiwin.dap.middleware.util.EnvUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Primary
@ConditionalOnProperty(prefix="dap.middleware.ram", value={"version"}, havingValue="v1")
@Service
public class RamJarServiceImpl
implements RamService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RamJarServiceImpl.class);
    public static final String IAM_RAM_POLICY = "iam:ram:*";
    public static final long MILLIS = 3000L;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RamMapper ramMapper;
    @Autowired(required=false)
    private AuthPolicyHandler authCheckHandler;
    @Autowired(required=false)
    private RamCacheService ramCacheService;
    @Autowired(required=false)
    private RamCoreService ramCoreService;
    @Autowired(required=false)
    private RamGrantMapper ramGrantMapper;
    @Autowired(required=false)
    private RamGrantCrudService ramGrantCrudService;
    @Autowired(required=false)
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;
    @Autowired(required=false)
    private RamPolicyCrudService ramPolicyCrudService;
    @Autowired(required=false)
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;
    @Autowired(required=false)
    private RamRouteCrudService ramRouteCrudService;
    @Autowired
    private RemoteRamUpgradeService remoteRamUpgradeService;
    @Autowired(required=false)
    private RamRouteMapper ramRouteMapper;
    @Autowired(required=false)
    private RamPolicyMapper ramPolicyMapper;
    @Autowired(required=false)
    private RamGrantPolicyMapper ramGrantPolicyMapper;

    public boolean targetCanAccessPath(String targetType, String targetId, String method, String path) {
        List whiteTargetIds = this.ramCoreService.findTargetIdByRoute("middleware", PolicyType.AcrossTenant.toString(), targetType, method, path);
        return whiteTargetIds.contains(targetId);
    }

    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys) {
        HttpServletRequest request = WebUtils.getRequest();
        AccessUser accessUser = new AccessUser();
        if (request != null) {
            accessUser.setAppId(this.envProperties.getAppName());
            accessUser.setMethod(request.getMethod());
            accessUser.setPath(request.getRequestURI());
        }
        accessUser.of(user, sys);
        accessUser.setAuthResult(authResult);
        return this.authCheckHandler.process(authResult, accessUser);
    }

    public Map<String, Boolean> processAuth(String userId, List<String> tenantIds, AuthoredSys sys) {
        HttpServletRequest request = WebUtils.getRequest();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        AuthoredUser authoredUser = new AuthoredUser();
        authoredUser.setUserId(userId);
        tenantIds.forEach(tenantId -> {
            AccessUser accessUser = new AccessUser();
            if (request != null) {
                accessUser.setAppId(this.envProperties.getAppName());
                accessUser.setMethod(request.getMethod());
                accessUser.setPath(request.getRequestURI());
            }
            authoredUser.setTenantId(tenantId);
            accessUser.of(authoredUser, sys);
            accessUser.setAuthResult(AuthResult.of());
            AuthResult authResult = this.authCheckHandler.process(accessUser.getAuthResult(), accessUser);
            result.put((String)tenantId, authResult.ok());
        });
        return result;
    }

    private Policy savePolicyNone(String appId) {
        Policy policy = new Policy();
        policy.setApp(appId);
        policy.setCategory(Integer.valueOf(PolicyCategory.Standard.ordinal()));
        policy.setType("None");
        policy.setId(String.format("NonePolicy:%s", appId));
        policy.setName(appId);
        this.ramPolicyCrudService.insert((BaseEntity)policy);
        return policy;
    }

    private Policy savePolicyFunction(String appId, String policyId, String policyName) {
        Policy policy = new Policy();
        policy.setApp(appId);
        policy.setCategory(Integer.valueOf(PolicyCategory.Function.ordinal()));
        policy.setType(PolicyType.Function.name());
        policy.setId(policyId);
        policy.setName(policyName);
        this.ramPolicyCrudService.insert((BaseEntity)policy);
        return policy;
    }

    private void savePolicyRoute(long policySid, long routeSid) {
        PolicyRoute policyRoute = new PolicyRoute();
        policyRoute.setPolicySid(policySid);
        policyRoute.setRouteSid(routeSid);
        policyRoute.setEffect(true);
        this.ramPolicyRouteCrudService.insert((BaseEntity)policyRoute);
    }

    private long saveRoute(MetadataApiVO api) {
        Route route = new Route();
        route.setApp(api.getApp());
        route.setMethod(api.getMethod());
        route.setPath(StringUtils.isEmpty((Object)api.getTableName()) ? api.getPath() : api.getPath() + "/" + api.getTableName());
        route.setName(api.getDisplayName());
        route.setRemark(api.getRemark());
        route.setTableName(api.getTableName());
        return this.ramRouteCrudService.insert((BaseEntity)route);
    }

    public void createRouteWithPolicy(String appId, String policyId, String policyName, List<MetadataApiVO> apiList) {
        if (apiList.isEmpty()) {
            return;
        }
        Policy policy = this.ramMapper.findPolicyById(policyId);
        if (policy == null) {
            policy = this.savePolicyFunction(appId, policyId, policyName);
        }
        Map<String, List<MetadataApiVO>> appApiList = apiList.stream().collect(Collectors.groupingBy(MetadataApiVO::getApp));
        for (Map.Entry<String, List<MetadataApiVO>> app : appApiList.entrySet()) {
            String apiAppId = app.getKey();
            List routes = this.ramMapper.findRoutesByAppId(apiAppId);
            List functionApiList = app.getValue().stream().filter(o -> o.getAnonymous() == false).collect(Collectors.toList());
            this.savePolicyRoute(appId, policy.getSid().longValue(), functionApiList, routes);
            List noneApiList = app.getValue().stream().filter(MetadataApiVO::getAnonymous).collect(Collectors.toList());
            if (!noneApiList.isEmpty()) {
                Policy nonePolicy = this.ramMapper.findPolicyByType(apiAppId, "None");
                if (nonePolicy == null) {
                    nonePolicy = this.savePolicyNone(apiAppId);
                }
                this.savePolicyRoute(appId, nonePolicy.getSid().longValue(), noneApiList, routes);
                RedisUtils.delete((String)CacheKeyBuilder.getRouteByPolicyType((String)"iam", (String)apiAppId, (String)"None"));
            }
            RedisUtils.delete((String)CacheKeyBuilder.getRouteByApp((String)"iam", (String)apiAppId));
        }
    }

    private void savePolicyRoute(String appId, long policySid, List<MetadataApiVO> apiList, List<Route> routes) {
        List policyRoutes = this.ramMapper.findPolicyRoutesByPolicy(Long.valueOf(policySid));
        for (MetadataApiVO api : apiList) {
            long routeSid;
            Optional<Route> route = routes.stream().filter(r -> r.getApp().equalsIgnoreCase(api.getApp()) && r.getMethod().equalsIgnoreCase(api.getMethod()) && r.getPath().equals(api.getPath())).findFirst();
            if (route.isPresent()) {
                routeSid = route.get().getSid();
                boolean exists = policyRoutes.removeIf(p -> p.getRouteSid() == routeSid);
                if (exists) {
                    this.ramMapper.updateDeteted(Long.valueOf(policySid), Long.valueOf(routeSid), false);
                } else {
                    this.savePolicyRoute(policySid, routeSid);
                }
            } else {
                routeSid = this.saveRoute(api);
                this.savePolicyRoute(policySid, routeSid);
            }
            RedisUtils.delete((String)CacheKeyBuilder.getPolicyByPath((String)"iam", (String)appId, (String)api.getMethod(), (String)api.getPath()));
        }
        for (PolicyRoute policyRoute : policyRoutes) {
            this.ramMapper.updateDeteted(Long.valueOf(policySid), Long.valueOf(policyRoute.getRouteSid()), true);
        }
    }

    public com.digiwin.dap.middleware.domain.PageData<?> getGoodsRelatedApis(String uri, Boolean showAll, Integer pageNum, Integer pageSize) {
        List ramPolicyRouteVOS = showAll != false ? this.ramMapper.findByPolicyId(uri, uri, pageNum, pageSize) : this.ramMapper.findByPolicyId(uri, null, pageNum, pageSize);
        PageSerializable page = new PageSerializable(ramPolicyRouteVOS);
        return com.digiwin.dap.middleware.domain.PageData.data((long)page.getTotal(), (List)page.getList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void configureNoAuthUser(GroundNoAuthUserVO vo) {
        if (this.envProperties.isCloud()) {
            return;
        }
        String targetId = vo.getTenantId() + "-" + vo.getGoodsCode();
        GrantCond condition = new GrantCond();
        condition.setTargetId(targetId);
        List found = this.ramGrantMapper.findByCond(condition);
        long grantSid = found.stream().filter(a -> a.getTargetId().equals(targetId)).map(GrantVO::getSid).findFirst().orElseGet(() -> {
            Grant createOne = new Grant();
            createOne.setTargetId(targetId);
            createOne.setApp("middleware");
            createOne.setType("TenantSys");
            return this.ramGrantCrudService.insert((BaseEntity)createOne);
        });
        List policiesFound = this.ramGrantPolicyCrudService.findByGrantSid(grantSid);
        Optional<PolicyVO> optionalPolicyVO = policiesFound.stream().filter(a -> a.getId().equals("NoAuthUser")).findFirst();
        if (Boolean.TRUE.equals(vo.getChecked())) {
            if (!optionalPolicyVO.isPresent()) {
                PolicyCond policyCondition = new PolicyCond();
                policyCondition.setId("NoAuthUser");
                List policies = this.ramPolicyCrudService.findByCond(policyCondition);
                PolicyVO policy = (PolicyVO)policies.stream().findFirst().orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.IAM_DATA_NOT_EXIST));
                GrantPolicy grantPolicy = new GrantPolicy();
                grantPolicy.setGrantSid(grantSid);
                grantPolicy.setPolicySid(policy.getSid().longValue());
                this.ramGrantPolicyCrudService.insert((BaseEntity)grantPolicy);
            }
        } else {
            optionalPolicyVO.ifPresent(policyVO -> this.ramGrantPolicyCrudService.deleteBySid(policyVO.getSid().longValue()));
        }
        this.ramCacheService.grantPolicyChange(grantSid);
    }

    public boolean findNoAuthUser(GroundNoAuthUserVO vo) {
        String targetId = vo.getTenantId() + "-" + vo.getGoodsCode();
        GrantCond condition = new GrantCond();
        condition.setTargetId(targetId);
        List found = this.ramGrantMapper.findByCond(condition);
        Optional<GrantVO> first = found.stream().filter(a -> a.getTargetId().equals(targetId)).findFirst();
        if (!first.isPresent()) {
            return false;
        }
        Long grantSid = first.get().getSid();
        List policiesFound = this.ramGrantPolicyCrudService.findByGrantSid(grantSid.longValue());
        Optional<PolicyVO> optionalPolicyVO = policiesFound.stream().filter(a -> a.getId().equals("NoAuthUser")).findFirst();
        return optionalPolicyVO.isPresent();
    }

    public void upgradeCloudAreaPolicy(RamUpgradePolicyDTO dto) {
        DeployAreaEnum areaEnum = DeployAreaEnum.get((String)dto.getSourceCloudArea());
        if (areaEnum == null) {
            throw new BusinessException(String.format("\u83b7\u53d6\u4e91\u533a[%s]\u5931\u8d25", dto.getSourceCloudArea()));
        }
        String ramUri = EnvUtils.getUri((CommonCode)CommonCode.RAM, (DeployAreaEnum)areaEnum);
        LOGGER.info("\u5347\u7ea7iam-ram\u7b56\u7565\u6743\u9650\uff1a\u6765\u6e90 = {}\uff0c ramUri= {}", (Object)areaEnum, (Object)ramUri);
        this.syncRoute(dto, ramUri);
        this.sleepMillis();
        this.syncGrant(dto, ramUri);
        this.sleepMillis();
        this.syncPolicy(dto, ramUri);
        this.sleepMillis();
        this.syncGrantPolicy(dto, ramUri);
        this.sleepMillis();
        this.syncPolicyRoute(dto, ramUri);
        this.sleepMillis();
        LOGGER.info("6.\u6e05\u9664\u7b56\u7565\u6743\u9650\u7f13\u5b58 {} ...", (Object)IAM_RAM_POLICY);
        RedisUtils.delete((String)IAM_RAM_POLICY);
        LOGGER.info("6.\u6e05\u9664\u7b56\u7565\u6743\u9650\u7f13\u5b58 \u5b8c\u6210");
    }

    private void syncPolicyRoute(RamUpgradePolicyDTO dto, String ramUri) {
        LOGGER.info("5.\u540c\u6b65\u8def\u7531\u4e0e\u7b56\u7565\u5173\u7cfb...");
        com.digiwin.dap.middleware.domain.PageData policyRoutePage = this.remoteRamUpgradeService.searchPolicyRoute(dto, ramUri);
        LOGGER.info("5.\u540c\u6b65\u8def\u7531\u4e0e\u7b56\u7565\u5173\u7cfb size() = {}", (Object)policyRoutePage.getTotal());
        long total = 0L;
        if (policyRoutePage.getTotal() > 0L) {
            PolicyRouteCond page = new PolicyRouteCond();
            page.setPageNum(1);
            page.setPageSize(99999);
            PageData oldPage = this.ramPolicyRouteCrudService.findByPage(page);
            for (RouteVO data : policyRoutePage.getList()) {
                boolean anyMatch = oldPage.getList().stream().anyMatch(x -> Objects.equals(x.getPolicyId(), data.getPolicyId()) && Objects.equals(x.getApp(), data.getApp()) && Objects.equals(x.getMethod(), data.getMethod()) && Objects.equals(x.getPath(), data.getPath()));
                if (anyMatch) continue;
                RouteCond cond = new RouteCond();
                cond.setApp(data.getApp());
                cond.setMethod(data.getMethod());
                cond.setPath(data.getPath());
                List oldRouteList = this.ramRouteCrudService.findByCond(cond);
                PolicyCond cond3 = new PolicyCond();
                cond3.setId(data.getPolicyId());
                List oldPlicyList = this.ramPolicyCrudService.findByCond(cond3);
                if (oldRouteList.isEmpty() || oldPlicyList.isEmpty()) continue;
                PolicyRoute policyRoute = new PolicyRoute();
                policyRoute.setSid(data.getPolicyRouteSid());
                policyRoute.setRouteSid(((RouteVO)oldRouteList.get(0)).getSid().longValue());
                policyRoute.setPolicySid(((PolicyVO)oldPlicyList.get(0)).getSid().longValue());
                policyRoute.setEffect(data.getEffect().booleanValue());
                policyRoute.setCreateDate(data.getAttachDate());
                policyRoute.setCreateById(UserUtils.getUserId());
                policyRoute.setModifyDate(LocalDateTime.now());
                this.ramPolicyRouteCrudService.insert((BaseEntity)policyRoute);
                ++total;
            }
        }
        LOGGER.info("5.\u540c\u6b65\u5bf9\u8c61\u4e0e\u7b56\u7565\u5173\u7cfb \u5b8c\u6210 \u63d2\u5165{}\u6761", (Object)total);
    }

    private void syncGrantPolicy(RamUpgradePolicyDTO dto, String ramUri) {
        LOGGER.info("4.\u540c\u6b65\u5bf9\u8c61\u4e0e\u7b56\u7565\u5173\u7cfb...");
        com.digiwin.dap.middleware.domain.PageData grantPolicyPage = this.remoteRamUpgradeService.searchGrantPolicy(dto, ramUri);
        LOGGER.info("4.\u540c\u6b65\u5bf9\u8c61\u4e0e\u7b56\u7565\u5173\u7cfb size() = {}", (Object)grantPolicyPage.getTotal());
        long total = 0L;
        if (grantPolicyPage.getTotal() > 0L) {
            GrantPolicyCond page = new GrantPolicyCond();
            page.setPageNum(1);
            page.setPageSize(99999);
            PageData oldPage = this.ramGrantPolicyCrudService.findByPage(page);
            for (GrantVO data : grantPolicyPage.getList()) {
                boolean anyMatch = oldPage.getList().stream().anyMatch(x -> Objects.equals(x.getPolicyId(), data.getPolicyId()) && Objects.equals(x.getType(), data.getType()) && Objects.equals(x.getTargetId(), data.getTargetId()));
                if (anyMatch) continue;
                GrantCond cond2 = new GrantCond();
                cond2.setType(data.getType());
                cond2.setTargetId(data.getTargetId());
                List oldGrantList = this.ramGrantCrudService.findByCond(cond2);
                PolicyCond cond3 = new PolicyCond();
                cond3.setId(data.getPolicyId());
                List oldPlicyList = this.ramPolicyCrudService.findByCond(cond3);
                if (oldGrantList.isEmpty() || oldPlicyList.isEmpty()) continue;
                GrantPolicy grantPolicy = new GrantPolicy();
                grantPolicy.setSid(data.getSid());
                grantPolicy.setGrantSid(((GrantVO)oldGrantList.get(0)).getSid().longValue());
                grantPolicy.setPolicySid(((PolicyVO)oldPlicyList.get(0)).getSid().longValue());
                grantPolicy.setCreateDate(data.getAttachDate());
                grantPolicy.setModifyDate(LocalDateTime.now());
                grantPolicy.setCreateById(UserUtils.getUserId());
                this.ramGrantPolicyMapper.insert(grantPolicy);
                ++total;
            }
        }
        LOGGER.info("4.\u540c\u6b65\u5bf9\u8c61\u4e0e\u7b56\u7565\u5173\u7cfb \u5b8c\u6210 \u63d2\u5165{}\u6761", (Object)total);
    }

    private void syncPolicy(RamUpgradePolicyDTO dto, String ramUri) {
        LOGGER.info("3.\u540c\u6b65\u7b56\u7565...");
        List policyList = this.remoteRamUpgradeService.findPolicy(dto, ramUri);
        LOGGER.info("3.\u540c\u6b65\u7b56\u7565 size() = {}", (Object)policyList.size());
        long total = 0L;
        for (Policy data : policyList) {
            PolicyCond cond3 = new PolicyCond();
            cond3.setId(data.getId());
            List list = this.ramPolicyCrudService.findByCond(cond3);
            if (!list.isEmpty()) continue;
            data.setCreateById(Optional.ofNullable(data.getCreateById()).orElse(UserUtils.getUserId()));
            data.setModifyDate(LocalDateTime.now());
            this.ramPolicyMapper.insert(data);
            ++total;
        }
        LOGGER.info("3.\u540c\u6b65\u7b56\u7565 \u5b8c\u6210 \u63d2\u5165{}\u6761", (Object)total);
    }

    private void syncGrant(RamUpgradePolicyDTO dto, String ramUri) {
        LOGGER.info("2.\u540c\u6b65\u5bf9\u8c61...");
        List grantList = this.remoteRamUpgradeService.findGrant(dto, ramUri);
        LOGGER.info("2.\u540c\u6b65\u5bf9\u8c61 size() = {}", (Object)grantList.size());
        long total = 0L;
        for (Grant data : grantList) {
            GrantCond cond2 = new GrantCond();
            cond2.setType(data.getType());
            cond2.setTargetId(data.getTargetId());
            List list = this.ramGrantCrudService.findByCond(cond2);
            if (!list.isEmpty()) continue;
            data.setCreateById(Optional.ofNullable(data.getCreateById()).orElse(UserUtils.getUserId()));
            data.setModifyDate(LocalDateTime.now());
            this.ramGrantMapper.insert(data);
            ++total;
        }
        LOGGER.info("2.\u540c\u6b65\u5bf9\u8c61 \u5b8c\u6210 \u63d2\u5165{}\u6761", (Object)total);
    }

    private void syncRoute(RamUpgradePolicyDTO dto, String ramUri) {
        LOGGER.info("1.\u540c\u6b65\u8def\u7531...");
        List routeList = this.remoteRamUpgradeService.findRoute(dto, ramUri);
        LOGGER.info("1.\u540c\u6b65\u8def\u7531 size() = {}", (Object)routeList.size());
        long total = 0L;
        for (Route data : routeList) {
            RouteCond cond = new RouteCond();
            cond.setApp(data.getApp());
            cond.setMethod(data.getMethod());
            cond.setPath(data.getPath());
            List list = this.ramRouteCrudService.findByCond(cond);
            if (!list.isEmpty()) continue;
            data.setCreateById(Optional.ofNullable(data.getCreateById()).orElse(UserUtils.getUserId()));
            data.setModifyDate(LocalDateTime.now());
            this.ramRouteMapper.insert(data);
            ++total;
        }
        LOGGER.info("1.\u540c\u6b65\u8def\u7531 \u5b8c\u6210 \u63d2\u5165{}\u6761", (Object)total);
    }

    private void sleepMillis() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

