/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.ram.impl;

import com.digiwin.dap.middle.ram.util.WebUtils;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.RamRequestInfo;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.PageData;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.service.permission.MetadataApiVO;
import com.digiwin.dap.middleware.iam.support.auth.RamService;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(prefix="dap.middleware.ram", value={"version"}, havingValue="v2")
@Service
public class RamRemoteServiceImpl
implements RamService {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DapHttpService dapHttpService;

    public boolean targetCanAccessPath(String targetType, String targetId, String method, String path) {
        return this.dapHttpService.policyAnalyze(targetType, targetId, method, path);
    }

    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys) {
        HttpServletRequest request = WebUtils.getRequest();
        RamRequestInfo requestInfo = new RamRequestInfo();
        if (request != null) {
            requestInfo.setAppId(this.envProperties.getAppName());
            requestInfo.setMethod(request.getMethod());
            requestInfo.setPath(request.getRequestURI());
        }
        requestInfo.of(user, sys);
        requestInfo.setAuthResult(authResult);
        return this.dapHttpService.authAnalyze(requestInfo);
    }

    public Map<String, Boolean> processAuth(String userId, List<String> tenantIds, AuthoredSys sys) {
        HttpServletRequest request = WebUtils.getRequest();
        HashMap requestInfos = new HashMap();
        AuthoredUser authoredUser = new AuthoredUser();
        authoredUser.setUserId(userId);
        tenantIds.forEach(tenantId -> {
            RamRequestInfo requestInfo = new RamRequestInfo();
            if (request != null) {
                requestInfo.setAppId(this.envProperties.getAppName());
                requestInfo.setMethod(request.getMethod());
                requestInfo.setPath(request.getRequestURI());
            }
            authoredUser.setTenantId(tenantId);
            requestInfo.of(authoredUser, sys);
            requestInfo.setAuthResult(AuthResult.of());
            requestInfos.put(tenantId, requestInfo);
        });
        String uri = this.envProperties.getRamUri() + "/api/ram/v2/access/auths/analyze";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity httpEntity = new HttpEntity(requestInfos, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            HashMap<String, Boolean> responseMap = new HashMap<String, Boolean>();
            ((Map)((StdData)response.getBody()).getData()).forEach((key, value) -> responseMap.put((String)key, value.ok()));
            return responseMap;
        }
        catch (Exception e) {
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.REMOTE_UNEXPECTED, uri, e);
        }
    }

    public void createRouteWithPolicy(String appId, String policyId, String policyName, List<MetadataApiVO> apiList) {
        String uri = this.envProperties.getRamUri() + "/api/ram/v2/policy/sync/function";
        try {
            if (apiList.isEmpty()) {
                return;
            }
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("app", appId);
            paramsMap.put("id", policyId);
            paramsMap.put("name", policyName);
            paramsMap.put("apiInfos", apiList);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity httpEntity = new HttpEntity(paramsMap, (MultiValueMap)headers);
            this.restTemplate.postForObject(uri, (Object)httpEntity, Object.class, new Object[0]);
        }
        catch (Exception e) {
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.REMOTE_UNEXPECTED, uri, e);
        }
    }

    public PageData<?> getGoodsRelatedApis(String targetUri, Boolean showAll, Integer pageNum, Integer pageSize) {
        String uri = this.envProperties.getRamUri() + "/api/ram/v2/pr/search";
        try {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("policyId", targetUri);
            paramsMap.put("showAll", showAll);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity httpEntity = new HttpEntity(paramsMap, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (PageData)((StdData)response.getBody()).getData();
        }
        catch (Exception e) {
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.REMOTE_UNEXPECTED, uri, e);
        }
    }
}

