/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.vo.RouteVO;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.PageData;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.iam.domain.ram.RamUpgradePolicyDTO;
import com.digiwin.dap.middleware.iam.support.remote.RemoteRamUpgradeService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RemoteRamUpgradeServiceImpl
implements RemoteRamUpgradeService {
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate dapRetryRestTemplate;
    @Autowired
    private RestTemplate restTemplate;

    public List<Route> findRoute(RamUpgradePolicyDTO dto, String ramUri) {
        String uri = ramUri + "/api/ram/v2/route/find";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, dto.getUserToken());
        HttpEntity request = new HttpEntity((Object)dto, (MultiValueMap)headers);
        ResponseEntity response = this.dapRetryRestTemplate.exchange(uri, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(Collections.emptyList());
    }

    public List<Grant> findGrant(RamUpgradePolicyDTO dto, String ramUri) {
        String uri = ramUri + "/api/ram/v2/grant/find";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, dto.getUserToken());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app", dto.getApp());
        params.put("beginDate", dto.getBeginDate());
        params.put("endDate", dto.getEndDate());
        params.put("policyApp", dto.getApp());
        params.put("policyTypes", dto.getTypes());
        HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity response = this.dapRetryRestTemplate.exchange(uri, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(Collections.emptyList());
    }

    public List<Policy> findPolicy(RamUpgradePolicyDTO dto, String ramUri) {
        String uri = ramUri + "/api/ram/v2/policy/find";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, dto.getUserToken());
        HttpEntity request = new HttpEntity((Object)dto, (MultiValueMap)headers);
        ResponseEntity response = this.dapRetryRestTemplate.exchange(uri, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(Collections.emptyList());
    }

    public PageData<GrantVO> searchGrantPolicy(RamUpgradePolicyDTO dto, String ramUri) {
        String uri = ramUri + "/api/ram/v2/gp/search";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, dto.getUserToken());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", 99999);
        params.put("pageNum", 1);
        params.put("policyApp", dto.getApp());
        params.put("beginDate", dto.getBeginDate());
        params.put("endDate", dto.getEndDate());
        params.put("policyTypes", dto.getTypes());
        HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity response = this.dapRetryRestTemplate.exchange(uri, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(PageData.zero());
    }

    public PageData<RouteVO> searchPolicyRoute(RamUpgradePolicyDTO dto, String ramUri) {
        String uri = ramUri + "/api/ram/v2/pr/search/route";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, dto.getUserToken());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", 99999);
        params.put("pageNum", 1);
        params.put("policyApp", dto.getApp());
        params.put("beginDate", dto.getBeginDate());
        params.put("endDate", dto.getEndDate());
        params.put("types", dto.getTypes());
        HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity response = this.dapRetryRestTemplate.exchange(uri, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(PageData.zero());
    }
}

