/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.schedule.impl;

import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.BaseEntity;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.constant.enums.BooleanStrEnum;
import com.digiwin.dap.middleware.iam.constant.enums.IntellyExperienceStatusEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantDataExportRecordStateEnum;
import com.digiwin.dap.middleware.iam.domain.authorization.code.ServiceAuthorizationCodeDTO;
import com.digiwin.dap.middleware.iam.domain.authorization.code.ServiceAuthorizationCodeVO;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordDTO;
import com.digiwin.dap.middleware.iam.domain.enumeration.StopTypeEnum;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperienceResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataLdapVO;
import com.digiwin.dap.middleware.iam.domain.user.UserTenantSimpleVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.IntellyMapper;
import com.digiwin.dap.middleware.iam.mapper.ServiceAuthorizationCodeMapper;
import com.digiwin.dap.middleware.iam.mapper.ServiceAuthorizationRecordMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.IntellyExperienceApplicationRepository;
import com.digiwin.dap.middleware.iam.repository.TenantDataExportRecordRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.service.authorization.code.ServiceAuthorizationCodeService;
import com.digiwin.dap.middleware.iam.service.service.authorization.record.ServiceAuthorizationRecordService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantDataExportRecordService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserService;
import com.digiwin.dap.middleware.iam.support.excel.IExcelService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.MiswsService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.domain.ResignedEmployeeDataVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ResignedEmployeeVO;
import com.digiwin.dap.middleware.iam.support.schedule.ScheduleTaskService;
import com.digiwin.dap.middleware.util.DateUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ScheduleTaskServiceImpl
implements ScheduleTaskService {
    public static final String TASK_ID_1 = "iam-schedule-task-01";
    public static final String TASK_ID_2 = "iam-schedule-task-02";
    public static final String TASK_ID_3 = "iam-schedule-task-03";
    public static final String TASK_ID_4 = "iam-schedule-task-04";
    public static final String TASK_ID_5 = "iam-schedule-task-05";
    public static final String TASK_ID_6 = "iam-schedule-task-06";
    public static final String TASK_ID_7 = "iam-schedule-task-07";
    public static final String TASK_ID_8 = "iam-schedule-task-08";
    public static final String TASK_ID_9 = "iam-schedule-task-09";
    public static final String TASK_ID_10 = "iam-schedule-task-10";
    public static final String TASK_ID_11 = "iam-schedule-task-11";
    private static final Logger logger = LoggerFactory.getLogger(ScheduleTaskServiceImpl.class);
    private static final String DIGIWIN_TENANT_ID = "99990000";
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private ServiceAuthorizationCodeMapper serviceAuthorizationCodeMapper;
    @Autowired
    private ServiceAuthorizationCodeService serviceAuthorizationCodeService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private TenantDataExportRecordService tenantDataExportRecordService;
    @Autowired
    private TenantDataExportRecordRepository tenantDataExportRecordRepository;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private DMC dmcClient;
    @Autowired
    private IExcelService excelService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private RemoteIamService remoteIamService;
    @Autowired
    private MiswsService miswsService;
    @Autowired
    private ServiceAuthorizationRecordMapper serviceAuthorizationRecordMapper;
    @Autowired
    private ServiceAuthorizationRecordService serviceAuthorizationRecordService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private UserService userService;
    @Autowired
    private IntellyMapper intellyMapper;
    @Autowired
    private IntellyExperienceApplicationRepository intellyExperienceApplicationRepository;

    @CacheLock(prefix="iam-schedule-task-01", expired=30L, autoDelete=false)
    @Scheduled(cron="0 15 0 1/1 * ?")
    public void stopServiceAuthorizationCode() {
        try {
            logger.info("\u6267\u884c[\u505c\u7528\u8fc7\u671f\u7684\u670d\u52a1\u6388\u6743\u7801\u4ee5\u53ca\u901a\u8fc7\u8be5\u6388\u6743\u7801\u52a0\u5165\u7684\u7528\u6237]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            ServiceAuthorizationCodeDTO dto = new ServiceAuthorizationCodeDTO();
            dto.setDisabled(Boolean.valueOf(false));
            dto.setStopDate(LocalDateTime.now());
            List authorizationCodeList = this.serviceAuthorizationCodeMapper.selectServiceAuthorizationCodeList(dto);
            logger.info("\u5f85\u505c\u7528\u6388\u6743\u7801 {}", authorizationCodeList.stream().map(ServiceAuthorizationCodeVO::getCode).collect(Collectors.toList()));
            authorizationCodeList.forEach(o -> {
                ServiceAuthorizationCodeDTO serviceAuthorizationCodeDTO = new ServiceAuthorizationCodeDTO();
                serviceAuthorizationCodeDTO.setCode(o.getCode());
                serviceAuthorizationCodeDTO.setTenantSid(o.getTenantSid());
                serviceAuthorizationCodeDTO.setStopType(StopTypeEnum.EXPIRED_STOP.getValue());
                this.serviceAuthorizationCodeService.stopCode(serviceAuthorizationCodeDTO);
            });
            List codes = authorizationCodeList.stream().map(ServiceAuthorizationCodeVO::getCode).collect(Collectors.toList());
            List recordDTOS = !codes.isEmpty() ? this.serviceAuthorizationRecordMapper.selectRecordsNotInCodes(codes, Boolean.valueOf(false), LocalDateTime.now()) : this.serviceAuthorizationRecordMapper.selectRecordsDisabled(Boolean.valueOf(false), LocalDateTime.now());
            Map<Long, List<ServiceAuthorizationRecordDTO>> recordMaps = recordDTOS.stream().collect(Collectors.groupingBy(ServiceAuthorizationRecordDTO::getTenantSid));
            for (Map.Entry<Long, List<ServiceAuthorizationRecordDTO>> record : recordMaps.entrySet()) {
                record.getValue().forEach(r -> {
                    r.setDisabled(Boolean.valueOf(true));
                    r.setStopType(Integer.valueOf(0));
                });
                this.serviceAuthorizationRecordService.batchModifyAgent(record.getValue(), record.getKey());
            }
        }
        catch (Exception e) {
            logger.error("\u505c\u7528\u8fc7\u671f\u7684\u670d\u52a1\u6388\u6743\u7801\u4ee5\u53ca\u901a\u8fc7\u8be5\u6388\u6743\u7801\u52a0\u5165\u7684\u7528\u6237", (Throwable)e);
        }
    }

    @CacheLock(prefix="iam-schedule-task-03", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 1/1 * ?")
    @Async
    @Transactional
    public void stopUserInTenantByDueDateTask() {
        try {
            logger.info("\u6267\u884c[\u6839\u636e\u6743\u9650\u5230\u671f\u65e5\u505c\u7528\u7528\u6237]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            List userInTenantList = this.userMapper.getUserInTenantByDueDateAndDisable(LocalDateTime.now());
            if (!CollectionUtils.isEmpty((Collection)userInTenantList)) {
                for (UserTenantSimpleVO userInTenant : userInTenantList) {
                    this.userInTenantCrudService.disable(userInTenant.getTenantSid().longValue(), userInTenant.getUserSid().longValue());
                }
                this.changeLogService.batchDisableUserChangeLogs(userInTenantList);
            }
            logger.info("\u5b8c\u6210[\u6839\u636e\u6743\u9650\u5230\u671f\u65e5\u505c\u7528\u7528\u6237]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6743\u9650\u5230\u671f\u65e5\u505c\u7528\u7528\u6237\u6392\u7a0b\u5931\u8d25", (Throwable)e);
        }
    }

    @Async
    @CacheLock(prefix="iam-schedule-task-04", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 1 1/1 * ?")
    public void deleteExpiredTenantExportDataTask() {
        try {
            logger.info("\u6267\u884c[\u522a\u9664\u5df2\u751f\u6210\u4e14\u5df2\u904e\u671f\u7684zip\u6a94]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: " + LocalDateTime.now());
            LocalDateTime expiredate = LocalDateTime.now().plusDays(-1L).withHour(23).withMinute(59).withSecond(59);
            List records = this.tenantDataExportRecordRepository.findByStateAndExpireDateLessThanEqual(TenantDataExportRecordStateEnum.COMPLETED.getValue(), expiredate);
            if (records != null && records.size() > 0) {
                records.stream().forEach(r -> r.setState(TenantDataExportRecordStateEnum.EXPIRED.getValue().intValue()));
                String urls = records.stream().map(r -> r.getUrl()).filter(StringUtils::hasLength).collect(Collectors.joining(","));
                String[] urlArry = urls.split(",");
                this.dmcClient.batchDelete(Arrays.asList(urlArry), null);
            }
            this.tenantDataExportRecordRepository.update((Iterable)records);
        }
        catch (Exception e) {
            logger.error("\u505c\u7528\u8fc7\u671f\u7684\u670d\u52a1\u6388\u6743\u7801\u4ee5\u53ca\u901a\u8fc7\u8be5\u6388\u6743\u7801\u52a0\u5165\u7684\u7528\u6237", (Throwable)e);
        }
    }

    @CacheLock(prefix="iam-schedule-task-05", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 2 1/1 * ?")
    @Async
    public void generateTenantExportDataTask() {
        try {
            logger.info("\u6267\u884c[\u751f\u6210\u79df\u6237\u5bfc\u51fa\u6570\u636e]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4:{}", (Object)LocalDateTime.now());
            List records = this.tenantMapper.findTenantDataExportRecordByState(TenantDataExportRecordStateEnum.IN_PROGRESS.getValue());
            if (!CollectionUtils.isEmpty((Collection)records)) {
                records.forEach(r -> {
                    try {
                        File roleFile;
                        File orgFile;
                        File userFile;
                        List fileList;
                        String url = "";
                        if (r.getUser().booleanValue() && (fileList = Stream.of(userFile = this.excelService.exportUserInfo(Long.valueOf(r.getTenantSid())), orgFile = this.excelService.exportUserOrgInfo(Long.valueOf(r.getTenantSid())), roleFile = this.excelService.exportUserRoleInfo(Long.valueOf(r.getTenantSid()))).filter(Objects::nonNull).collect(Collectors.toList())) != null && fileList.size() > 0) {
                            List userFileInfos = null;
                            userFileInfos = this.dmcClient.batchUpload(fileList);
                            if (null != userFileInfos && userFileInfos.size() > 0) {
                                url = userFileInfos.stream().map(BaseEntity::getId).collect(Collectors.joining(","));
                            }
                        }
                        if (r.getEoc().booleanValue()) {
                            String userToken = StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.remoteIamService.getUserToken(DIGIWIN_TENANT_ID) : UserUtils.getToken();
                            String eocFileIds = this.remoteEocService.exportAllInfo(Long.valueOf(r.getTenantSid()), userToken);
                            url = !StringUtils.isEmpty((Object)url) ? url + "," + eocFileIds : eocFileIds;
                        }
                        r.setUrl(url);
                        r.setState(TenantDataExportRecordStateEnum.COMPLETED.getValue().intValue());
                        this.tenantDataExportRecordService.update((com.digiwin.dap.middleware.entity.BaseEntity)r);
                        this.changeLogService.saveTenantExportDataChangeLogs(r, "\u751f\u6210\u6210\u529f", Boolean.valueOf(true));
                    }
                    catch (Exception e) {
                        logger.error("\u751f\u6210\u79df\u6237\u5bfc\u51fa\u6570\u636eerror", (Throwable)e);
                        this.changeLogService.saveTenantExportDataChangeLogs(r, "\u751f\u6210\u5931\u8d25", Boolean.valueOf(false));
                        r.setState(TenantDataExportRecordStateEnum.FAILED.getValue().intValue());
                        this.tenantDataExportRecordService.update((com.digiwin.dap.middleware.entity.BaseEntity)r);
                        this.messageService.sendTenantExportDataFailMessage(r);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u79df\u6237\u5bfc\u51fa\u6570\u636eerror", (Throwable)e);
        }
    }

    @CacheLock(prefix="iam-schedule-task-06", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 1 1/1 * ?")
    @Async
    public void updatePermissionExportRecordStateTask() {
        try {
            logger.info("\u6267\u884c[\u66f4\u65b0\u529f\u80fd\u6743\u9650\u5bfc\u51fa\u8bb0\u5f55\u7684\u72b6\u6001]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: " + LocalDateTime.now());
            int count = this.tenantMapper.updatePermissionExportRecordState(LocalDateTime.now());
            logger.info("\u5df2\u66f4\u65b0{}\u6761\u529f\u80fd\u6743\u9650\u5bfc\u51fa\u8bb0\u5f55", (Object)count);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u529f\u80fd\u6743\u9650\u5bfc\u51fa\u8bb0\u5f55\u7684\u72b6\u6001error", (Throwable)e);
        }
    }

    @CacheLock(prefix="iam-schedule-task-07", expired=30L, autoDelete=false)
    @Scheduled(cron="0 30 0 1/1 * ?")
    @Async
    public void disableUserOfResignedEmployee() {
        try {
            logger.info("\u6267\u884c[\u505c\u7528\u79bb\u804c\u5458\u5de5\u7528\u6237\u4fe1\u606f]\u5b9a\u65f6\u4efb\u52a1,\u65f6\u95f4\uff1a{}", (Object)LocalDateTime.now());
            String startDate = DateUtils.formatDatePure((TemporalAccessor)LocalDateTime.now().minusDays(2L));
            String endDate = DateUtils.formatDatePure((TemporalAccessor)LocalDateTime.now().minusDays(1L));
            ResignedEmployeeVO resp = this.miswsService.getResignedEmployee(startDate, endDate);
            if (!"0".equals(resp.getStatus())) {
                logger.error("\u6267\u884c[\u505c\u7528\u79bb\u804c\u5458\u5de5\u7528\u6237\u4fe1\u606f]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25,\u8c03\u7528\u4eba\u4e8b\u8d44\u6599\u63a5\u53e3\u5f02\u5e38");
                return;
            }
            List resignedEmployeeList = resp.getData();
            if (!CollectionUtils.isEmpty((Collection)resignedEmployeeList)) {
                List resignedEmployeeIds = resignedEmployeeList.stream().map(ResignedEmployeeDataVO::getMV020).collect(Collectors.toList());
                List partition = Lists.partition(resignedEmployeeIds, (int)100);
                partition.forEach(list -> this.userMapper.disableUserAndClearTelephoneByIds(list));
            }
            logger.info("\u6267\u884c[\u505c\u7528\u79bb\u804c\u5458\u5de5\u7528\u6237\u4fe1\u606f]\u5b9a\u65f6\u4efb\u52a1\u5b8c\u6210,\u65f6\u95f4\uff1a{}", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u505c\u7528\u79bb\u804c\u5458\u5de5\u7528\u6237\u4fe1\u606f]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="iam-schedule-task-08", expired=30L, timeUnit=TimeUnit.SECONDS, autoDelete=false)
    @Scheduled(cron="0 5 3 1/1 * ?")
    @Async
    public void syncAdUser() {
        try {
            logger.info("\u5f00\u59cb \u6267\u884c[\u5168\u91cf\u540c\u6b65AD\u57df\u7528\u6237]\u5b9a\u65f6\u4efb\u52a1");
            List list = this.tenantRepository.findByAdLogin(Boolean.TRUE);
            if (list.isEmpty()) {
                logger.info("\u5f00\u542fAdLogin\u7684\u79df\u6237\u4e3a\u7a7a\uff0c\u9000\u51fa <<<---");
                return;
            }
            HashMap<Tenant, TenantMetadataLdapVO> ldapVOMap = new HashMap<Tenant, TenantMetadataLdapVO>();
            for (Tenant tenant2 : list) {
                List metadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(tenant2.getSid(), "ldap", IamConstants.LDAP_KEY_LIST);
                if (metadataVOList.isEmpty()) continue;
                TenantMetadataLdapVO vo2 = new TenantMetadataLdapVO(metadataVOList);
                if (!BooleanStrEnum.TRUE.getValue().equals(vo2.getScheduledSyncUserEnabled())) continue;
                if (BooleanStrEnum.TRUE.getValue().equals(vo2.getScheduledSyncOuEnabled())) {
                    if (tenant2.isEoc()) continue;
                    ldapVOMap.put(tenant2, vo2);
                    continue;
                }
                ldapVOMap.put(tenant2, vo2);
            }
            logger.info("\u6267\u884c\u540c\u6b65AD\u7528\u6237\u7684\u79df\u6237 ldapVOMap.size()={}", (Object)ldapVOMap.size());
            ldapVOMap.forEach((tenant, vo) -> {
                try {
                    this.userService.syncAdObject(tenant, vo, null, false);
                }
                catch (Exception e) {
                    logger.error("\u79df\u6237[{}] \u6267\u884c[\u5168\u91cf\u540c\u6b65AD\u57df\u7528\u6237]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object)tenant.getId(), (Object)e);
                }
            });
            logger.info("\u5b8c\u6210 \u6267\u884c[\u5168\u91cf\u540c\u6b65AD\u57df\u7528\u6237]\u5b9a\u65f6\u4efb\u52a1, \u65f6\u95f4\uff1a{}", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u5168\u91cf\u540c\u6b65AD\u57df\u7528\u6237]\u5b9a\u65f6\u4efb\u52a1 \u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="iam-schedule-task-09", expired=30L, timeUnit=TimeUnit.SECONDS, autoDelete=false)
    @Scheduled(cron="0 25 3 1/1 * ?")
    @Async
    public void syncAdOu() {
        try {
            logger.info("\u5f00\u59cb \u6267\u884c[\u5168\u91cf\u540c\u6b65AD\u57df\u7528\u6237\u3001\u7ec4\u7ec7\u53ca\u5458\u5de5]\u5b9a\u65f6\u4efb\u52a1");
            List list = this.tenantRepository.findByAdLogin(Boolean.TRUE);
            if (list.isEmpty()) {
                logger.info("\u5f00\u542fAdLogin\u7684\u79df\u6237\u4e3a\u7a7a\uff0c\u9000\u51fa <<<---");
                return;
            }
            HashMap<Tenant, TenantMetadataLdapVO> ldapVOMap = new HashMap<Tenant, TenantMetadataLdapVO>();
            for (Tenant tenant2 : list) {
                List metadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(tenant2.getSid(), "ldap", IamConstants.LDAP_KEY_LIST);
                if (metadataVOList.isEmpty()) continue;
                TenantMetadataLdapVO vo2 = new TenantMetadataLdapVO(metadataVOList);
                if (!BooleanStrEnum.TRUE.getValue().equals(vo2.getScheduledSyncOuEnabled())) continue;
                if (tenant2.isEoc()) {
                    ldapVOMap.put(tenant2, vo2);
                    continue;
                }
                logger.warn("\u79df\u6237{}\u672a\u542f\u7528EOC\uff08\u4f01\u4e1a\u8fd0\u8425\u7ba1\u7406\uff09\u8df3\u8fc7\u7ec4\u7ec7\u53ca\u5458\u5de5\u540c\u6b65", (Object)tenant2.getId());
            }
            logger.info("\u6267\u884c\u540c\u6b65A\u7528\u6237\u3001\u7ec4\u7ec7\u53ca\u5458\u5de5\u7684\u79df\u6237 ldapVOMap.size()={}", (Object)ldapVOMap.size());
            ldapVOMap.forEach((tenant, vo) -> {
                try {
                    this.userService.syncAdObject(tenant, vo, null, true);
                }
                catch (Exception e) {
                    logger.error("\u79df\u6237[{}] \u6267\u884c[\u5168\u91cf\u540c\u6b65AD\u57df\u7528\u6237\u3001\u7ec4\u7ec7\u53ca\u5458\u5de5]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object)tenant.getId(), (Object)e);
                }
            });
            logger.info("\u5b8c\u6210 \u6267\u884c[\u5168\u91cf\u540c\u6b65AD\u57df\u7528\u6237\u3001\u7ec4\u7ec7\u53ca\u5458\u5de5]\u5b9a\u65f6\u4efb\u52a1, \u65f6\u95f4\uff1a{}", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u5168\u91cf\u540c\u6b65AD\u57df\u7528\u6237\u3001\u7ec4\u7ec7\u53ca\u5458\u5de5]\u5b9a\u65f6\u4efb\u52a1 \u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="iam-schedule-task-10", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 0 * * ?")
    @Async
    public void changeExperienceState() {
        try {
            LocalDateTime now = LocalDateTime.now();
            logger.info("changeExperienceState start,now\uff1a{}", (Object)now);
            List expired = this.intellyMapper.findALLExpireExperience(now);
            if (expired.isEmpty()) {
                logger.info("changeExperienceState no change");
                return;
            }
            for (IntellyExperienceResultVO vo : expired) {
                Optional byId = this.intellyExperienceApplicationRepository.findById((Object)vo.getSid());
                byId.ifPresent(a -> {
                    a.setStatus(Integer.valueOf(IntellyExperienceStatusEnum.EXPIRED.getStatus()));
                    logger.info("changeExperienceState sid:{} expired", (Object)a.getSid());
                    this.intellyExperienceApplicationRepository.save(a);
                });
            }
            logger.info("changeExperienceState finished");
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u6539\u4f53\u9a8c\u7533\u8bf7\u5230\u671f\u72b6\u6001]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @CacheLock(prefix="iam-schedule-task-11", expired=30L, autoDelete=false)
    @Scheduled(cron="0 50 23 * * ?")
    @Async
    public void sendExperienceExpireNotice() {
        try {
            LocalDateTime endOfToday = LocalDateTime.of(LocalDate.now(), LocalTime.of(23, 59, 59));
            logger.info("sendExperienceExpireNotice start,endOfToday\uff1a{}", (Object)endOfToday);
            List expired = this.intellyMapper.findALLExperienceEndsToday(endOfToday);
            if (expired.isEmpty()) {
                logger.info("sendExperienceExpireNotice none");
                return;
            }
            for (IntellyExperienceResultVO vo : expired) {
                Optional byId = this.intellyExperienceApplicationRepository.findById((Object)vo.getSid());
                byId.ifPresent(a -> {
                    logger.info("sendExperienceExpireNotice sid:{} expired", (Object)a.getSid());
                    this.messageService.sendExperiencePreExpireNotice(a);
                });
            }
            logger.info("sendExperienceExpireNotice finished");
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u6539\u4f53\u9a8c\u7533\u8bf7\u5230\u671f\u72b6\u6001]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }
}

