/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam;

import com.digiwin.dap.middleware.service.AssociationEntityService;
import com.digiwin.dap.middleware.service.RelationAssociationEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class AssciationEntityCacheInitializer
implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private AssociationEntityService associationEntityService;
    @Autowired
    private RelationAssociationEntityService relationAssociationEntityService;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            this.addTenant();
            this.addUser();
            this.addUserToken();
            this.addUserRelationWithTenant();
            this.addMetadataColumn();
            this.addRole();
            this.addRoleCatalog();
            this.addOrgCatalog();
            this.addOrgAspect();
            this.addOrgType();
            this.addOrgTagCatalog();
            this.addOrgTag();
            this.addOrg();
            this.addSys();
            this.addModule();
            this.addAction();
            this.addPolicy();
            this.addDataPolicy();
            this.addDevSys();
            this.addDevModule();
            this.addDevAction();
            this.addServiceAuthorizationCode();
        }
    }

    private void addDevSys() {
        this.associationEntityService.addAssociationEntities("dev_sys", "dev_module", "dev_app_sid", true);
    }

    private void addDevModule() {
        this.associationEntityService.addAssociationEntities("dev_module", "dev_action", "dev_module_sid", true);
    }

    private void addDevAction() {
        this.associationEntityService.addAssociationEntities("dev_action", "dev_condition", "dev_action_sid", true);
    }

    private void addUserToken() {
        this.associationEntityService.addAssociationEntities("usertoken", "usertokenonapp", "user_token_sid", true);
    }

    private void addTenant() {
        this.associationEntityService.addAssociationEntities("tenant", "userrelationwithtenant", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "tenantcertification", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "tenantmetadata", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "sysintenant", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "servicer", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "certification", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "service_authorization_code", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "metadatacolumn", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "rolecatalog", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "orgcatalog", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "usermapping", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "datapolicy", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "invoice", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "policy", "tenant_sid", true);
        this.associationEntityService.addAssociationEntities("tenant", "invoiceinfo", "tenant_sid", true);
    }

    private void addUser() {
        this.associationEntityService.addAssociationEntities("user", "usertoken", "user_sid", true);
        this.associationEntityService.addAssociationEntities("user", "metadata", "user_sid", true);
        this.associationEntityService.addAssociationEntities("user", "association", "user_sid", true);
        this.associationEntityService.addAssociationEntities("user", "userintag", "user_sid", true);
        this.associationEntityService.addAssociationEntities("user", "userinorg", "user_sid", true);
        this.associationEntityService.addAssociationEntities("user", "usermapping", "user_sid", true);
        this.associationEntityService.addAssociationEntities("user", "userrelationwithtenant", "user_sid", true);
        this.associationEntityService.addAssociationEntities("user", "usercertification", "user_sid", true);
    }

    private void addMetadataColumn() {
        this.associationEntityService.addAssociationEntities("metadatacolumn", "metadata", "column_sid", true);
    }

    private void addRoleCatalog() {
        this.associationEntityService.addAssociationEntities("rolecatalog", "role", "rolecatalog_sid", true);
    }

    private void addRole() {
        this.associationEntityService.addAssociationEntities("role", "association", "role_sid", true);
    }

    private void addOrgCatalog() {
        this.associationEntityService.addAssociationEntities("orgcatalog", "orgaspect", "orgcatalog_sid", true);
        this.associationEntityService.addAssociationEntities("orgcatalog", "orgtype", "orgcatalog_sid", true);
    }

    private void addOrgAspect() {
        this.associationEntityService.addAssociationEntities("orgaspect", "org", "orgaspect_sid", true);
    }

    private void addOrgType() {
        this.associationEntityService.addAssociationEntities("orgtype", "org", "orgtype_sid", true);
        this.associationEntityService.addAssociationEntities("orgtype", "orgtype", "parent_sid", true);
    }

    private void addOrgTagCatalog() {
        this.associationEntityService.addAssociationEntities("orgtagcatalog", "orgtag", "tagcatalog_sid", true);
    }

    private void addOrgTag() {
        this.associationEntityService.addAssociationEntities("orgtag", "orgintag", "tag_sid", true);
        this.associationEntityService.addAssociationEntities("orgtag", "userintag", "tag_sid", true);
    }

    private void addOrg() {
        this.associationEntityService.addAssociationEntities("org", "userinorg", "org_sid", true);
        this.associationEntityService.addAssociationEntities("org", "org", "parent_sid", true);
    }

    private void addSys() {
        this.associationEntityService.addAssociationEntities("sys", "module", "app_sid", true);
        this.associationEntityService.addAssociationEntities("sys", "sysintenant", "sys_sid", true);
    }

    private void addModule() {
        this.associationEntityService.addAssociationEntities("module", "action", "module_sid", true);
    }

    private void addAction() {
        this.associationEntityService.addAssociationEntities("action", "condition", "action_sid", true);
        this.associationEntityService.addAssociationEntities("action", "action", "parent_sid", true);
    }

    private void addPolicy() {
        this.associationEntityService.addAssociationEntities("policy", "policyconditionvalue", "policy_sid", true);
    }

    private void addDataPolicy() {
        this.associationEntityService.addAssociationEntities("datapolicy", "datastatement", "policy_sid", true);
        this.associationEntityService.addAssociationEntities("datapolicy", "datapolicyonuser", "policy_sid", true);
        this.associationEntityService.addAssociationEntities("datapolicy", "datapolicyonrole", "policy_sid", true);
        this.associationEntityService.addAssociationEntities("datapolicy", "datapolicyonaction", "policy_sid", true);
        this.associationEntityService.addAssociationEntities("datapolicy", "datapolicyonorg", "policy_sid", true);
    }

    private void addUserRelationWithTenant() {
        this.relationAssociationEntityService.addAssociationEntities("userrelationwithtenant", "datapolicyonuser", "user", "user_sid", "datapolicy", "policy_sid", "tenant_sid", false);
        this.relationAssociationEntityService.addAssociationEntities("userrelationwithtenant", "userintag", "user", "user_sid", "orgtag", "tag_sid", "tenant_sid", false);
        this.relationAssociationEntityService.addAssociationEntities("userrelationwithtenant", "userinorg", "user", "user_sid", "org", "org_sid", "tenant_sid", false);
        this.relationAssociationEntityService.addAssociationEntities("userrelationwithtenant", "association", "user", "user_sid", "role", "role_sid", "tenant_sid", false);
        this.relationAssociationEntityService.addAssociationEntities("userrelationwithtenant", "metadata", "user", "user_sid", "metadatacolumn", "column_sid", "tenant_sid", true);
    }

    private void addServiceAuthorizationCode() {
        this.associationEntityService.addAssociationEntities("service_authorization_code", "service_authorization_record", "code", true);
    }
}

