/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.config;

import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.DMCBuilder;
import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCConfigBuilder;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.LMCClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DapSdkConfig {
    @Autowired
    private EnvProperties envProperties;

    @Bean(name={"dmcClient"})
    public DMC dmcClient() {
        return DMCBuilder.create().build(this.getConfig());
    }

    @Bean(name={"lmcClient"})
    public LMC lmcClient() {
        return new LMCClient(this.envProperties.getLmcUri(), this.envProperties.getApplicationName().toUpperCase(), this.envProperties.getAppToken(), this.envProperties.getAppSecret());
    }

    private DMCConfig getConfig() {
        return DMCConfigBuilder.create((String)this.envProperties.getDmcUrl(), (String)this.envProperties.getDmcUserName(), (String)this.envProperties.getDmcPassword(), (String)this.envProperties.getDmcBucketName()).lazy(true).appToken(this.envProperties.getAppToken()).appSecret(this.envProperties.getAppSecret()).build();
    }
}

