/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.config;

import com.digiwin.dap.middleware.autoconfigure.properties.DapProperties;
import com.digiwin.dap.middleware.autoconfigure.web.client.AppTokenHeaderInterceptor;
import com.digiwin.dap.middleware.autoconfigure.web.client.CustomizeHeaderInterceptor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfig {
    public static final String SYS_NOTICE_REST_TEMPLATE = "noticeRestTemplate";
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private DapProperties dapProperties;

    @Bean(value={"noticeRestTemplate"})
    public RestTemplate noticeRestTemplate() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        for (HttpMessageConverter httpMessageConverter : restTemplate.getMessageConverters()) {
            if (httpMessageConverter instanceof MappingJackson2HttpMessageConverter) {
                ((MappingJackson2HttpMessageConverter)httpMessageConverter).setObjectMapper(this.objectMapper);
            }
            if (!(httpMessageConverter instanceof StringHttpMessageConverter)) continue;
            ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(StandardCharsets.UTF_8);
        }
        ArrayList<Object> interceptors = new ArrayList<Object>();
        interceptors.add(new CustomizeHeaderInterceptor());
        interceptors.add(new AppTokenHeaderInterceptor(this.dapProperties));
        restTemplate.setInterceptors(interceptors);
        return restTemplate;
    }
}

