/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.constant.enums;

public enum CellphonePrefixEnum {
    MAINLAND("+86"),
    TAIWAN("+886"),
    MALAYSIA("+60"),
    VIETNAM("+84"),
    THAILAND("+66"),
    INDIA("+91"),
    INDONISIA("+62");

    private String prefix;

    private CellphonePrefixEnum(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static boolean prefixValid(String cellphonePrefix) {
        for (CellphonePrefixEnum prefixEnum : CellphonePrefixEnum.values()) {
            if (!prefixEnum.prefix.equals(cellphonePrefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean canSendSMS(String cellphonePrefix) {
        if (cellphonePrefix == null) {
            return false;
        }
        return CellphonePrefixEnum.MAINLAND.prefix.equals(cellphonePrefix) || CellphonePrefixEnum.TAIWAN.prefix.equals(cellphonePrefix);
    }
}

