/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.constant.enums;

import cn.hutool.core.util.ReUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;

public enum RegexRuleEnum {
    REGEX_APP_ID("^[a-zA-Z0-9_-]{2,40}$", "\u5b57\u6bcd\u3001\u6570\u5b57\u3001_\u3001-\uff0c\u957f\u5ea62-40\u4f4d\u5b57\u7b26", I18nError.IAM_DEV_APP_ID_MISMATCH_RULE);

    final String regex;
    final String description;
    final I18nError i18nError;

    private RegexRuleEnum(String regex, String description, I18nError i18nError) {
        this.regex = regex;
        this.description = description;
        this.i18nError = i18nError;
    }

    public boolean isMatch(String content) {
        return ReUtil.isMatch((String)this.regex, (CharSequence)content);
    }

    public void check(String content) {
        if (!ReUtil.isMatch((String)this.regex, (CharSequence)content)) {
            throw new BusinessException((ErrorHandler)this.i18nError);
        }
    }

    public String getRegex() {
        return this.regex;
    }

    public String getDescription() {
        return this.description;
    }

    public I18nError getI18nError() {
        return this.i18nError;
    }
}

