/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain;

import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.iam.constant.enums.CloudTypeEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Duration;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@JsonInclude
@Component
public class EnvProperties
extends DapEnv {
    @Value(value="${server.tomcat.threads.max}")
    private Integer maxThreads;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Value(value="${dap.middleware.iam.test_env_uri:}")
    private String iamTestUri;
    @Value(value="${dap.middleware.iam.cloud:0}")
    private Integer cloud;
    @Value(value="${dap.middleware.iam.token-expire:60}")
    private long tokenExpire;
    @Value(value="${dap.middleware.iam.oauth.token-expire:60}")
    private long oauthTokenExpire;
    @Value(value="${dap.middleware.iam.temp.token-expire:1440}")
    private long tempTokenExpire;
    @Value(value="${dap.middleware.market.uri:}")
    private String marketUri;
    @Value(value="${dap.middleware.console.uri:}")
    private String consoleUri;
    @Value(value="${dap.middleware.emc.uri:}")
    private String emcUri;
    @Value(value="${dap.middleware.gmc.uri:}")
    private String gmcUri;
    @Value(value="${dap.middleware.omc.uri:}")
    private String omcUri;
    @Value(value="${dap.middleware.cac.uri:}")
    private String cacUri;
    @Value(value="${dap.middleware.ali.paas.cac.uri:}")
    private String cacAliPaasUri;
    @Value(value="${dap.middleware.ali.test.cac.uri:}")
    private String cacAliTestUri;
    @Value(value="${dap.middleware.ali.prod.cac.uri:}")
    private String cacAliProdUri;
    @Value(value="${dap.middleware.azure.test.cac.uri:}")
    private String cacAzureTestUri;
    @Value(value="${dap.middleware.azure.prod.cac.uri:}")
    private String cacAzureProdUri;
    @Value(value="${dap.middleware.iam.notify.uri:}")
    private String notifyUri;
    @Value(value="${dap.middleware.fii.uri:}")
    private String fiiUri;
    @Value(value="${dap.middleware.aone.uri:}")
    private String aoneUri;
    @Value(value="${dap.middleware.kanban.uri:}")
    private String kanbanUri;
    @Value(value="${dap.middleware.iam.wsdl.url:}")
    private String wsdlUrl;
    @Value(value="${dap.middleware.iam.double-check-expire:1}")
    private Integer doubleCheckExpire;
    @Value(value="${dap.middleware.iam.misws.url:}")
    private String miswsUrl;
    @Value(value="${dap.middleware.iam.cmsmv.url:}")
    private String cmsmvUrl;
    @Value(value="${dap.middleware.iam.misws-new.crmgg:}")
    private String crmgg;
    @Value(value="${dap.middleware.iam.misws-new.get-cust:}")
    private String getCust;
    @Value(value="${dap.middleware.iam.misws-new.domain:}")
    private String miswsDomain;
    @Value(value="${dap.middleware.iam.password-open:false}")
    private Boolean passwordOpen;
    @Value(value="${spring.datasource.url}")
    private String dbUri;
    @Value(value="${spring.datasource.username}")
    private String dbUsername;
    @JsonIgnore
    @Value(value="${spring.datasource.password:}")
    private String dbPassword;
    @Value(value="${spring.redis.database:0}")
    private Integer redisDb;
    @Value(value="${spring.redis.host:}")
    private String redisHost;
    @Value(value="${spring.redis.port:}")
    private Integer redisPort;
    @JsonIgnore
    @Value(value="${spring.redis.password:}")
    private String redisPassword;
    @Value(value="${dap.middleware.iam.redis-ttl:8H}")
    private Duration redisTtl;
    @Value(value="${spring.redis.jedis.pool.max-active:}")
    private Integer redisPoolMaxTotal;
    @Value(value="${spring.redis.jedis.pool.max-idle:}")
    private Integer redisPoolMaxIdle;
    @Value(value="${spring.redis.jedis.pool.min-idle:}")
    private Integer redisPoolMinIdle;
    @Value(value="${spring.redis.jedis.pool.time-between-eviction-runs:}")
    private Duration redisPoolTimeBetweenEvictionRuns;
    @Value(value="${dap.middleware.ha.redis.database:}")
    private Integer redis2Db;
    @Value(value="${dap.middleware.ha.redis.host:}")
    private String redis2Host;
    @Value(value="${dap.middleware.ha.redis.port:}")
    private Integer redis2Port;
    @JsonIgnore
    @Value(value="${dap.middleware.ha.redis.password:}")
    private String redis2Password;
    @Value(value="${spring.rabbitmq.addresses:}")
    private String rabbitmqUri;
    @Value(value="${spring.rabbitmq.username:}")
    private String rabbitmqUsername;
    @JsonIgnore
    @Value(value="${spring.rabbitmq.password:}")
    private String rabbitmqPassword;
    @Value(value="${spring.rabbitmq.virtual-host:}")
    private String rabbitmqVirtualHost;
    @Value(value="${dap.middleware.esign.uri:}")
    private String esignUri;
    @Value(value="${dap.middleware.esign.app-id:}")
    private String esignAppId;
    @Value(value="${dap.middleware.esign.app-secret:}")
    private String esignAppSecret;
    @Value(value="${dap.middleware.tsign.uri:}")
    private String tsignUri;
    @Value(value="${dap.middleware.tsign.app-id:}")
    private String tsignAppId;
    @Value(value="${dap.middleware.tsign.app-secret:}")
    private String tsignAppSecret;
    @Value(value="${dap.middleware.tsign.grant-type:client_credentials}")
    private String tSignGrantType;
    @Value(value="${dap.middleware.tsign.logout-uri:}")
    private String tSignLogoutUri;
    @Value(value="${dap.middleware.tsign.open:true}")
    private Boolean openTsign;
    @Value(value="${dap.middleware.tsign.change_redis_db:false}")
    private Boolean changeTsignRedisDb;
    @Value(value="${dap.middleware.tyin.uri:}")
    private String tyinUri;
    @Value(value="${dap.middleware.tyin.project-id:}")
    private String tyinProjectId;
    @Value(value="${dap.middleware.tyin.signature:}")
    private String tyinSignature;
    @JsonIgnore
    @Value(value="${dap.middleware.iam.oldDb.url:}")
    private String odlDbUrl;
    @JsonIgnore
    @Value(value="${dap.middleware.iam.oldDb.username:}")
    private String oldDbUserName;
    @JsonIgnore
    @Value(value="${dap.middleware.iam.oldDb.password:}")
    private String oldDbPassword;
    @Value(value="${dap.middleware.lmc.uri:}")
    private String lmcUri;
    @Value(value="${dap.middleware.lmc.svc.uri:}")
    private String lmcSvcUri;
    @Value(value="${dap.middleware.lmc.log.enabled:}")
    private Boolean lmcLogEnabled;
    @Value(value="${dap.middleware.dmc.uri:}")
    private String dmcUrl;
    @Value(value="${dap.middleware.dmc.username:}")
    private String dmcUserName;
    @Value(value="${dap.middleware.dmc.password:}")
    private String dmcPassword;
    @Value(value="${dap.middleware.dmc.passwordHash:}")
    private String dmcPasswordHash;
    @Value(value="${dap.middleware.dmc.bucketname:}")
    private String dmcBucketName;
    @Value(value="${dap.middleware.eoc.uri:}")
    private String eocUri;
    @Value(value="${dap.middleware.eoc.initialize:}")
    private String eocInitializeUrl;
    @Value(value="${dap.middleware.img.uri:}")
    private String imgUri;
    @Value(value="${dap.middleware.img.update:}")
    private String imgUpdateTenant;
    @Value(value="${dap.middleware.iam.auth.password_reset:}")
    private String authPasswordReset;
    @Value(value="${dap.middleware.console.test_env_uri:}")
    private String consoleTestUri;
    @Value(value="${dap.middleware.iam.token-expired:false}")
    private Boolean tokenExpired;
    @Value(value="${dap.middleware.iam.token-expired-tenants:}")
    private String tokenExpiredTenants;
    @Value(value="${dap.middleware.manager-tenant:99990000}")
    private String managerTenant;
    @JsonIgnore
    @Value(value="${dap.middleware.integration.password_hash:6826CC688C4AF1BD0A8DDA2DBDF8897B}")
    private String integrationPasswordHash;
    @Value(value="${dap.middleware.eai.uri:}")
    private String eaiUri;
    @Value(value="${dap.middleware.eai.iam.ip:}")
    private String eaiIamIp;
    @Value(value="${dap.middleware.eai.iam.id:}")
    private String eaiIamId;
    @Value(value="${dap.middleware.eai.iam.prod:}")
    private String eaiIamProd;
    @Value(value="${dap.middleware.eai.iam.uid:}")
    private String eaiIamUid;
    @Value(value="${dap.middleware.iam.user_allowed:}")
    private String allowedUsers;
    @Value(value="${dap.middleware.iam.kicked_allow_user:}")
    private String kickedAllowUsers;
    @Value(value="${dap.middleware.iam.wechat.url:}")
    private String wechatVerifyUrl;
    @Value(value="${dap.middleware.iam.ad.trust-ssl:}")
    private Boolean adTrustSsl;
    @Value(value="${dap.middleware.iam.customize.token-expired:false}")
    private Boolean customizeTokenExpired;
    @Value(value="${dap.middleware.iam.customize.invalidDP:true}")
    private Boolean invalidateDevCurrentDataPolicy;
    @Value(value="${dap.middleware.check-user-id:false}")
    private Boolean checkUserId;
    @Value(value="${dap.middleware.iam.remote.area:}")
    private String remoteDeployArea;

    public String getAllowedUsers() {
        if (StringUtils.isEmpty((Object)this.allowedUsers)) {
            return "Athena,AIEOM,ServiceCloud,ANDON,EBA,ESC,ETM,TMC,coremiddleware,devOM,BOSS,devbuild";
        }
        return this.allowedUsers;
    }

    public boolean isAli() {
        return Locale.SIMPLIFIED_CHINESE.getCountry().equalsIgnoreCase(this.getCountry());
    }

    public void setAllowedUsers(String allowedUsers) {
        this.allowedUsers = allowedUsers;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public Integer getCloud() {
        return this.cloud;
    }

    public void setCloud(Integer cloud) {
        this.cloud = cloud;
    }

    public long getTokenExpire() {
        return this.tokenExpire;
    }

    public void setTokenExpire(long tokenExpire) {
        this.tokenExpire = tokenExpire;
    }

    public String getMarketUri() {
        return this.marketUri;
    }

    public void setMarketUri(String marketUri) {
        this.marketUri = marketUri;
    }

    public String getEmcUri() {
        return this.emcUri;
    }

    public void setEmcUri(String emcUri) {
        this.emcUri = emcUri;
    }

    public String getGmcUri() {
        return this.gmcUri;
    }

    public void setGmcUri(String gmcUri) {
        this.gmcUri = gmcUri;
    }

    public String getOmcUri() {
        return this.omcUri;
    }

    public void setOmcUri(String omcUri) {
        this.omcUri = omcUri;
    }

    public String getCacUri() {
        return this.cacUri;
    }

    public void setCacUri(String cacUri) {
        this.cacUri = cacUri;
    }

    public String getNotifyUri() {
        return this.notifyUri;
    }

    public void setNotifyUri(String notifyUri) {
        this.notifyUri = notifyUri;
    }

    public String getFiiUri() {
        return this.fiiUri;
    }

    public void setFiiUri(String fiiUri) {
        this.fiiUri = fiiUri;
    }

    public String getAoneUri() {
        return this.aoneUri;
    }

    public void setAoneUri(String aoneUri) {
        this.aoneUri = aoneUri;
    }

    public String getKanbanUri() {
        return this.kanbanUri;
    }

    public void setKanbanUri(String kanbanUri) {
        this.kanbanUri = kanbanUri;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    public String getDbUri() {
        return this.dbUri;
    }

    public void setDbUri(String dbUri) {
        this.dbUri = dbUri;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public Integer getRedisDb() {
        return this.redisDb;
    }

    public void setRedisDb(Integer redisDb) {
        this.redisDb = redisDb;
    }

    public String getRedisHost() {
        return this.redisHost;
    }

    public void setRedisHost(String redisHost) {
        this.redisHost = redisHost;
    }

    public Integer getRedisPort() {
        return this.redisPort;
    }

    public void setRedisPort(Integer redisPort) {
        this.redisPort = redisPort;
    }

    public String getRedisPassword() {
        return this.redisPassword;
    }

    public void setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
    }

    public Duration getRedisTtl() {
        return this.redisTtl;
    }

    public void setRedisTtl(Duration redisTtl) {
        this.redisTtl = redisTtl;
    }

    public Integer getRedis2Db() {
        return this.redis2Db;
    }

    public void setRedis2Db(Integer redis2Db) {
        this.redis2Db = redis2Db;
    }

    public String getRedis2Host() {
        return this.redis2Host;
    }

    public void setRedis2Host(String redis2Host) {
        this.redis2Host = redis2Host;
    }

    public Integer getRedis2Port() {
        return this.redis2Port;
    }

    public void setRedis2Port(Integer redis2Port) {
        this.redis2Port = redis2Port;
    }

    public String getRedis2Password() {
        return this.redis2Password;
    }

    public void setRedis2Password(String redis2Password) {
        this.redis2Password = redis2Password;
    }

    public String getRabbitmqUri() {
        return this.rabbitmqUri;
    }

    public void setRabbitmqUri(String rabbitmqUri) {
        this.rabbitmqUri = rabbitmqUri;
    }

    public String getLmcUri() {
        return this.lmcUri;
    }

    public void setLmcUri(String lmcUri) {
        this.lmcUri = lmcUri;
    }

    public String getLmcSvcUri() {
        return this.lmcSvcUri;
    }

    public void setLmcSvcUri(String lmcSvcUri) {
        this.lmcSvcUri = lmcSvcUri;
    }

    public Boolean getLmcLogEnabled() {
        return this.lmcLogEnabled;
    }

    public void setLmcLogEnabled(Boolean lmcLogEnabled) {
        this.lmcLogEnabled = lmcLogEnabled;
    }

    public String getRabbitmqUsername() {
        return this.rabbitmqUsername;
    }

    public void setRabbitmqUsername(String rabbitmqUsername) {
        this.rabbitmqUsername = rabbitmqUsername;
    }

    public String getRabbitmqPassword() {
        return this.rabbitmqPassword;
    }

    public void setRabbitmqPassword(String rabbitmqPassword) {
        this.rabbitmqPassword = rabbitmqPassword;
    }

    public String getRabbitmqVirtualHost() {
        return this.rabbitmqVirtualHost;
    }

    public void setRabbitmqVirtualHost(String rabbitmqVirtualHost) {
        this.rabbitmqVirtualHost = rabbitmqVirtualHost;
    }

    public String getTsignUri() {
        return this.tsignUri;
    }

    public void setTsignUri(String tsignUri) {
        this.tsignUri = tsignUri;
    }

    public String getTsignAppId() {
        return this.tsignAppId;
    }

    public void setTsignAppId(String tsignAppId) {
        this.tsignAppId = tsignAppId;
    }

    public String getTsignAppSecret() {
        return this.tsignAppSecret;
    }

    public void setTsignAppSecret(String tsignAppSecret) {
        this.tsignAppSecret = tsignAppSecret;
    }

    public String gettSignGrantType() {
        return this.tSignGrantType;
    }

    public void settSignGrantType(String tSignGrantType) {
        this.tSignGrantType = tSignGrantType;
    }

    public String gettSignLogoutUri() {
        return this.tSignLogoutUri;
    }

    public void settSignLogoutUri(String tSignLogoutUri) {
        this.tSignLogoutUri = tSignLogoutUri;
    }

    public Boolean isOpenTsign() {
        return this.openTsign;
    }

    public void setOpenTsign(Boolean openTsign) {
        this.openTsign = openTsign;
    }

    public Boolean isChangeTsignRedisDb() {
        return this.changeTsignRedisDb;
    }

    public void setChangeTsignRedisDb(Boolean changeTsignRedisDb) {
        this.changeTsignRedisDb = changeTsignRedisDb;
    }

    public String getTyinUri() {
        return this.tyinUri;
    }

    public void setTyinUri(String tyinUri) {
        this.tyinUri = tyinUri;
    }

    public String getTyinProjectId() {
        return this.tyinProjectId;
    }

    public void setTyinProjectId(String tyinProjectId) {
        this.tyinProjectId = tyinProjectId;
    }

    public String getTyinSignature() {
        return this.tyinSignature;
    }

    public void setTyinSignature(String tyinSignature) {
        this.tyinSignature = tyinSignature;
    }

    public String getOdlDbUrl() {
        return this.odlDbUrl;
    }

    public void setOdlDbUrl(String odlDbUrl) {
        this.odlDbUrl = odlDbUrl;
    }

    public String getOldDbUserName() {
        return this.oldDbUserName;
    }

    public void setOldDbUserName(String oldDbUserName) {
        this.oldDbUserName = oldDbUserName;
    }

    public String getOldDbPassword() {
        return this.oldDbPassword;
    }

    public void setOldDbPassword(String oldDbPassword) {
        this.oldDbPassword = oldDbPassword;
    }

    public String getDmcUrl() {
        return this.dmcUrl;
    }

    public void setDmcUrl(String dmcUrl) {
        this.dmcUrl = dmcUrl;
    }

    public String getDmcUserName() {
        return this.dmcUserName;
    }

    public void setDmcUserName(String dmcUserName) {
        this.dmcUserName = dmcUserName;
    }

    public String getDmcPassword() {
        return this.dmcPassword;
    }

    public void setDmcPassword(String dmcPassword) {
        this.dmcPassword = dmcPassword;
    }

    public String getDmcPasswordHash() {
        return this.dmcPasswordHash;
    }

    public void setDmcPasswordHash(String dmcPasswordHash) {
        this.dmcPasswordHash = dmcPasswordHash;
    }

    public String getDmcBucketName() {
        return this.dmcBucketName;
    }

    public void setDmcBucketName(String dmcBucketName) {
        this.dmcBucketName = dmcBucketName;
    }

    public String getEocUri() {
        return this.eocUri;
    }

    public void setEocUri(String eocUri) {
        this.eocUri = eocUri;
    }

    public String getEocInitializeUrl() {
        return this.eocInitializeUrl;
    }

    public void setEocInitializeUrl(String eocInitializeUrl) {
        this.eocInitializeUrl = eocInitializeUrl;
    }

    public String getImgUri() {
        return this.imgUri;
    }

    public void setImgUri(String imgUri) {
        this.imgUri = imgUri;
    }

    public String getImgUpdateTenant() {
        return this.imgUpdateTenant;
    }

    public void setImgUpdateTenant(String imgUpdateTenant) {
        this.imgUpdateTenant = imgUpdateTenant;
    }

    public long getOauthTokenExpire() {
        return this.oauthTokenExpire;
    }

    public void setOauthTokenExpire(long oauthTokenExpire) {
        this.oauthTokenExpire = oauthTokenExpire;
    }

    public String getAuthPasswordReset() {
        return this.authPasswordReset;
    }

    public void setAuthPasswordReset(String authPasswordReset) {
        this.authPasswordReset = authPasswordReset;
    }

    public String getConsoleTestUri() {
        return this.consoleTestUri;
    }

    public void setConsoleTestUri(String consoleTestUri) {
        this.consoleTestUri = consoleTestUri;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getIamTestUri() {
        return this.iamTestUri;
    }

    public void setIamTestUri(String iamTestUri) {
        this.iamTestUri = iamTestUri;
    }

    public String getEsignUri() {
        return this.esignUri;
    }

    public void setEsignUri(String esignUri) {
        this.esignUri = esignUri;
    }

    public String getEsignAppId() {
        return this.esignAppId;
    }

    public void setEsignAppId(String esignAppId) {
        this.esignAppId = esignAppId;
    }

    public String getEsignAppSecret() {
        return this.esignAppSecret;
    }

    public void setEsignAppSecret(String esignAppSecret) {
        this.esignAppSecret = esignAppSecret;
    }

    public Boolean isTokenExpired() {
        return this.tokenExpired;
    }

    public void setTokenExpired(Boolean tokenExpired) {
        this.tokenExpired = tokenExpired;
    }

    public String getTokenExpiredTenants() {
        return this.tokenExpiredTenants;
    }

    public void setTokenExpiredTenants(String tokenExpiredTenants) {
        this.tokenExpiredTenants = tokenExpiredTenants;
    }

    public Integer getDoubleCheckExpire() {
        return this.doubleCheckExpire;
    }

    public void setDoubleCheckExpire(Integer doubleCheckExpire) {
        this.doubleCheckExpire = doubleCheckExpire;
    }

    public String getCacAliPaasUri() {
        return this.cacAliPaasUri;
    }

    public void setCacAliPaasUri(String cacAliPaasUri) {
        this.cacAliPaasUri = cacAliPaasUri;
    }

    public String getCacAliTestUri() {
        return this.cacAliTestUri;
    }

    public void setCacAliTestUri(String cacAliTestUri) {
        this.cacAliTestUri = cacAliTestUri;
    }

    public String getCacAliProdUri() {
        return this.cacAliProdUri;
    }

    public void setCacAliProdUri(String cacAliProdUri) {
        this.cacAliProdUri = cacAliProdUri;
    }

    public String getCacAzureTestUri() {
        return this.cacAzureTestUri;
    }

    public void setCacAzureTestUri(String cacAzureTestUri) {
        this.cacAzureTestUri = cacAzureTestUri;
    }

    public String getCacAzureProdUri() {
        return this.cacAzureProdUri;
    }

    public void setCacAzureProdUri(String cacAzureProdUri) {
        this.cacAzureProdUri = cacAzureProdUri;
    }

    public String getMiswsUrl() {
        return this.miswsUrl;
    }

    public void setMiswsUrl(String miswsUrl) {
        this.miswsUrl = miswsUrl;
    }

    public Boolean getPasswordOpen() {
        return this.passwordOpen;
    }

    public void setPasswordOpen(Boolean passwordOpen) {
        this.passwordOpen = passwordOpen;
    }

    public Integer getRedisPoolMaxTotal() {
        return this.redisPoolMaxTotal;
    }

    public void setRedisPoolMaxTotal(Integer redisPoolMaxTotal) {
        this.redisPoolMaxTotal = redisPoolMaxTotal;
    }

    public Integer getRedisPoolMaxIdle() {
        return this.redisPoolMaxIdle;
    }

    public void setRedisPoolMaxIdle(Integer redisPoolMaxIdle) {
        this.redisPoolMaxIdle = redisPoolMaxIdle;
    }

    public Integer getRedisPoolMinIdle() {
        return this.redisPoolMinIdle;
    }

    public void setRedisPoolMinIdle(Integer redisPoolMinIdle) {
        this.redisPoolMinIdle = redisPoolMinIdle;
    }

    public Duration getRedisPoolTimeBetweenEvictionRuns() {
        return this.redisPoolTimeBetweenEvictionRuns;
    }

    public void setRedisPoolTimeBetweenEvictionRuns(Duration redisPoolTimeBetweenEvictionRuns) {
        this.redisPoolTimeBetweenEvictionRuns = redisPoolTimeBetweenEvictionRuns;
    }

    public String getManagerTenant() {
        return this.managerTenant;
    }

    public void setManagerTenant(String managerTenant) {
        this.managerTenant = managerTenant;
    }

    public String getIntegrationPasswordHash() {
        return this.integrationPasswordHash;
    }

    public void setIntegrationPasswordHash(String integrationPasswordHash) {
        this.integrationPasswordHash = integrationPasswordHash;
    }

    public String getEaiUri() {
        return this.eaiUri;
    }

    public void setEaiUri(String eaiUri) {
        this.eaiUri = eaiUri;
    }

    public String getEaiIamIp() {
        return this.eaiIamIp;
    }

    public void setEaiIamIp(String eaiIamIp) {
        this.eaiIamIp = eaiIamIp;
    }

    public String getEaiIamId() {
        return this.eaiIamId;
    }

    public void setEaiIamId(String eaiIamId) {
        this.eaiIamId = eaiIamId;
    }

    public String getEaiIamProd() {
        return this.eaiIamProd;
    }

    public void setEaiIamProd(String eaiIamProd) {
        this.eaiIamProd = eaiIamProd;
    }

    public String getEaiIamUid() {
        return this.eaiIamUid;
    }

    public void setEaiIamUid(String eaiIamUid) {
        this.eaiIamUid = eaiIamUid;
    }

    public String getKickedAllowUsers() {
        return this.kickedAllowUsers;
    }

    public void setKickedAllowUsers(String kickedAllowUsers) {
        this.kickedAllowUsers = kickedAllowUsers;
    }

    public String getWechatVerifyUrl() {
        return this.wechatVerifyUrl;
    }

    public void setWechatVerifyUrl(String wechatVerifyUrl) {
        this.wechatVerifyUrl = wechatVerifyUrl;
    }

    public String getCmsmvUrl() {
        return this.cmsmvUrl;
    }

    public void setCmsmvUrl(String cmsmvUrl) {
        this.cmsmvUrl = cmsmvUrl;
    }

    public long getTempTokenExpire() {
        return this.tempTokenExpire;
    }

    public void setTempTokenExpire(long tempTokenExpire) {
        this.tempTokenExpire = tempTokenExpire;
    }

    public boolean isCloud() {
        return CloudTypeEnum.isCloud(this.cloud);
    }

    public Boolean getAdTrustSsl() {
        return this.adTrustSsl;
    }

    public void setAdTrustSsl(Boolean adTrustSsl) {
        this.adTrustSsl = adTrustSsl;
    }

    public String getCrmgg() {
        return this.crmgg;
    }

    public void setCrmgg(String crmgg) {
        this.crmgg = crmgg;
    }

    public String getConsoleUri() {
        return this.consoleUri;
    }

    public void setConsoleUri(String consoleUri) {
        this.consoleUri = consoleUri;
    }

    public Boolean getCustomizeTokenExpired() {
        return this.customizeTokenExpired;
    }

    public void setCustomizeTokenExpired(Boolean customizeTokenExpired) {
        this.customizeTokenExpired = customizeTokenExpired;
    }

    public Boolean getInvalidateDevCurrentDataPolicy() {
        return this.invalidateDevCurrentDataPolicy;
    }

    public void setInvalidateDevCurrentDataPolicy(Boolean invalidateDevCurrentDataPolicy) {
        this.invalidateDevCurrentDataPolicy = invalidateDevCurrentDataPolicy;
    }

    public String getGetCust() {
        return this.getCust;
    }

    public void setGetCust(String getCust) {
        this.getCust = getCust;
    }

    public String getMiswsDomain() {
        return this.miswsDomain;
    }

    public void setMiswsDomain(String miswsDomain) {
        this.miswsDomain = miswsDomain;
    }

    public Boolean getCheckUserId() {
        return this.checkUserId;
    }

    public void setCheckUserId(Boolean checkUserId) {
        this.checkUserId = checkUserId;
    }

    public String getRemoteDeployArea() {
        return this.remoteDeployArea;
    }

    public void setRemoteDeployArea(String remoteDeployArea) {
        this.remoteDeployArea = remoteDeployArea;
    }
}

