/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.app;

import com.digiwin.dap.middleware.iam.domain.service.permission.MetadataApiVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;

public class SysVO {
    private long sid;
    @NotBlank
    private String id;
    private String idFirst;
    private String idSecond;
    private long categorySid;
    private String categoryId;
    private String name;
    private boolean app;
    private String appToken;
    @JsonProperty(value="isMultiLogin")
    private boolean multiLogin = true;
    private boolean inside = false;
    private boolean hasPermission = false;
    private List<MetadataApiVO> apis = new ArrayList<MetadataApiVO>();
    private String clientId;
    private String clientSecret;
    private String clientInstanceId;
    private boolean customizeTokenExpired = false;
    private Long tokenExpire;
    private Long tokenExpireHours;
    private boolean allowTenantAdjustTime = false;
    private Boolean linked;
    private Boolean showEntry;
    private Boolean showConsolePolicy;
    private String actionFilterUrl;
    private Boolean enableFunctionControl;

    public SysVO() {
    }

    public SysVO(Sys sys) {
        this.sid = sys.getSid();
        this.id = sys.getId();
        this.name = sys.getName();
        this.idFirst = sys.getIdFirst();
        this.inside = sys.isInside();
        this.multiLogin = sys.isMultiLogin();
        this.hasPermission = sys.isHasPermission();
        this.tokenExpire = sys.getTokenExpire();
        this.tokenExpireHours = (long)Math.ceil((double)sys.getTokenExpire() / 60.0);
        this.customizeTokenExpired = sys.isCustomizeTokenExpired();
        this.allowTenantAdjustTime = sys.isAllowTenantAdjustTime();
    }

    public List<MetadataApiVO> getApis() {
        return this.apis;
    }

    public void setApis(List<MetadataApiVO> apis) {
        this.apis = apis;
    }

    public long getSid() {
        return this.sid;
    }

    public void setSid(long sid) {
        this.sid = sid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIdFirst() {
        return this.idFirst;
    }

    public void setIdFirst(String idFirst) {
        this.idFirst = idFirst;
    }

    public String getIdSecond() {
        return this.idSecond;
    }

    public void setIdSecond(String idSecond) {
        this.idSecond = idSecond;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCategorySid() {
        return this.categorySid;
    }

    public void setCategorySid(long categorySid) {
        this.categorySid = categorySid;
    }

    public boolean isApp() {
        return this.app;
    }

    public void setApp(boolean app) {
        this.app = app;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public boolean isMultiLogin() {
        return this.multiLogin;
    }

    public void setMultiLogin(boolean multiLogin) {
        this.multiLogin = multiLogin;
    }

    public boolean isInside() {
        return this.inside;
    }

    public void setInside(boolean inside) {
        this.inside = inside;
    }

    public boolean isHasPermission() {
        return this.hasPermission;
    }

    public void setHasPermission(boolean hasPermission) {
        this.hasPermission = hasPermission;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientInstanceId() {
        return this.clientInstanceId;
    }

    public void setClientInstanceId(String clientInstanceId) {
        this.clientInstanceId = clientInstanceId;
    }

    public boolean isCustomizeTokenExpired() {
        return this.customizeTokenExpired;
    }

    public void setCustomizeTokenExpired(boolean customizeTokenExpired) {
        this.customizeTokenExpired = customizeTokenExpired;
    }

    public Long getTokenExpire() {
        return this.tokenExpire;
    }

    public void setTokenExpire(Long tokenExpire) {
        this.tokenExpire = tokenExpire;
    }

    public boolean isAllowTenantAdjustTime() {
        return this.allowTenantAdjustTime;
    }

    public void setAllowTenantAdjustTime(boolean allowTenantAdjustTime) {
        this.allowTenantAdjustTime = allowTenantAdjustTime;
    }

    public Long getTokenExpireHours() {
        return this.tokenExpireHours;
    }

    public void setTokenExpireHours(Long tokenExpireHours) {
        this.tokenExpireHours = tokenExpireHours;
    }

    public Boolean getLinked() {
        return this.linked;
    }

    public void setLinked(Boolean linked) {
        this.linked = linked;
    }

    public Boolean getShowEntry() {
        return this.showEntry;
    }

    public void setShowEntry(Boolean showEntry) {
        this.showEntry = showEntry;
    }

    public Boolean getShowConsolePolicy() {
        return this.showConsolePolicy;
    }

    public void setShowConsolePolicy(Boolean showConsolePolicy) {
        this.showConsolePolicy = showConsolePolicy;
    }

    public String getActionFilterUrl() {
        return this.actionFilterUrl;
    }

    public void setActionFilterUrl(String actionFilterUrl) {
        this.actionFilterUrl = actionFilterUrl;
    }

    public Boolean getEnableFunctionControl() {
        return this.enableFunctionControl;
    }

    public void setEnableFunctionControl(Boolean enableFunctionControl) {
        this.enableFunctionControl = enableFunctionControl;
    }
}

