/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.auth;

import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class AccessUser
implements InitializingBean,
Serializable {
    @NotBlank
    private String appId;
    @NotBlank
    private String method;
    @NotBlank
    private String path;
    private String tableName;
    @NotBlank
    private String appToken;
    private long sysSid;
    private String sysId;
    private boolean inside;
    private String userToken;
    private long tenantSid;
    @NotBlank
    private String tenantId;
    private long userSid;
    @NotBlank
    private String userId;

    public void afterPropertiesSet() throws Exception {
        this.sysId = AuthoredSys.obtainAppId((String)this.appToken);
    }

    public void flushInfo(CommonCacheService commonCacheService) {
        Sys sys = commonCacheService.getSysById(this.sysId);
        this.sysSid = sys.getSid();
        this.sysId = sys.getId();
        this.inside = sys.isInside();
        if (this.userToken == null) {
            return;
        }
        String tokenKey = LoginUser.tokenKey(this.userToken);
        AuthoredUser authoredUser = (AuthoredUser)RedisUtils.get((Object)tokenKey, AuthoredUser.class);
        if (authoredUser == null) {
            throw new UnauthorizedException((ErrorHandler)CommonErrorCode.USER_TOKEN_INVALID, String.format("\u89e3\u6790UserToken[%s]\u4e3anull", this.userToken));
        }
        this.tenantSid = authoredUser.getTenantSid();
        this.tenantId = authoredUser.getTenantId();
        this.userSid = authoredUser.getSid();
        this.userId = authoredUser.getUserId();
    }

    public String path() {
        return StringUtils.isEmpty((Object)this.tableName) ? this.path : this.path + "/" + this.tableName;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public long getSysSid() {
        return this.sysSid;
    }

    public void setSysSid(long sysSid) {
        this.sysSid = sysSid;
    }

    public String getSysId() {
        return this.sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public boolean isInside() {
        return this.inside;
    }

    public void setInside(boolean inside) {
        this.inside = inside;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public long getUserSid() {
        return this.userSid;
    }

    public void setUserSid(long userSid) {
        this.userSid = userSid;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

