/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.authorization.record;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.entity.ServiceAuthorizationRecord;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.util.StringUtils;

public class ServiceAuthorizationRecordDTO {
    private Long sid;
    private String code;
    private Long userSid;
    private Boolean disabled;
    private LocalDateTime startDate;
    private LocalDateTime endDate;
    private String remark;
    private String userId;
    private String userName;
    private String userContent;
    private String tenantContent;
    private Long tenantSid;
    private Boolean accountAuthorizationAgreement = Boolean.FALSE;
    private String createByContent;
    private Integer type;
    private String codeContent;
    private Integer stopType;
    private List<Long> userSids;

    public static ServiceAuthorizationRecordDTO getSelf(String content) {
        ServiceAuthorizationRecordDTO dto = new ServiceAuthorizationRecordDTO();
        try {
            if (StringUtils.hasText((String)content)) {
                dto = (ServiceAuthorizationRecordDTO)JsonUtils.createObjectMapper().readValue(content, ServiceAuthorizationRecordDTO.class);
            }
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        return dto;
    }

    public void copyToEntity(ServiceAuthorizationRecord record) {
        record.setCode(this.getCode());
        record.setStartDate(this.getStartDate());
        record.setEndDate(this.getEndDate());
        record.setAccountAuthorizationAgreement(null == this.getAccountAuthorizationAgreement() ? false : this.getAccountAuthorizationAgreement());
        record.setDisabled(null == this.getDisabled() ? false : this.getDisabled());
        record.setUserSid(this.getUserSid());
        record.setStopType(record.getStopType());
    }

    public List<Long> getUserSids() {
        return this.userSids;
    }

    public void setUserSids(List<Long> userSids) {
        this.userSids = userSids;
    }

    public Long getSid() {
        return this.sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getUserSid() {
        return this.userSid;
    }

    public void setUserSid(Long userSid) {
        this.userSid = userSid;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getUserContent() {
        return this.userContent;
    }

    public void setUserContent(String userContent) {
        this.userContent = userContent;
    }

    public String getTenantContent() {
        return this.tenantContent;
    }

    public void setTenantContent(String tenantContent) {
        this.tenantContent = tenantContent;
    }

    public Long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public Boolean getAccountAuthorizationAgreement() {
        return this.accountAuthorizationAgreement;
    }

    public void setAccountAuthorizationAgreement(Boolean accountAuthorizationAgreement) {
        this.accountAuthorizationAgreement = accountAuthorizationAgreement;
    }

    public String getCreateByContent() {
        return this.createByContent;
    }

    public void setCreateByContent(String createByContent) {
        this.createByContent = createByContent;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCodeContent() {
        return this.codeContent;
    }

    public void setCodeContent(String codeContent) {
        this.codeContent = codeContent;
    }

    public Integer getStopType() {
        return this.stopType;
    }

    public void setStopType(Integer stopType) {
        this.stopType = stopType;
    }
}

