/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.datapolicy;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.datapolicy.RowFilter;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DataPolicyVO {
    @NotBlank
    private String type;
    private long targetSid;
    private long sysSid;
    private long actionSid;
    private String rowPermission;
    private String rowPermissions;
    private String colPermission;
    private Long tenantSid;

    public String getRowPermissions() {
        return this.rowPermissions;
    }

    public void setRowPermissions(String rowPermissions) {
        this.rowPermissions = rowPermissions;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getTargetSid() {
        return this.targetSid;
    }

    public void setTargetSid(long targetSid) {
        this.targetSid = targetSid;
    }

    public long getSysSid() {
        return this.sysSid;
    }

    public void setSysSid(long sysSid) {
        this.sysSid = sysSid;
    }

    public long getActionSid() {
        return this.actionSid;
    }

    public void setActionSid(long actionSid) {
        this.actionSid = actionSid;
    }

    public String getRowPermission() {
        return this.rowPermission;
    }

    public void setRowPermission(String rowPermission) {
        this.rowPermission = rowPermission;
    }

    public String getColPermission() {
        return this.colPermission;
    }

    public void setColPermission(String colPermission) {
        this.colPermission = colPermission;
    }

    public Long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public void markRowPermissionTableName(boolean enableMultiRow) {
        boolean storeAsDefault;
        List<Object> row;
        String filter = this.getRowPermissions();
        if (StringUtils.isEmpty((Object)filter)) {
            filter = this.getRowPermission();
        }
        try {
            row = filter.startsWith("[") ? (List)JsonUtils.createObjectMapper().readValue(filter, (TypeReference)new TypeReference<List<Map>>(){}) : Collections.singletonList(JsonUtils.createObjectMapper().readValue(filter, Map.class));
        }
        catch (IOException e) {
            row = new ArrayList();
        }
        if (row.isEmpty()) {
            return;
        }
        boolean bl = storeAsDefault = !enableMultiRow || row.size() == 1;
        if (storeAsDefault) {
            HashMap defaultTable = new HashMap();
            defaultTable.put("default", row.get(0));
            this.setRowPermissions(JsonUtils.objToJson(defaultTable));
        } else {
            this.checkDuplicateTable(row);
            Map<String, Map> nameMap = row.stream().collect(Collectors.toMap(this::findTableName, r -> r));
            this.setRowPermissions(JsonUtils.objToJson(nameMap));
        }
    }

    private void checkDuplicateTable(List<Map> row) {
        HashSet<String> namesOccurred = new HashSet<String>();
        for (Map map : row) {
            HashSet<String> tableNames = RowFilter.extractName(map);
            if (tableNames.isEmpty()) {
                return;
            }
            if (tableNames.size() > 1) {
                throw new BusinessException((ErrorHandler)I18nError.DATA_PERMISSION_DUPLICATE_TABLE);
            }
            String tableName = tableNames.iterator().next();
            if (namesOccurred.contains(tableName)) {
                throw new BusinessException((ErrorHandler)I18nError.DATA_PERMISSION_TABLE_INTERSECT);
            }
            namesOccurred.add(tableName);
        }
        if (!CollectionUtils.isEmpty(row) && namesOccurred.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.DATA_PERMISSION_NO_TABLE);
        }
    }

    private String findTableName(Map map) {
        HashSet<String> names = RowFilter.extractName(map);
        return names.iterator().next();
    }
}

