/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.datapolicy;

import com.digiwin.dap.middleware.util.SnowFlake;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class RowFilter {
    public static final RowFilter NULL_ROW_FILTER = new RowFilter();
    Long sid;
    String filterType;
    String filterField;
    String filterTable;
    String filterTableName;
    Object filterValue;
    String filterTypeName;
    List<String> filterValueName;
    String dataType;
    String fieldName;
    String dataSource;

    public RowFilter() {
    }

    public RowFilter(Long sid, String filterType, String filterTypeName, String filterTable, String filterTableName, String filterField, String fieldName, Object filterValue, List<String> filterValueName, String dataType, String dataSource) {
        this.sid = sid;
        this.filterType = filterType;
        this.filterField = filterField;
        this.filterTable = filterTable;
        this.filterTableName = filterTableName;
        this.filterValue = filterValue;
        this.filterTypeName = filterTypeName;
        this.filterValueName = filterValueName;
        this.dataType = dataType;
        this.fieldName = fieldName;
        this.dataSource = dataSource;
    }

    public static RowFilter buildRowFilter4OR(List<RowFilter> input) {
        if (input.size() == 1) {
            return input.get(0);
        }
        RowFilter result = new RowFilter();
        result.setSid(SnowFlake.getInstance().newId());
        result.setFilterType("or");
        result.setFilterValue(input);
        return result;
    }

    public static RowFilter buildRowFilter4Group(List<RowFilter> input) {
        HashMap<String, RowFilter> tables = new HashMap<String, RowFilter>();
        RowFilter result = new RowFilter();
        result.setSid(SnowFlake.getInstance().newId());
        result.setFilterType("group");
        result.setFilterValue(tables);
        for (RowFilter aTable : input) {
            HashSet<String> names = RowFilter.extractName(aTable);
            if (names.isEmpty()) continue;
            String tableName = names.iterator().next();
            if (names.size() > 1) {
                tableName = "default";
            }
            if (StringUtils.isEmpty((Object)tableName)) continue;
            tables.put(tableName, aTable);
        }
        return result;
    }

    public static HashSet<String> extractName(Object filterValue) {
        HashSet<String> namesOccurredInThisValue = new HashSet<String>();
        if (filterValue instanceof RowFilter) {
            Object valueOfRowFilter = ((RowFilter)filterValue).getFilterValue();
            String filterTable = ((RowFilter)filterValue).getFilterTable();
            if (filterTable != null) {
                namesOccurredInThisValue.add(filterTable);
            }
            namesOccurredInThisValue.addAll(RowFilter.extractName(valueOfRowFilter));
            return namesOccurredInThisValue;
        }
        if (filterValue instanceof String) {
            return namesOccurredInThisValue;
        }
        if (filterValue instanceof Map) {
            Object valueOfMap = ((Map)filterValue).get("filterValue");
            Object tableOfMap = ((Map)filterValue).get("filterTable");
            if (tableOfMap != null) {
                namesOccurredInThisValue.add((String)tableOfMap);
            }
            namesOccurredInThisValue.addAll(RowFilter.extractName(valueOfMap));
            return namesOccurredInThisValue;
        }
        if (filterValue instanceof List) {
            for (Object o : (List)filterValue) {
                namesOccurredInThisValue.addAll(RowFilter.extractName(o));
            }
            return namesOccurredInThisValue;
        }
        return namesOccurredInThisValue;
    }

    @JsonIgnore
    public boolean isNull() {
        return this == NULL_ROW_FILTER;
    }

    public Long getSid() {
        return this.sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public String getFilterField() {
        return this.filterField;
    }

    public void setFilterField(String filterField) {
        this.filterField = filterField;
    }

    public String getFilterTable() {
        return this.filterTable;
    }

    public void setFilterTable(String filterTable) {
        this.filterTable = filterTable;
    }

    public String getFilterTableName() {
        return this.filterTableName;
    }

    public void setFilterTableName(String filterTableName) {
        this.filterTableName = filterTableName;
    }

    public Object getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(Object filterValue) {
        this.filterValue = filterValue;
    }

    public String getFilterTypeName() {
        return this.filterTypeName;
    }

    public void setFilterTypeName(String filterTypeName) {
        this.filterTypeName = filterTypeName;
    }

    public List<String> getFilterValueName() {
        return this.filterValueName;
    }

    public void setFilterValueName(List<String> filterValueName) {
        this.filterValueName = filterValueName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public List<String> fetchAllValues() {
        ArrayList<String> values = new ArrayList<String>();
        if (this.filterValue instanceof List) {
            ((List)this.filterValue).forEach(o -> values.addAll(o.fetchValues()));
        }
        return values;
    }

    public List<String> fetchValues() {
        if (this.filterValue instanceof List) {
            return (List)this.filterValue;
        }
        return new ArrayList<String>();
    }

    public List<String> fetchAllNames() {
        ArrayList<String> values = new ArrayList<String>();
        if (this.filterValue instanceof List) {
            ((List)this.filterValue).forEach(o -> values.addAll(o.getFilterValueName()));
        }
        return values;
    }
}

