/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.dev;

import com.digiwin.dap.middleware.iam.domain.dev.DevelopAction;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopLanguage;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopModule;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopSys;
import java.util.ArrayList;
import java.util.List;

public class DevelopApp {
    private String appToken;
    private DevelopSys app;
    private List<DevelopModule> modules = new ArrayList<DevelopModule>();
    private List<DevelopAction> actions = new ArrayList<DevelopAction>();

    public void toLanguage() {
        this.app.toLanguage();
        this.modules.forEach(DevelopLanguage::toLanguage);
        this.actions.forEach(action -> {
            action.toLanguage();
            action.getCondition().forEach(condition -> {
                condition.toLanguage();
                condition.toParameter();
            });
        });
    }

    public void toLanguage(String language) {
        this.app.toLanguage(language);
        this.modules.forEach(o -> o.toLanguage(language));
        this.actions.forEach(action -> {
            action.toLanguage(language);
            action.getCondition().forEach(condition -> {
                condition.toLanguage(language);
                condition.toParameter();
            });
        });
    }

    public String getAppToken() {
        return this.appToken;
    }

    public DevelopSys getApp() {
        return this.app;
    }

    public List<DevelopModule> getModules() {
        return this.modules;
    }

    public List<DevelopAction> getActions() {
        return this.actions;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public void setApp(DevelopSys app) {
        this.app = app;
    }

    public void setModules(List<DevelopModule> modules) {
        this.modules = modules;
    }

    public void setActions(List<DevelopAction> actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DevelopApp)) {
            return false;
        }
        DevelopApp other = (DevelopApp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appToken = this.getAppToken();
        String other$appToken = other.getAppToken();
        if (this$appToken == null ? other$appToken != null : !this$appToken.equals(other$appToken)) {
            return false;
        }
        DevelopSys this$app = this.getApp();
        DevelopSys other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        List<DevelopModule> this$modules = this.getModules();
        List<DevelopModule> other$modules = other.getModules();
        if (this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules)) {
            return false;
        }
        List<DevelopAction> this$actions = this.getActions();
        List<DevelopAction> other$actions = other.getActions();
        return !(this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DevelopApp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appToken = this.getAppToken();
        result = result * 59 + ($appToken == null ? 43 : $appToken.hashCode());
        DevelopSys $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        List<DevelopModule> $modules = this.getModules();
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        List<DevelopAction> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        return result;
    }

    public String toString() {
        return "DevelopApp(appToken=" + this.getAppToken() + ", app=" + this.getApp() + ", modules=" + this.getModules() + ", actions=" + this.getActions() + ")";
    }
}

