/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.dev;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopLanguage;
import com.digiwin.dap.middleware.iam.entity.DevCondition;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DevelopCondition
extends DevelopLanguage {
    private String key;
    private String type;
    private List<String> typeParameter = new ArrayList<String>();
    private String parameter;
    private String defaultValue;
    @JsonIgnore
    private Long actionSid;
    private String actionId;
    private String actionName;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getTypeParameter() {
        return this.typeParameter;
    }

    public void setTypeParameter(List<String> typeParameter) {
        this.typeParameter = typeParameter;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Long getActionSid() {
        return this.actionSid;
    }

    public void setActionSid(Long actionSid) {
        this.actionSid = actionSid;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void toParameter() {
        try {
            this.typeParameter = (List)JsonUtils.createObjectMapper().readValue(this.parameter, (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DevCondition generateEntity(Long actionSid) {
        DevCondition condition = new DevCondition();
        condition.setSid(SnowFlake.getInstance().newId());
        condition.setKey(this.getKey());
        condition.setNameCN(this.getName());
        condition.setNameTW(this.getName());
        condition.setNameUS(this.getName());
        condition.setNameVN(this.getName());
        condition.setType(this.type);
        condition.setTypeParameter(JsonUtils.objToJson(this.typeParameter));
        condition.setDefaultValue(this.defaultValue);
        condition.setDevActionSid(actionSid);
        EntityUtils.setCreateFields((BaseEntity)condition);
        return condition;
    }

    public void updateEntity(String language, DevCondition devCondition, long actionSid) {
        if ("zh-TW".equals(language)) {
            devCondition.setNameTW(this.getName());
        } else if ("en-US".equals(language)) {
            devCondition.setNameUS(this.getName());
        } else if ("vi-VN".equals(language)) {
            devCondition.setNameVN(this.getName());
        } else {
            devCondition.setNameCN(this.getName());
        }
        devCondition.setType(this.type);
        devCondition.setTypeParameter(JsonUtils.objToJson(this.typeParameter));
        devCondition.setDefaultValue(this.defaultValue);
        devCondition.setDevActionSid(actionSid);
        EntityUtils.setModifyFields((BaseEntity)devCondition);
    }
}

