/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.enumeration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum GoodsCategoryEnum {
    APP,
    SERVICE,
    COURSE,
    PACKAGE,
    PLATFORM,
    DEVICE,
    BUNDLE,
    API,
    RESOURCE;


    public static boolean isApp(String categoryId) {
        return APP.name().equalsIgnoreCase(categoryId) || PLATFORM.name().equalsIgnoreCase(categoryId) || BUNDLE.name().equalsIgnoreCase(categoryId) || API.name().equalsIgnoreCase(categoryId) || RESOURCE.name().equalsIgnoreCase(categoryId);
    }

    public static List<String> getApps() {
        return GoodsCategoryEnum.getApps(true);
    }

    public static List<String> getApps(boolean isIncludePlatForm) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(APP.name().toLowerCase());
        list.add(BUNDLE.name().toLowerCase());
        if (isIncludePlatForm) {
            list.add(PLATFORM.name().toLowerCase());
        }
        return list;
    }

    public static List<String> getCategoryIds(String categoryId) {
        return GoodsCategoryEnum.getCategoryIds(categoryId, true);
    }

    public static List<String> getCategoryIds(String categoryId, boolean isIncludePlatForm) {
        if (APP.name().equalsIgnoreCase(categoryId)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(APP.name().toLowerCase());
            list.add(BUNDLE.name().toLowerCase());
            list.add(API.name().toLowerCase());
            list.add(RESOURCE.name().toLowerCase());
            if (isIncludePlatForm) {
                list.add(PLATFORM.name().toLowerCase());
            }
            return list;
        }
        return Collections.singletonList(categoryId);
    }

    public static boolean isResource(String categoryId) {
        return RESOURCE.name().equalsIgnoreCase(categoryId);
    }

    public static boolean isApi(String categoryId) {
        return API.name().equalsIgnoreCase(categoryId);
    }

    public String id() {
        return this.name().toLowerCase();
    }
}

