/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.login;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredDevice;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordVO;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.OauthLoginRequest;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.fasterxml.jackson.annotation.JsonIgnore;
import eu.bitwalker.useragentutils.DeviceType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class LoginUser {
    private static final String NON_TENANT = "nontenant";
    private static final String NON_SYS = "nonsys";
    private static final String NON_DEVICE = "nondevice";
    private static final String NON_AGENT_USER = "nonagentuser";
    private long userSid;
    private String userId;
    private long tenantSid;
    private String tenantId;
    private String sysId;
    private String password;
    private String passwordHash;
    private String passwordHash1;
    private String client_id;
    private DeviceType deviceType;
    private IdentityType identityType = IdentityType.token;
    private String serviceName;
    private String secretKey;
    private String captcha;
    private String key;
    private String clientEncryptPublicKey;
    private Map<String, String> metadata = new HashMap<String, String>();
    private String userToken;
    private String verificationCode;
    private User user;
    private Tenant tenant;
    private Sys app;
    private String tokenExpireSysId;
    private AuthoredDevice device;
    @JsonIgnore
    private OauthLoginRequest oauthLoginRequest;
    @JsonIgnore
    private Boolean userDoubleCheck = false;
    @JsonIgnore
    private Boolean tenantDoubleCheck = false;
    @JsonIgnore
    private Boolean sysMultiLogin = true;
    @JsonIgnore
    private Boolean sysInside = false;
    @JsonIgnore
    private Boolean sysPlatform = false;
    @JsonIgnore
    private Boolean sysDoubleCheck = false;
    @JsonIgnore
    private LoginSource loginSource;
    private String agentAuthorizationCode;
    private String agentToken;
    @JsonIgnore
    private List<ServiceAuthorizationRecordVO> recordVOS;
    private String agentUserId;
    private String code;
    private String value;
    private String tempUserToken;
    private String gclid;
    private Boolean excludeNonVisible = false;

    public String getAgentToken() {
        return this.agentToken;
    }

    public void setAgentToken(String agentToken) {
        this.agentToken = agentToken;
    }

    public LoginUser() {
        this.deviceType = AppAuthContextHolder.getContext().getDeviceType();
    }

    public LoginUser(String userId, Sys app, String password) {
        this();
        this.userId = userId;
        this.app = app;
        this.password = password;
    }

    public static String uniqueKey(String userId, String tenantId, String sysId, DeviceType deviceType, IdentityType identityType, String agentUserId, AuthoredDevice device, Boolean sysMultiLogin) {
        if ("integration".equalsIgnoreCase(userId) || "virtual".equalsIgnoreCase(userId)) {
            if (IdentityType.crossRegion == identityType) {
                return String.format("iam:login:cross:key:%s::%s::%s::%s", userId, tenantId == null ? NON_TENANT : tenantId, sysId == null ? NON_SYS : sysId, deviceType).toLowerCase();
            }
            return String.format("iam:login:%s::%s::%s::%s", userId, tenantId == null ? NON_TENANT : tenantId, sysId == null ? NON_SYS : sysId, deviceType).toLowerCase();
        }
        if (IdentityType.agent == identityType) {
            return String.format("iam:login:agent:key:%s::%s::%s::%s::%s::%s", userId, tenantId == null ? NON_TENANT : tenantId, sysId == null ? NON_SYS : sysId, deviceType, agentUserId == null ? NON_AGENT_USER : agentUserId, device == null || sysMultiLogin == false ? NON_DEVICE : device.getDeviceKey()).toLowerCase();
        }
        return String.format("iam:login:%s::%s::%s::%s::%s", userId, tenantId == null ? NON_TENANT : tenantId, sysId == null ? NON_SYS : sysId, deviceType, device == null || sysMultiLogin == false ? NON_DEVICE : device.getDeviceKey()).toLowerCase();
    }

    public static String userKey(String userId, String ... args) {
        StringBuilder uniqueKey = new StringBuilder(userId);
        for (String arg : args) {
            uniqueKey.append("::").append(arg);
        }
        return String.format("iam:login:%s::*", uniqueKey.toString().toLowerCase());
    }

    public static String tenantKey(String tenantId) {
        return String.format("iam:login:*::%s::*", tenantId.toLowerCase());
    }

    public static String tokenKey(String token) {
        return String.format("iam:token:%s", token);
    }

    public static String agentTokenKey(String token) {
        return String.format("iam:agent:token:%s", token);
    }

    public static String agentListKey(String tenantId, String userId) {
        return String.format("iam:agent:list:key:%s::%s", tenantId, userId);
    }

    public static String sysKey(String sysId) {
        return String.format("iam:login:%s::%s::%s::%s", "*", "*", sysId, "*");
    }

    public static String cacAuthKey(String tenantId, String userId, String sysId) {
        return String.format("cac:tenant:user:auth:%s::%s::%s", tenantId, userId, sysId);
    }

    public static String verificationTokenKey(String token) {
        return String.format("iam:verification:token:%s", token);
    }

    public static String verificationSuccessKey(String userId, DeviceType deviceType) {
        return String.format("iam:verifySuccess:%s::%s", userId, deviceType).toLowerCase();
    }

    public void afterPropertiesSet() {
        if (this.user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_INFO_NOT_EXIST_CANNOT_LOGIN);
        }
        this.userSid = this.user.getSid();
        this.userId = this.user.getId();
        this.userDoubleCheck = Boolean.TRUE.equals(this.user.getDoubleCheck());
        if (this.tenant != null) {
            this.tenantSid = this.tenant.getSid();
            this.tenantId = this.tenant.getId();
            this.tenantDoubleCheck = Boolean.TRUE.equals(this.tenant.getDoubleCheck());
        }
        if (!StringUtils.hasText((String)this.tenantId)) {
            this.tenantId = null;
        }
        if (this.app != null) {
            this.sysId = this.app.getId();
            this.sysMultiLogin = this.app.isMultiLogin();
            this.sysInside = this.app.isInside();
            this.sysPlatform = this.app.isPlatform();
            this.sysDoubleCheck = this.app.isDoubleCheck();
        }
    }

    public String uniqueKey() {
        if ("integration".equalsIgnoreCase(this.userId) || "virtual".equalsIgnoreCase(this.userId)) {
            if (IdentityType.crossRegion == this.getIdentityType()) {
                return String.format("iam:login:cross:key:%s::%s::%s::%s", this.userId, this.tenantId == null ? NON_TENANT : this.tenantId, this.sysId == null ? NON_SYS : this.sysId, this.deviceType).toLowerCase();
            }
            return String.format("iam:login:%s::%s::%s::%s", this.userId, this.tenantId == null ? NON_TENANT : this.tenantId, this.sysId == null ? NON_SYS : this.sysId, this.deviceType).toLowerCase();
        }
        if (IdentityType.agent == this.getIdentityType()) {
            return String.format("iam:login:agent:key:%s::%s::%s::%s::%s::%s", this.userId, this.tenantId == null ? NON_TENANT : this.tenantId, this.sysId == null ? NON_SYS : this.sysId, this.deviceType, this.agentUserId == null ? NON_AGENT_USER : this.agentUserId, this.device == null || this.sysMultiLogin == false ? NON_DEVICE : this.device.getDeviceKey()).toLowerCase();
        }
        return String.format("iam:login:%s::%s::%s::%s::%s", this.userId, this.tenantId == null ? NON_TENANT : this.tenantId, this.sysId == null ? NON_SYS : this.sysId, this.deviceType, this.device == null || this.sysMultiLogin == false ? NON_DEVICE : this.device.getDeviceKey()).toLowerCase();
    }

    public String verificationSuccessKey() {
        return String.format("iam:verifySuccess:%s::%s", this.userId, this.deviceType).toLowerCase();
    }

    public String decideIdentityCodeAcceptType() {
        String type = null;
        if (this.tenant != null && Boolean.TRUE.equals(this.tenant.getDoubleCheck()) && StringUtils.hasLength((String)this.tenant.getIdentityCodeAcceptType())) {
            type = this.tenant.getIdentityCodeAcceptType();
        }
        if (this.user != null && Boolean.TRUE.equals(this.user.getDoubleCheck()) && StringUtils.hasLength((String)this.user.getIdentityCodeAcceptType())) {
            type = this.user.getIdentityCodeAcceptType();
        }
        return type;
    }

    public String decideDoubleCheckSetBy() {
        if (this.userDoubleCheck.booleanValue()) {
            return "user";
        }
        if (this.tenantDoubleCheck.booleanValue()) {
            return "tenant";
        }
        return null;
    }

    public boolean doubleCheckEnabledByTenantAndUser() {
        boolean tenantEnabled = this.tenant != null && Boolean.TRUE.equals(this.tenant.getDoubleCheck());
        boolean userEnabled = this.user != null && Boolean.TRUE.equals(this.user.getDoubleCheck());
        return !"integration".equalsIgnoreCase(this.userId) && !"virtual".equalsIgnoreCase(this.getUserId()) && (tenantEnabled || userEnabled);
    }

    public long getUserSid() {
        return this.userSid;
    }

    public void setUserSid(long userSid) {
        this.userSid = userSid;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getSysId() {
        return this.sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public String getPasswordHash1() {
        return this.passwordHash1;
    }

    public void setPasswordHash1(String passwordHash1) {
        this.passwordHash1 = passwordHash1;
    }

    public String getClient_id() {
        return this.client_id;
    }

    public void setClient_id(String client_id) {
        this.client_id = client_id;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public void setIdentityType(IdentityType identityType) {
        this.identityType = identityType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getCaptcha() {
        return this.captcha;
    }

    public void setCaptcha(String captcha) {
        this.captcha = captcha;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getClientEncryptPublicKey() {
        return this.clientEncryptPublicKey;
    }

    public void setClientEncryptPublicKey(String clientEncryptPublicKey) {
        this.clientEncryptPublicKey = clientEncryptPublicKey;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public String getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public Sys getApp() {
        return this.app;
    }

    public void setApp(Sys app) {
        this.app = app;
    }

    public Boolean getUserDoubleCheck() {
        return this.userDoubleCheck;
    }

    public void setUserDoubleCheck(Boolean userDoubleCheck) {
        this.userDoubleCheck = userDoubleCheck;
    }

    public Boolean getSysMultiLogin() {
        return this.sysMultiLogin;
    }

    public void setSysMultiLogin(Boolean sysMultiLogin) {
        this.sysMultiLogin = sysMultiLogin;
    }

    public Boolean getSysInside() {
        return this.sysInside;
    }

    public void setSysInside(Boolean sysInside) {
        this.sysInside = sysInside;
    }

    public Boolean getSysPlatform() {
        return this.sysPlatform;
    }

    public void setSysPlatform(Boolean sysPlatform) {
        this.sysPlatform = sysPlatform;
    }

    public Boolean getSysDoubleCheck() {
        return this.sysDoubleCheck;
    }

    public void setSysDoubleCheck(Boolean sysDoubleCheck) {
        this.sysDoubleCheck = sysDoubleCheck;
    }

    public OauthLoginRequest getOauthLoginRequest() {
        return this.oauthLoginRequest;
    }

    public void setOauthLoginRequest(OauthLoginRequest oauthLoginRequest) {
        this.oauthLoginRequest = oauthLoginRequest;
    }

    public LoginSource getLoginSource() {
        return this.loginSource;
    }

    public void setLoginSource(LoginSource loginSource) {
        this.loginSource = loginSource;
    }

    public String getAgentAuthorizationCode() {
        return this.agentAuthorizationCode;
    }

    public void setAgentAuthorizationCode(String agentAuthorizationCode) {
        this.agentAuthorizationCode = agentAuthorizationCode;
    }

    public List<ServiceAuthorizationRecordVO> getRecordVOS() {
        return this.recordVOS;
    }

    public void setRecordVOS(List<ServiceAuthorizationRecordVO> recordVOS) {
        this.recordVOS = recordVOS;
    }

    public String getAgentUserId() {
        return this.agentUserId;
    }

    public void setAgentUserId(String agentUserId) {
        this.agentUserId = agentUserId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getTempUserToken() {
        return this.tempUserToken;
    }

    public void setTempUserToken(String tempUserToken) {
        this.tempUserToken = tempUserToken;
    }

    public String getGclid() {
        return this.gclid;
    }

    public void setGclid(String gclid) {
        this.gclid = gclid;
    }

    public Boolean getTenantDoubleCheck() {
        return this.tenantDoubleCheck;
    }

    public void setTenantDoubleCheck(Boolean tenantDoubleCheck) {
        this.tenantDoubleCheck = tenantDoubleCheck;
    }

    public AuthoredDevice getDevice() {
        return this.device;
    }

    public void setDevice(AuthoredDevice device) {
        this.device = device;
    }

    public String getTokenExpireSysId() {
        return this.tokenExpireSysId;
    }

    public void setTokenExpireSysId(String tokenExpireSysId) {
        this.tokenExpireSysId = tokenExpireSysId;
    }

    public Boolean getExcludeNonVisible() {
        return this.excludeNonVisible;
    }

    public void setExcludeNonVisible(Boolean excludeNonVisible) {
        this.excludeNonVisible = excludeNonVisible;
    }
}

