/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.org;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.ImportOrgExcelVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportResultVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Scope(value="prototype")
public class OrgImportContext {
    private static final Logger log = LoggerFactory.getLogger(OrgImportContext.class);
    @Resource
    private OrgCatalogCrudService orgCatalogCrudService;
    @Resource
    private OrgAspectCrudService orgAspectCrudService;
    @Resource
    private OrgTypeCrudService orgTypeCrudService;
    @Resource
    private OrgRepository orgRepository;
    @Resource
    private OrgCrudService orgCrudService;
    private final List<ImportOrgExcelVO> checkSuccess = new ArrayList<ImportOrgExcelVO>();
    private final List<ImportOrgExcelVO> checkFailure = new ArrayList<ImportOrgExcelVO>();
    private final List<Org> toInsert = new ArrayList<Org>();
    private final List<Org> removed = new ArrayList<Org>();
    private final List<Org> toUpdate = new ArrayList<Org>();
    private final List<Org> all = new ArrayList<Org>();
    private long orgCatalogSid;
    private long orgAspectSid;
    private HashMap<String, Long> orgTypeMap;
    private long tenantSid;

    public void doImport() {
        if (this.toInsert.isEmpty()) {
            return;
        }
        for (Org org : this.toInsert) {
            String uri = org.getUri();
            String parentUri = uri.substring(0, uri.lastIndexOf(":"));
            Optional<Org> parent = this.all.stream().filter(a -> a.getUri().equals(parentUri)).findFirst();
            parent.ifPresent(value -> org.setParentSid(value.getSid()));
            this.orgCrudService.create((BaseEntity)org);
            this.all.add(org);
        }
        this.orgCrudService.saveAll(this.toUpdate);
        this.orgCrudService.saveAll(this.removed);
    }

    public void checkImport(List<ImportOrgExcelVO> orgVOs) {
        if (CollectionUtils.isEmpty(orgVOs)) {
            return;
        }
        this.tenantSid = UserUtils.getTenantSid();
        this.orgCatalogSid = this.orgCatalogCrudService.getSidByTenantAndId(this.tenantSid, "defaultOrgCatalog");
        this.orgAspectSid = this.orgAspectCrudService.getSidByUnionKey(new Object[]{this.tenantSid, this.orgCatalogSid, "defaultOrgAspect"});
        this.orgTypeMap = this.orgTypeCrudService.findByTenantSid(this.tenantSid).stream().collect(HashMap::new, (m, v) -> m.put(v.getId(), v.getSid()), HashMap::putAll);
        ArrayList<ImportOrgExcelVO> originVOs = new ArrayList<ImportOrgExcelVO>();
        OrgImportContext.flat(orgVOs, originVOs);
        this.all.addAll(this.orgRepository.findByTenantSid(this.tenantSid));
        for (ImportOrgExcelVO origin : originVOs) {
            if (this.all.stream().noneMatch(a -> a.getUri().equals(origin.getUri()))) {
                origin.setOperation(0);
                continue;
            }
            origin.setOperation(1);
        }
        for (Org org : this.all) {
            if (!originVOs.stream().noneMatch(a -> a.getUri().equals(org.getUri()))) continue;
            this.removed.add(org);
            OrgImportContext.changeName(org, org.getName().contains("-\u5c01\u5b58") ? org.getName() : org.getName() + "-\u5c01\u5b58");
        }
        HashSet<String> checkedOrgIds = new HashSet<String>();
        for (ImportOrgExcelVO orgVO : originVOs) {
            if (orgVO.getOperation() == 1) {
                this.modify(orgVO);
                continue;
            }
            this.create(orgVO, checkedOrgIds);
        }
    }

    private void modify(ImportOrgExcelVO orgVO) {
        Org mod = this.orgRepository.findByTenantSidAndUri(this.tenantSid, orgVO.getUri());
        OrgImportContext.changeName(mod, orgVO.getName());
        this.checkSuccess.add(orgVO);
        this.toUpdate.add(mod);
    }

    private void create(ImportOrgExcelVO orgVO, HashSet<String> checkedOrgIds) {
        StringBuilder errorMessage = new StringBuilder();
        if (checkedOrgIds.contains(orgVO.getOrgId())) {
            errorMessage.append(I18nError.ORG_ID_REPEAT.getErrorMessage(new Object[]{orgVO.getOrgId()}));
        }
        orgVO.setTenantSid(this.tenantSid);
        if (!StringUtil.checkSpecialId(orgVO.getOrgId())) {
            errorMessage.append(I18nError.ORG_ID_ERROR.getErrorMessage());
        }
        if (orgVO.getTypeId() == null) {
            errorMessage.append(I18nError.ORG_TYPE_NOT_EXISTED.getErrorMessage());
        }
        orgVO.setOrgCatalogSid(this.orgCatalogSid);
        orgVO.setOrgAspectSid(this.orgAspectSid);
        long orgTypeSid = this.orgTypeMap.get(orgVO.getTypeId());
        if (orgTypeSid > 0L) {
            orgVO.setTypeSid(orgTypeSid);
        } else {
            errorMessage.append(I18nError.ORG_TYPE_NOT_EXISTED.getErrorMessage());
        }
        if (errorMessage.length() > 0) {
            orgVO.setError(errorMessage.toString());
            this.checkFailure.add(orgVO);
        } else {
            Org org = orgVO.convertToOrg();
            checkedOrgIds.add(org.getId());
            this.checkSuccess.add(orgVO);
            this.toInsert.add(org);
        }
        if (orgVO.hasError()) {
            orgVO.recursiveSetChildrenError();
        }
    }

    private static void changeName(Org org, String name) {
        org.setName(name);
        if (org.getUrn() != null) {
            CharSequence[] urn = org.getUrn().split(":");
            urn[urn.length - 1] = name;
            org.setUrn(String.join((CharSequence)":", urn));
        }
    }

    private static void flat(List<ImportOrgExcelVO> orgVOs, List<ImportOrgExcelVO> destVOs) {
        if (CollectionUtils.isEmpty(orgVOs)) {
            return;
        }
        for (ImportOrgExcelVO orgVO : orgVOs) {
            String parentUri = orgVO.getParentUri();
            if (parentUri != null) {
                orgVO.setUri(orgVO.getParentUri() + ":" + orgVO.getOrgId());
                orgVO.setUrn(orgVO.getParentUrn() + ":" + orgVO.getName());
            } else {
                orgVO.setUri("drn:iam:org:defaultOrgCatalog:defaultOrgAspect:" + orgVO.getOrgId());
                orgVO.setUrn("\u9ed8\u8ba4\u7ec4\u7ec7\u5206\u7c7b:\u9ed8\u8ba4\u7ec4\u7ec7\u6811:" + orgVO.getName());
            }
            destVOs.add(orgVO);
            if (CollectionUtils.isEmpty(orgVO.getChildrenOrgs())) continue;
            orgVO.getChildrenOrgs().forEach(a -> a.setParentUri(orgVO.getUri()));
            orgVO.getChildrenOrgs().forEach(a -> a.setParentUrn(orgVO.getUrn()));
            OrgImportContext.flat(orgVO.getChildrenOrgs(), destVOs);
        }
    }

    public ImportResultVO<List<ImportOrgExcelVO>> getImportResult() {
        ImportResultVO<List<ImportOrgExcelVO>> importResultVO = new ImportResultVO<List<ImportOrgExcelVO>>();
        importResultVO.setSuccessCount(this.checkFailure.isEmpty() ? this.checkSuccess.size() : 0);
        importResultVO.setErrorCount(this.checkFailure.size());
        if (!this.checkFailure.isEmpty()) {
            importResultVO.setError(this.checkFailure);
        }
        return importResultVO;
    }

    public List<ImportOrgExcelVO> getCheckFailure() {
        return this.checkFailure;
    }
}

