/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.permission.v2;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionPolicy;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CacAuthData
implements Serializable {
    private static final long serialVersionUID = -7437418405567251487L;
    private Set<String> validModuleIds = new HashSet<String>();
    private Set<String> expiredModuleIds = new HashSet<String>();
    private Map<String, Set<String>> validActions = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> expiredActions = new HashMap<String, Set<String>>();

    public void determineDenyReason(PermissionPolicy action) {
        DenyReason reason = this.getDenyReason(action);
        action.setDenyReason(reason.ordinal());
    }

    private DenyReason getDenyReason(PermissionPolicy action) {
        String actionId = action.getId();
        String moduleId = action.getModuleId();
        if (StrUtils.isNotEmpty((Long)action.getTenantSid())) {
            return DenyReason.DEFAULT;
        }
        if (!this.validModuleIds.contains(moduleId) && !this.expiredModuleIds.contains(moduleId)) {
            return DenyReason.MODULE_NO_AUTH;
        }
        if (this.expiredModuleIds.contains(moduleId)) {
            return DenyReason.MODULE_EXPIRED;
        }
        if (this.validActions.containsKey(moduleId) && !this.validActions.get(moduleId).contains(actionId) && this.expiredActions.containsKey(moduleId) && !this.expiredActions.get(moduleId).contains(actionId)) {
            return DenyReason.ACTION_NO_AUTH;
        }
        if (this.expiredActions.containsKey(moduleId) && this.expiredActions.get(moduleId).contains(actionId)) {
            return DenyReason.ACTION_EXPIRED;
        }
        return DenyReason.DEFAULT;
    }

    public boolean validAction(String moduleId, String actionId) {
        return this.validActions.get(moduleId) == null || this.validActions.get(moduleId).contains(actionId);
    }

    public Set<String> getValidModuleIds() {
        return this.validModuleIds;
    }

    public void setValidModuleIds(Set<String> validModuleIds) {
        this.validModuleIds = validModuleIds;
    }

    public Set<String> getExpiredModuleIds() {
        return this.expiredModuleIds;
    }

    public void setExpiredModuleIds(Set<String> expiredModuleIds) {
        this.expiredModuleIds = expiredModuleIds;
    }

    public Map<String, Set<String>> getValidActions() {
        return this.validActions;
    }

    public void setValidActions(Map<String, Set<String>> validActions) {
        this.validActions = validActions;
    }

    public Map<String, Set<String>> getExpiredActions() {
        return this.expiredActions;
    }

    public void setExpiredActions(Map<String, Set<String>> expiredActions) {
        this.expiredActions = expiredActions;
    }

    private static enum DenyReason {
        DEFAULT,
        MODULE_NO_AUTH,
        MODULE_EXPIRED,
        ACTION_NO_AUTH,
        ACTION_EXPIRED;

    }
}

