/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.permission.v2;

import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuEffect;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuType;
import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementType;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetAction;
import com.digiwin.dap.middleware.iam.entity.Policy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StatementInfo {
    private static final String COLON = ":";
    private static final String SEMICOLON = ";";
    private final long menuSid;
    private final int statementType;
    private final MenuType menuType;
    private final MenuEffect menuEffect;

    public StatementInfo(String statementValue) {
        String[] statement = statementValue.split(COLON);
        this.menuSid = Long.parseLong(statement[0]);
        this.statementType = Integer.parseInt(statement[1]);
        this.menuType = this.statementType <= 1 ? MenuType.action : MenuType.module;
        this.menuEffect = this.statementType % 2 == 1 ? MenuEffect.allow : MenuEffect.deny;
    }

    public static List<TargetAction> getPolicyStatement(List<Policy> policies) {
        return policies.stream().flatMap(policy -> StatementInfo.getStatement(policy.getStatementValue()).map(statementInfo -> new TargetAction((Policy)((Object)policy), (StatementInfo)statementInfo))).collect(Collectors.toList());
    }

    public static Map<Long, Integer> getStatementType(String statementValue) {
        return StatementInfo.getStatement(statementValue).collect(Collectors.toMap(StatementInfo::getMenuSid, StatementInfo::getStatementType));
    }

    public static Map<Long, String> getMenuEffect(String statementValue) {
        return StatementInfo.getStatement(statementValue).collect(Collectors.toMap(StatementInfo::getMenuSid, p -> p.getMenuEffect().name()));
    }

    public static String getStatementValue(Map<Long, Integer> menuEffectMap) {
        return menuEffectMap.entrySet().stream().map(entry -> entry.getKey() + COLON + entry.getValue()).collect(Collectors.joining(SEMICOLON));
    }

    public static String getStatementValue(List<Long> allowActionSids) {
        return allowActionSids.stream().map(actionSid -> actionSid + COLON + StatementType.ACTION_ALLOW.ordinal()).collect(Collectors.joining(SEMICOLON));
    }

    public static List<Long> getAllowMenuSids(String statementValue) {
        return StatementInfo.getStatement(statementValue).filter(p -> p.getMenuEffect() == MenuEffect.allow).map(StatementInfo::getMenuSid).collect(Collectors.toList());
    }

    public static List<Long> getAllowModuleSids(String statementValue) {
        return StatementInfo.getStatement(statementValue).filter(p -> p.getStatementType() == StatementType.MODULE_ALLOW.ordinal()).map(StatementInfo::getMenuSid).collect(Collectors.toList());
    }

    public static Map<MenuType, List<Long>> getMenuType(String statementValue) {
        return StatementInfo.getStatement(statementValue).filter(p -> p.getMenuEffect() == MenuEffect.allow).collect(Collectors.groupingBy(StatementInfo::getMenuType, Collectors.mapping(StatementInfo::getMenuSid, Collectors.toList())));
    }

    public static String addAllowActionSids(String statementValue, List<Long> actionSids) {
        if (statementValue == null || statementValue.isEmpty()) {
            return StatementInfo.getStatementValue(actionSids);
        }
        Set statements = Arrays.stream(statementValue.split(SEMICOLON)).filter(stmt -> actionSids.stream().noneMatch(actionSid -> stmt.startsWith(actionSid + COLON))).collect(Collectors.toSet());
        statements.addAll(actionSids.stream().map(actionSid -> actionSid + COLON + StatementType.ACTION_ALLOW.ordinal()).collect(Collectors.toSet()));
        return String.join((CharSequence)SEMICOLON, statements);
    }

    public static String delAllowActionSid(String statementValue, long actionSid) {
        return Arrays.stream(statementValue.split(SEMICOLON)).filter(p -> !p.equals(actionSid + COLON + StatementType.ACTION_ALLOW.ordinal())).collect(Collectors.joining(SEMICOLON));
    }

    private static Stream<StatementInfo> getStatement(String statementValue) {
        if (statementValue == null || statementValue.isEmpty()) {
            return Stream.empty();
        }
        return Arrays.stream(statementValue.split(SEMICOLON)).map(StatementInfo::new);
    }

    public long getMenuSid() {
        return this.menuSid;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public MenuType getMenuType() {
        return this.menuType;
    }

    public MenuEffect getMenuEffect() {
        return this.menuEffect;
    }

    public String toString() {
        return (Object)((Object)this.menuType) + "(" + this.menuSid + ")[" + (Object)((Object)this.menuEffect) + "]";
    }
}

