/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.permission.v2;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuType;

public enum StatementType {
    ACTION_DENY(MenuType.action, false),
    ACTION_ALLOW(MenuType.action, true),
    MODULE_DENY(MenuType.module, false),
    MODULE_ALLOW(MenuType.module, true);

    private final MenuType type;
    private final boolean effect;

    private StatementType(MenuType type, boolean effect) {
        this.type = type;
        this.effect = effect;
    }

    public static StatementType valueOf(MenuType type, boolean effect) {
        for (StatementType statementType : StatementType.values()) {
            if (statementType.type != type || statementType.effect != effect) continue;
            return statementType;
        }
        throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
    }

    public MenuType type() {
        return this.type;
    }

    public boolean effect() {
        return this.effect;
    }
}

