/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.policy.v2;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.iam.domain.datapolicy.RowFilter;
import com.digiwin.dap.middleware.iam.domain.permission.ColPermission;
import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementInfo;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetCondition;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetAction {
    private static final Logger logger = LoggerFactory.getLogger(TargetAction.class);
    private long sid;
    private long policySid;
    private long tenantSid;
    private long sysSid;
    private long targetSid;
    private String targetType;
    private String actionType;
    private long actionSid;
    private String effect;
    private List<TargetCondition> conditions = new ArrayList<TargetCondition>();
    private String row;
    private String col;
    private int tick;

    public TargetAction() {
    }

    public TargetAction(Policy policy, StatementInfo statementInfo) {
        this.policySid = policy.getSid();
        this.tenantSid = policy.getTenantSid();
        this.sysSid = policy.getSysSid();
        this.targetSid = policy.getTargetSid();
        this.targetType = policy.getType();
        this.actionType = statementInfo.getMenuType().name();
        this.actionSid = statementInfo.getMenuSid();
        this.effect = statementInfo.getMenuEffect().name();
    }

    public long getSid() {
        return this.sid;
    }

    public void setSid(long sid) {
        this.sid = sid;
    }

    public long getPolicySid() {
        return this.policySid;
    }

    public void setPolicySid(long policySid) {
        this.policySid = policySid;
    }

    public long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public long getSysSid() {
        return this.sysSid;
    }

    public void setSysSid(long sysSid) {
        this.sysSid = sysSid;
    }

    public long getTargetSid() {
        return this.targetSid;
    }

    public void setTargetSid(long targetSid) {
        this.targetSid = targetSid;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public long getActionSid() {
        return this.actionSid;
    }

    public void setActionSid(long actionSid) {
        this.actionSid = actionSid;
    }

    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public List<TargetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<TargetCondition> conditions) {
        this.conditions = conditions;
    }

    public String getRow() {
        return this.row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public String getCol() {
        return this.col;
    }

    public void setCol(String col) {
        this.col = col;
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public Map<String, String> getConditionMap() {
        return this.conditions.stream().collect(Collectors.toMap(TargetCondition::getKey, TargetCondition::getValue));
    }

    public Map<String, RowFilter> getRowData() {
        if (StrUtils.isNotEmpty((String)this.row)) {
            try {
                return (Map)JsonUtils.createObjectMapper().readValue(this.row, (TypeReference)new TypeReference<Map<String, RowFilter>>(){});
            }
            catch (Exception e) {
                logger.error("\u5e8f\u5217\u5316{}\u5931\u8d25", (Object)this.row, (Object)e);
            }
        }
        return new HashMap<String, RowFilter>();
    }

    @Deprecated
    public RowFilter getRowDataOld() {
        if (StrUtils.isNotEmpty((String)this.row)) {
            try {
                return (RowFilter)JsonUtils.createObjectMapper().readValue(this.row, RowFilter.class);
            }
            catch (Exception e) {
                logger.error("\u5e8f\u5217\u5316{}\u5931\u8d25", (Object)this.row, (Object)e);
            }
        }
        return RowFilter.NULL_ROW_FILTER;
    }

    public List<ColPermission> getColData() {
        if (StrUtils.isNotEmpty((String)this.col)) {
            try {
                return (List)JsonUtils.createObjectMapper().readValue(this.col, (TypeReference)new TypeReference<List<ColPermission>>(){});
            }
            catch (Exception e) {
                logger.error("\u5e8f\u5217\u5316{}\u5931\u8d25", (Object)this.col, (Object)e);
            }
        }
        return new ArrayList<ColPermission>();
    }

    public String toString() {
        return this.targetType + "_" + this.targetSid + ": " + this.actionType + "_" + this.actionSid + "(" + this.conditions.size() + ")[" + this.effect + "](" + this.tick + ")";
    }

    public boolean isOldRowData() {
        RowFilter rowDataOld = this.getRowDataOld();
        return rowDataOld.getFilterType() != null && rowDataOld.getSid() != null && rowDataOld.getFilterValue() != null;
    }
}

