/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.policy.v2;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.permission.v2.MenuType;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetCondition;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

public class TargetPolicy {
    private Long tenantSid;
    @NotBlank
    private String type;
    @NotNull
    private Long targetSid;
    @NotNull
    private Long sysSid;
    private Long moduleSid;
    private Long actionSid;
    private Boolean effect;
    private List<TargetCondition> conditionValue = new ArrayList<TargetCondition>();

    public static List<TargetCondition> getValues(String conditionValue) {
        try {
            if (conditionValue != null && !conditionValue.isEmpty()) {
                return (List)JsonUtils.createObjectMapper().readValue(conditionValue, (TypeReference)new TypeReference<List<TargetCondition>>(){});
            }
        }
        catch (IOException e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    @JsonIgnore
    public MenuType getMenuType() {
        return this.getModuleSid() != null ? MenuType.module : MenuType.action;
    }

    @JsonIgnore
    public Long getMenuSid() {
        return this.getModuleSid() != null ? this.moduleSid : this.actionSid;
    }

    @JsonIgnore
    public String getValue() {
        return JsonUtils.objToJson(this.conditionValue);
    }

    public Long getSysSid() {
        return this.sysSid;
    }

    public void setSysSid(Long sysSid) {
        this.sysSid = sysSid;
    }

    public Long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public Long getTargetSid() {
        return this.targetSid;
    }

    public void setTargetSid(Long targetSid) {
        this.targetSid = targetSid;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getModuleSid() {
        return this.moduleSid;
    }

    public void setModuleSid(Long moduleSid) {
        this.moduleSid = moduleSid;
    }

    public Long getActionSid() {
        return this.actionSid;
    }

    public void setActionSid(Long actionSid) {
        this.actionSid = actionSid;
    }

    public Boolean getEffect() {
        return this.effect;
    }

    public void setEffect(Boolean effect) {
        this.effect = effect;
    }

    public List<TargetCondition> getConditionValue() {
        return this.conditionValue;
    }

    public void setConditionValue(List<TargetCondition> conditionValue) {
        this.conditionValue = conditionValue;
    }
}

