/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.domain.token;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.entity.OtaToken;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;

public class OtaParameter {
    private String id;
    private int code;
    private String errorMsg;
    private IamAuthoredUser authoredUser;
    private Map<String, String> parameter;
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();

    public OtaParameter() {
    }

    public OtaParameter(String id, int code, String parameter) {
        this.id = id;
        this.code = code;
        try {
            this.parameter = (Map)objectMapper.readValue(parameter, Map.class);
        }
        catch (IOException e) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
    }

    public OtaParameter(int code, IamAuthoredUser user, OtaToken otaToken) {
        this.id = String.valueOf(otaToken.getSid());
        this.code = code;
        this.authoredUser = user;
        try {
            this.parameter = (Map)objectMapper.readValue(otaToken.getParameter(), Map.class);
        }
        catch (IOException e) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public IamAuthoredUser getAuthoredUser() {
        return this.authoredUser;
    }

    public void setAuthoredUser(IamAuthoredUser authoredUser) {
        this.authoredUser = authoredUser;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        OtaParameter.objectMapper = objectMapper;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Map<String, String> getParameter() {
        return this.parameter;
    }

    public void setParameter(Map<String, String> parameter) {
        this.parameter = parameter;
    }
}

