/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.entity;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.springframework.util.ObjectUtils;

@Entity
@Table(name="inviteduserhistory")
public class InvitedUserHistory
extends BaseEntity {
    private long tenantSid;
    private long userSid;
    private String userEmail;
    private String userTel;
    private Boolean type;
    private String mode;
    private String content;
    private String org;
    private String role;
    private String app;
    @Column(name="request_date", columnDefinition="DATETIME")
    private LocalDateTime requestDate;
    @Column(name="confirm_date", columnDefinition="DATETIME")
    private LocalDateTime confirmDate;
    private String acceptedStatus;
    private String wechat;
    @Column(name="due_date", columnDefinition="datetime(0) NULL DEFAULT NULL COMMENT '\u6743\u9650\u5230\u671f\u65e5'")
    private LocalDateTime dueDate;
    @Column(name="user_type", columnDefinition="bit(1) DEFAULT 0 COMMENT '\u7528\u6237\u6027\u8d28 1\uff1a\u5916\u90e8\u7528\u6237 0\uff1a\u4e00\u822c\u7528\u6237'")
    private Boolean userType = false;
    @Column(name="emp_id", columnDefinition="VARCHAR(100) DEFAULT '' COMMENT '\u5458\u5de5\u7f16\u53f7'")
    private String empId;
    @Column(name="used")
    private Boolean used = false;

    public InvitedUserHistory generateHistoryTenantInviteUser(long tenantSid, Integer type, String userAccount, String content) {
        InvitedUserHistory history = new InvitedUserHistory();
        history.setType(false);
        history.setContent(content);
        if (ObjectUtils.nullSafeEquals((Object)0, (Object)type)) {
            history.setUserSid(-1L);
            history.setMode("email");
            history.setUserEmail(userAccount);
        } else if (ObjectUtils.nullSafeEquals((Object)1, (Object)type)) {
            history.setUserSid(-1L);
            history.setMode("mobilephone1");
            history.setUserTel(userAccount);
        } else {
            history.setMode("userId");
            history.setUserSid(Long.parseLong(userAccount));
        }
        history.setTenantSid(tenantSid);
        history.setRequestDate(LocalDateTime.now());
        history.setAcceptedstatus(IamConstants.AcceptedStatus.InvitedWaitAgree.toString());
        return history;
    }

    public InvitedUserHistory generateHistoryUserApplyTenant(long tenantSid, long userSid, String content) {
        InvitedUserHistory history = new InvitedUserHistory();
        history.setType(true);
        history.setMode("userId");
        history.setContent(content);
        history.setUserSid(userSid);
        history.setTenantSid(tenantSid);
        history.setRequestDate(LocalDateTime.now());
        history.setAcceptedstatus(IamConstants.AcceptedStatus.ApplyWaitAgree.toString());
        return history;
    }

    public InvitedUserHistory() {
    }

    public InvitedUserHistory(Tenant tenant, User user, String content) {
        this.tenantSid = tenant.getSid();
        this.userSid = user.getSid();
        this.type = false;
        this.userEmail = "";
        this.userTel = "";
        this.mode = "userId";
        this.content = content;
        this.requestDate = LocalDateTime.now();
        this.acceptedStatus = IamConstants.AcceptedStatus.ApplyWaitAgree.toString();
    }

    public Long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public Long getUserSid() {
        return this.userSid;
    }

    public void setUserSid(Long userSid) {
        this.userSid = userSid;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getUserTel() {
        return this.userTel;
    }

    public void setUserTel(String userTel) {
        this.userTel = userTel;
    }

    public Boolean getType() {
        return this.type;
    }

    public void setType(Boolean type) {
        this.type = type;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public LocalDateTime getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(LocalDateTime requestDate) {
        this.requestDate = requestDate;
    }

    public LocalDateTime getConfirmDate() {
        return this.confirmDate;
    }

    public void setConfirmDate(LocalDateTime confirmDate) {
        this.confirmDate = confirmDate;
    }

    public String getAcceptedStatus() {
        return this.acceptedStatus;
    }

    public void setAcceptedstatus(String acceptedStatus) {
        this.acceptedStatus = acceptedStatus;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public void setUserSid(long userSid) {
        this.userSid = userSid;
    }

    public String getOrg() {
        return this.org == null ? "[]" : this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getRole() {
        return this.role == null ? "[]" : this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getApp() {
        return this.app == null ? "[]" : this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getWechat() {
        return this.wechat;
    }

    public void setWechat(String wechat) {
        this.wechat = wechat;
    }

    public LocalDateTime getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDateTime dueDate) {
        this.dueDate = dueDate;
    }

    public Boolean getUserType() {
        return this.userType;
    }

    public void setUserType(Boolean userType) {
        this.userType = userType;
    }

    public String getEmpId() {
        return this.empId;
    }

    public void setEmpId(String empId) {
        this.empId = empId;
    }

    public Boolean getUsed() {
        return this.used;
    }

    public void setUsed(Boolean used) {
        this.used = used;
    }
}

