/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.entity;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.metadata.MetadataColumnVO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="metadatacolumn", uniqueConstraints={@UniqueConstraint(name="uk_metadatacolumn_catalogid_key", columnNames={"CATALOG_ID", "[KEY]"})})
public class MetadataColumn
extends BaseEntity {
    private long tenantSid;
    @Column(name="[KEY]")
    private String key;
    @Column(name="CATALOG_ID")
    private String catalogId;
    private String name;
    private String type;
    private String typeParameter;
    @Column(name="readonly")
    private boolean readOnly;
    private String provider;

    public void convertMetadataColumnVOToMetadataColumn(MetadataColumnVO metadataColumnVO) {
        String typeParameters;
        String providers;
        try {
            providers = new ObjectMapper().writeValueAsString(metadataColumnVO.getProvider());
            typeParameters = new ObjectMapper().writeValueAsString(metadataColumnVO.getTypeParameter());
        }
        catch (JsonProcessingException e) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        this.setKey(metadataColumnVO.getKey());
        this.setName(metadataColumnVO.getName());
        this.setCatalogId(metadataColumnVO.getCatalogId());
        this.setType(metadataColumnVO.getType());
        this.setTypeParameter(typeParameters);
        this.setProvider(providers);
        this.setHash(metadataColumnVO.getHash());
        this.setReadOnly(metadataColumnVO.isReadOnly());
    }

    public long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getTypeParameter() {
        return this.typeParameter;
    }

    public void setTypeParameter(String typeParameter) {
        this.typeParameter = typeParameter;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }
}

