/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.entity;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Entity
@Table(name="sync_tenant_auth_scope")
public class SyncTenantAuthScope
extends BaseEntity {
    private static final Logger logger = LoggerFactory.getLogger(SyncTenantAuthScope.class);
    @Column(name="tenant_sid")
    private Long tenantSid;
    @Column(name="auth_app")
    private String authApp;
    @Column(name="platform")
    private String platform;
    @Column(name="user_ids")
    private String userIds;
    @Column(name="orgs")
    private String orgs;
    @Column(name="try_out_type")
    private String tryoutType;
    @Column(name="strategy_code")
    private String strategyCode;

    public Long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public String getOrgs() {
        return this.orgs;
    }

    public void setOrgs(String orgs) {
        this.orgs = orgs;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getAuthApp() {
        return this.authApp;
    }

    public void setAuthApp(String authApp) {
        this.authApp = authApp;
    }

    public String getTryoutType() {
        return this.tryoutType;
    }

    public void setTryoutType(String tryoutType) {
        this.tryoutType = tryoutType;
    }

    public List<String> getAuthUserIds() {
        if (StringUtils.hasText((String)this.userIds)) {
            try {
                List userIds = (List)JsonUtils.createObjectMapper().readValue(this.userIds, (TypeReference)new TypeReference<List<String>>(){});
                return userIds;
            }
            catch (JsonProcessingException e) {
                logger.error("\u89e3\u6790\u6388\u6743\u7528\u6237\u5931\u8d25", (Throwable)e);
            }
        }
        return new ArrayList<String>();
    }

    public List<Long> getAuthOrgs() {
        if (StringUtils.hasText((String)this.orgs)) {
            try {
                List orgs = (List)JsonUtils.createObjectMapper().readValue(this.orgs, (TypeReference)new TypeReference<List<Long>>(){});
                return orgs;
            }
            catch (JsonProcessingException e) {
                logger.error("\u89e3\u6790\u6388\u6743\u7528\u6237\u5931\u8d25", (Throwable)e);
            }
        }
        return new ArrayList<Long>();
    }

    public String getStrategyCode() {
        return this.strategyCode;
    }

    public void setStrategyCode(String strategyCode) {
        this.strategyCode = strategyCode;
    }
}

