/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.entity;

import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.iam.constant.enums.ResAcquireModeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TeamEnum;
import com.digiwin.dap.middleware.iam.domain.escloud.vo.UserImportInfo;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.springframework.util.StringUtils;

@Entity
@Table(name="tenant", uniqueConstraints={@UniqueConstraint(name="uk_tenant_id", columnNames={"id"})})
public class Tenant
extends BaseEntityWithId {
    @Column(nullable=false, length=100)
    private String name;
    @Column(length=40)
    private String customerId;
    @Column(nullable=false)
    private long ownerUserSid;
    @Column(name="[open]", columnDefinition="bit(1) DEFAULT 1")
    private boolean open = true;
    @Column(name="ISCONFIRM", nullable=false)
    private int confirm;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL COMMENT '\u884c\u4e1a\u7c7b\u578b'")
    private String industryType;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL COMMENT '\u4eba\u5458\u89c4\u6a21'")
    private String staffSize;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL COMMENT '\u8054\u7cfb\u4eba'")
    private String contacts;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL COMMENT '\u90ae\u7bb1'")
    private String email;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL COMMENT '\u56fd\u7801'")
    private String cellphonePrefix;
    @Column(columnDefinition="VARCHAR(20) DEFAULT NULL COMMENT '\u8054\u7cfb\u7535\u8bdd'")
    private String phone;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL COMMENT '\u7535\u8bdd\u53f7\u7801'")
    private String telephone;
    @Column(columnDefinition="VARCHAR(200) DEFAULT NULL COMMENT '\u4f01\u4e1a\u6240\u5728\u5730'")
    private String address;
    @Column(columnDefinition="TEXT")
    private String description;
    @Column(columnDefinition="VARCHAR(300) DEFAULT NULL COMMENT '\u4f01\u4e1aLogo\u94fe\u63a5'")
    private String imageUrl;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL COMMENT '\u79df\u6237\u6765\u6e90'")
    private String comeFrom;
    @Column(columnDefinition="bit(1) DEFAULT 0")
    private boolean testTenant;
    @Column(columnDefinition="bit(1) DEFAULT 0 COMMENT '\u662f\u5426\u4e3a\u7ecf\u9500\u5546\u8eab\u4efd'")
    private boolean dealer;
    @Column(columnDefinition="bigint(20) DEFAULT 0 COMMENT '\u662f\u5426\u4e3a\u7ecf\u9500\u5546\u8eab\u4efd'")
    private long sourceTenantSid;
    @Column(columnDefinition="bit(1) default 0 COMMENT '\u662f\u5426\u542f\u7528\u4f01\u4e1a\u8fd0\u8425'")
    private boolean eoc;
    @Column(name="corp_wechat", columnDefinition="bit(1) default 0 COMMENT '\u662f\u5426\u542f\u7528\u4f01\u4e1a\u5fae\u4fe1,\u9ed8\u8ba40'")
    private boolean corpWechat;
    @Column(name="corp_ding_talk", columnDefinition="bit(1) default 0 COMMENT '\u662f\u5426\u542f\u7528\u9489\u9489\u5185\u90e8\u5e94\u7528,\u9ed8\u8ba40'")
    private boolean corpDingTalk;
    @Column(name="enterprise_type", columnDefinition="INT(2) default 1 COMMENT '\u4f01\u4e1a\u7c7b\u578b(0-\u4e2a\u4eba\u79df\u6237\uff0c1-\u4f01\u4e1a\u79df\u6237)'")
    private Integer enterpriseType;
    @Column(name="contacts_address", columnDefinition="VARCHAR(200) DEFAULT NULL COMMENT '\u4f01\u4e1a\u8054\u7edc\u4eba\u5730\u5740'")
    private String contactsAddress;
    @Column(name="enterprise_industry", columnDefinition="VARCHAR(50) DEFAULT NULL COMMENT '\u4f01\u4e1a\u884c\u4e1a'")
    private String enterpriseIndustry;
    @Column(name="`explain`", columnDefinition="TEXT NULL COMMENT '\u5ba1\u6838\u539f\u56e0'")
    private String explain;
    @Column(name="team_id", columnDefinition="varchar(40) DEFAULT NULL COMMENT '\u56e2\u961f\u7c7b\u578bid'")
    private String teamId;
    @Column(name="pre_deploy", columnDefinition="bit(1) DEFAULT 0 COMMENT '\u662f\u5426\u90e8\u7f72\u9884\u751f\u4ea7\u533a'")
    private boolean preDeploy;
    @Column(name="agree_certification_agreement", columnDefinition="bit(0) DEFAULT 0 COMMENT '\u662f\u5426\u540c\u610f\u5b9e\u540d\u8ba4\u8bc1\u534f\u8bae(0\u672a\u540c\u610f\uff0c1\u5df2\u540c\u610f)\u9ed8\u8ba40'")
    private Boolean agreeCertificationAgreement;
    @Column(name="full_name_ch", columnDefinition="varchar(200) DEFAULT NULL COMMENT '\u4e2d\u6587\u79df\u6237\u5168\u540d\u79f0'")
    private String fullNameCH;
    @Column(name="full_name_en", columnDefinition="varchar(200) DEFAULT NULL COMMENT '\u82f1\u6587\u79df\u6237\u5168\u540d\u79f0'")
    private String fullNameEN;
    @Column(name="potential_customer_id", columnDefinition="varchar(100) DEFAULT NULL COMMENT '\u6f5c\u5ba2\u4ee3\u53f7'")
    private String potentialCustomerId;
    @Column(name="domain_name", columnDefinition="VARCHAR(255) NULL DEFAULT NULL COMMENT '\u534e\u4e3a-\u8ba4\u8bc1\u4e2d\u5fc3\u57df\u540d\u5730\u5740'")
    private String domainName;
    @Column(name="tenant_code", columnDefinition="VARCHAR(64) NULL DEFAULT NULL COMMENT '\u534e\u4e3a-\u79df\u6237\u6807\u8bc6'")
    private String tenantCode;
    @Column(name="tenant_id", columnDefinition="VARCHAR(64) NULL DEFAULT NULL COMMENT '\u534e\u4e3a-\u79df\u6237ID'")
    private String tenantId;
    @Column(name="isv", columnDefinition="bit(1) default 0 comment '\u662f\u5426\u5916\u90e8ISV\u4f19\u4f34'")
    private boolean isv;
    @Column(name="isv_apply_status", columnDefinition="tinyint(1) default 0 comment '\u7533\u8acb\u72c0\u614b'")
    private int isvApplyStatus;
    @Column(name="enable_mapping", columnDefinition="bit(1) default 0 COMMENT '\u662f\u5426\u542f\u7528\u5f52\u6237'")
    private Boolean enableMapping;
    @Column(name="experience", columnDefinition="bit(1) default 0 COMMENT '\u662f\u5426\u4f53\u9a8c\u79df\u6237'")
    private boolean experience;
    @Column(name="offline", columnDefinition="bit(1) default 0 COMMENT '\u662f\u5426\u542f\u7528\u7ebf\u4e0b\u5b58\u50a8'")
    private boolean offline;
    @Column(name="back_uri", columnDefinition="VARCHAR(200) NULL DEFAULT NULL COMMENT '\u540e\u53f0\u5730\u5740'")
    private String backUri;
    @Column(name="ad_login", columnDefinition="bit(1) DEFAULT 0 COMMENT '\u662f\u5426\u5f00\u542fad\u57df\u767b\u5165'")
    private boolean adLogin;
    @Column(name="saml_login", columnDefinition="bit(1) DEFAULT 0 COMMENT '\u662f\u5426\u5f00\u542fsaml\u767b\u5165'")
    private boolean samlLogin;
    @Column(name="cas_login", columnDefinition="bit(1) DEFAULT 0 COMMENT '\u662f\u5426\u5f00\u542fcas\u767b\u5165'")
    private boolean casLogin;
    @Column(name="oidc_login", columnDefinition="bit(1) DEFAULT 0 COMMENT '\u662f\u5426\u5f00\u542foidc\u767b\u5165'")
    private boolean oidcLogin;
    @Column(name="double_check", columnDefinition="bit(1) DEFAULT 0 comment '\u662f\u5426\u5f00\u542f\u53cc\u91cd\u6821\u9a8c'")
    private boolean doubleCheck;
    @Column(name="identity_code_accept_type")
    private String identityCodeAcceptType;
    @Column(name="version")
    private String version;
    @Column(name="res_acquire_mode", columnDefinition="tinyint default 1 comment '\u4e91\u8d44\u6e90\u7533\u8bf7\u65b9\u5f0f 1\uff1a\u5f00\u53d1\u8ba2\u9605 2\uff1a\u8fd0\u7ef4\u7533\u8bf7'")
    private Integer resAcquireMode;
    @Column(name="tenant_purpose")
    private String tenantPurpose;
    @Column(name="found_date")
    private LocalDateTime foundDate;
    @Column(name="website")
    private String website;

    public Tenant() {
        this.version = "v1";
    }

    public Tenant(long sid, String id, String name) {
        super.setSid(sid);
        this.setId(id);
        this.name = name;
        this.version = "v1";
    }

    public Tenant(String id, String name, long ownerUserSid, String comeFrom, UserImportInfo userImportInfo) {
        this.setId(id);
        this.customerId = id;
        this.name = name;
        this.confirm = 1;
        this.ownerUserSid = ownerUserSid;
        this.comeFrom = comeFrom;
        this.enterpriseType = userImportInfo.isEnterprise() ? 1 : 0;
        this.fullNameCH = userImportInfo.getCustomerFullNameCH();
        this.fullNameEN = userImportInfo.getCustomerFullNameEN();
        this.potentialCustomerId = userImportInfo.getPotentialCustomerId();
        this.teamId = TeamEnum.SELF_DEV_ENTERPRISE_CUSTOMERS.getId();
        this.contacts = userImportInfo.getContacts();
        this.email = userImportInfo.getTenantEmail();
        this.telephone = userImportInfo.getTenantTelephone();
        this.address = userImportInfo.getAddress();
        this.version = "v1";
    }

    public Tenant(TenantVO tenantVO) {
        if (tenantVO.getSid() == null) {
            super.setSid(0L);
        } else {
            super.setSid(tenantVO.getSid().longValue());
        }
        super.setId(tenantVO.getId());
        this.name = tenantVO.getName();
        this.customerId = tenantVO.getCustomerId();
        this.industryType = tenantVO.getIndustryType();
        this.staffSize = tenantVO.getStaffSize();
        this.contacts = tenantVO.getContacts();
        this.email = tenantVO.getEmail();
        this.cellphonePrefix = tenantVO.getCellphonePrefix();
        this.phone = tenantVO.getPhone();
        this.telephone = tenantVO.getTelephone();
        this.address = tenantVO.getAddress();
        this.description = tenantVO.getDescription();
        this.imageUrl = tenantVO.getImageUrl();
        this.open = tenantVO.getOpen() == null ? false : tenantVO.getOpen();
        this.comeFrom = tenantVO.getComeFrom();
        this.dealer = tenantVO.isDealer() == null ? false : tenantVO.isDealer();
        this.sourceTenantSid = tenantVO.getSourceTenantSid();
        this.enterpriseType = tenantVO.getEnterpriseType();
        this.eoc = tenantVO.getEoc() == null ? false : tenantVO.getEoc();
        this.corpWechat = tenantVO.getCorpWechat() != null && tenantVO.getCorpWechat() != false;
        this.corpDingTalk = Boolean.TRUE.equals(tenantVO.getCorpDingTalk());
        this.contactsAddress = tenantVO.getContactsAddress();
        this.enterpriseIndustry = tenantVO.getEnterpriseIndustry();
        if (tenantVO.getOwnerUserSid() != null) {
            this.ownerUserSid = tenantVO.getOwnerUserSid();
        }
        this.potentialCustomerId = tenantVO.getPotentialCustomerId();
        this.agreeCertificationAgreement = Optional.ofNullable(tenantVO.getAgreeCertificationAgreement()).orElse(Boolean.FALSE);
        this.fullNameCH = tenantVO.getName();
        this.teamId = Optional.ofNullable(tenantVO.getTeamId()).filter(o -> !StringUtils.isEmpty((Object)o)).orElse(TeamEnum.SELF_DEV_ENTERPRISE_CUSTOMERS.getId());
        this.tenantId = tenantVO.getTenantId();
        this.experience = Optional.ofNullable(tenantVO.getExperience()).orElse(false);
        this.adLogin = Optional.ofNullable(tenantVO.getAdLogin()).orElse(Boolean.FALSE);
        this.samlLogin = Optional.ofNullable(tenantVO.getSamlLogin()).orElse(Boolean.FALSE);
        this.casLogin = Optional.ofNullable(tenantVO.getCasLogin()).orElse(Boolean.FALSE);
        this.isvApplyStatus = tenantVO.getIsvApplyStatus();
        this.isv = Optional.ofNullable(tenantVO.getIsv()).orElse(Boolean.FALSE);
        this.resAcquireMode = Optional.ofNullable(tenantVO.getResAcquireMode()).orElse(ResAcquireModeEnum.DEVELOPMENT_SUBSCRIPTIONS.getValue());
        this.version = "v1";
        this.tenantPurpose = tenantVO.getTenantPurpose();
    }

    public boolean isExperience() {
        return this.experience;
    }

    public void setExperience(boolean experience) {
        this.experience = experience;
    }

    public Boolean getEnableMapping() {
        return this.enableMapping;
    }

    public void setEnableMapping(Boolean enableMapping) {
        this.enableMapping = enableMapping;
    }

    public boolean isIsv() {
        return this.isv;
    }

    public void setIsv(boolean isv) {
        this.isv = isv;
    }

    public int getIsvApplyStatus() {
        return this.isvApplyStatus;
    }

    public void setIsvApplyStatus(int isvApplyStatus) {
        this.isvApplyStatus = isvApplyStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getCellphonePrefix() {
        return this.cellphonePrefix;
    }

    public void setCellphonePrefix(String cellphonePrefix) {
        this.cellphonePrefix = cellphonePrefix;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public int getConfirm() {
        return this.confirm;
    }

    public void setConfirm(int confirm) {
        this.confirm = confirm;
    }

    public String getIndustryType() {
        return this.industryType;
    }

    public void setIndustryType(String industryType) {
        this.industryType = industryType;
    }

    public String getStaffSize() {
        return this.staffSize;
    }

    public void setStaffSize(String staffSize) {
        this.staffSize = staffSize;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public long getOwnerUserSid() {
        return this.ownerUserSid;
    }

    public void setOwnerUserSid(long ownerUserSid) {
        this.ownerUserSid = ownerUserSid;
    }

    public String getContacts() {
        return this.contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public String getComeFrom() {
        return this.comeFrom;
    }

    public void setComeFrom(String comeFrom) {
        this.comeFrom = comeFrom;
    }

    public boolean isTestTenant() {
        return this.testTenant;
    }

    public void setTestTenant(boolean testTenant) {
        this.testTenant = testTenant;
    }

    public boolean isDealer() {
        return this.dealer;
    }

    public void setDealer(boolean dealer) {
        this.dealer = dealer;
    }

    public long getSourceTenantSid() {
        return this.sourceTenantSid;
    }

    public void setSourceTenantSid(long sourceTenantSid) {
        this.sourceTenantSid = sourceTenantSid;
    }

    public boolean isEoc() {
        return this.eoc;
    }

    public void setEoc(boolean eoc) {
        this.eoc = eoc;
    }

    public boolean isCorpWechat() {
        return this.corpWechat;
    }

    public void setCorpWechat(boolean corpWechat) {
        this.corpWechat = corpWechat;
    }

    public boolean isCorpDingTalk() {
        return this.corpDingTalk;
    }

    public void setCorpDingTalk(boolean corpDingTalk) {
        this.corpDingTalk = corpDingTalk;
    }

    public Integer getEnterpriseType() {
        return this.enterpriseType;
    }

    public void setEnterpriseType(Integer enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public String getContactsAddress() {
        return this.contactsAddress;
    }

    public void setContactsAddress(String contactsAddress) {
        this.contactsAddress = contactsAddress;
    }

    public String getEnterpriseIndustry() {
        return this.enterpriseIndustry;
    }

    public void setEnterpriseIndustry(String enterpriseIndustry) {
        this.enterpriseIndustry = enterpriseIndustry;
    }

    public String getExplain() {
        return this.explain;
    }

    public void setExplain(String explain) {
        this.explain = explain;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public boolean isPreDeploy() {
        return this.preDeploy;
    }

    public void setPreDeploy(boolean preDeploy) {
        this.preDeploy = preDeploy;
    }

    public Boolean getAgreeCertificationAgreement() {
        return this.agreeCertificationAgreement;
    }

    public void setAgreeCertificationAgreement(Boolean agreeCertificationAgreement) {
        this.agreeCertificationAgreement = agreeCertificationAgreement;
    }

    public String getFullNameCH() {
        return this.fullNameCH;
    }

    public void setFullNameCH(String fullNameCH) {
        this.fullNameCH = fullNameCH;
    }

    public String getFullNameEN() {
        return this.fullNameEN;
    }

    public void setFullNameEN(String fullNameEN) {
        this.fullNameEN = fullNameEN;
    }

    public String getPotentialCustomerId() {
        return this.potentialCustomerId;
    }

    public void setPotentialCustomerId(String potentialCustomerId) {
        this.potentialCustomerId = potentialCustomerId;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public String getBackUri() {
        return this.backUri;
    }

    public void setBackUri(String backUri) {
        this.backUri = backUri;
    }

    public boolean isAdLogin() {
        return this.adLogin;
    }

    public void setAdLogin(boolean adLogin) {
        this.adLogin = adLogin;
    }

    public boolean isSamlLogin() {
        return this.samlLogin;
    }

    public void setSamlLogin(boolean samlLogin) {
        this.samlLogin = samlLogin;
    }

    public boolean isCasLogin() {
        return this.casLogin;
    }

    public void setCasLogin(boolean casLogin) {
        this.casLogin = casLogin;
    }

    public boolean getDoubleCheck() {
        return this.doubleCheck;
    }

    public void setDoubleCheck(boolean doubleCheck) {
        this.doubleCheck = doubleCheck;
    }

    public String getIdentityCodeAcceptType() {
        return this.identityCodeAcceptType;
    }

    public void setIdentityCodeAcceptType(String identityCodeAcceptType) {
        this.identityCodeAcceptType = identityCodeAcceptType;
    }

    public boolean isOidcLogin() {
        return this.oidcLogin;
    }

    public void setOidcLogin(boolean oidcLogin) {
        this.oidcLogin = oidcLogin;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean certainFieldChanged(Tenant oldTenant) {
        return this.isDealer() != oldTenant.isDealer() || this.isEoc() != oldTenant.isEoc() || this.isCorpWechat() != oldTenant.isCorpWechat() || this.adLogin != oldTenant.isAdLogin() || this.oidcLogin != oldTenant.isOidcLogin() || this.isSamlLogin() != oldTenant.isSamlLogin() || this.isCasLogin() != oldTenant.isCasLogin();
    }

    public Integer getResAcquireMode() {
        return this.resAcquireMode;
    }

    public void setResAcquireMode(Integer resAcquireMode) {
        this.resAcquireMode = resAcquireMode;
    }

    public String getTenantPurpose() {
        return this.tenantPurpose;
    }

    public void setTenantPurpose(String tenantPurpose) {
        this.tenantPurpose = tenantPurpose;
    }

    public LocalDateTime getFoundDate() {
        return this.foundDate;
    }

    public void setFoundDate(LocalDateTime foundDate) {
        this.foundDate = foundDate;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }
}

