/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.entity;

import com.digiwin.dap.middle.database.encrypt.annotation.Desensitization;
import com.digiwin.dap.middle.database.encrypt.annotation.SensitiveField;
import com.digiwin.dap.middle.database.encrypt.enums.DesensitizationModeEnum;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.iam.domain.form.IntellyIdentityVO;
import com.digiwin.dap.middleware.iam.domain.user.RegisterUserVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.entity.IntellyIdentityApplication;
import com.digiwin.dap.middleware.iam.support.remote.digiwinadwsdl.domain.AdInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.DynamicInsert;
import org.springframework.util.ObjectUtils;

@DynamicInsert
@Entity
@Table(name="user", uniqueConstraints={@UniqueConstraint(name="uk_user_id", columnNames={"id"})}, indexes={@Index(name="idx_user_email", columnList="email"), @Index(name="idx_user_telephone", columnList="telephone")})
@Desensitization
public class User
extends BaseEntityWithId {
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL")
    private String aliasId;
    @Column(nullable=false, length=256)
    @SensitiveField
    private String name;
    @Column(columnDefinition="VARCHAR(20) DEFAULT NULL")
    private String phone;
    @Column(columnDefinition="VARCHAR(128) DEFAULT NULL")
    @SensitiveField
    private String telephone;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL")
    private String email;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL")
    private String wechat;
    @Column(columnDefinition="VARCHAR(300) DEFAULT NULL")
    private String headImageUrl;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL")
    private String nickname;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL")
    private String sex;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL")
    private String birthday;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL")
    private String cellphonePrefix;
    @Column(columnDefinition="VARCHAR(100) DEFAULT NULL")
    private String address;
    @JsonIgnore
    @Column(nullable=false, length=80)
    @SensitiveField(mode=DesensitizationModeEnum.SHA256)
    private String password;
    @Column(name="ISACTIVATED", columnDefinition="bit(1) DEFAULT 0")
    private boolean activated;
    @Column(name="ISENTERPRISE", columnDefinition="bit(1) DEFAULT 0")
    private boolean enterprise;
    @Column(columnDefinition="BIGINT(20) DEFAULT 0")
    private long defaultTenantSid;
    @Column(name="ISCONFIRM", columnDefinition="bit(1) DEFAULT 0")
    private boolean confirm;
    @Column(name="visible", columnDefinition="bit(1) DEFAULT 1")
    private boolean visible = true;
    @Column(name="readonly", columnDefinition="bit(1) DEFAULT 0")
    private boolean readonly;
    @Column(name="charge_sid", columnDefinition="bigint(20)  default 0")
    private long chargeSid;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL")
    private String comeFrom;
    @Column(columnDefinition="VARCHAR(40) DEFAULT NULL")
    private String salt;
    @Column(columnDefinition="int(1) DEFAULT 0 COMMENT '\u7528\u6237\u7c7b\u578b\uff080.\u9f0e\u6377\u4e91\u7528\u6237 1.\u4f01\u4e1a\u7528\u6237 \uff09'")
    private Integer type;
    @Column(name="password_changed", columnDefinition="bit(1) DEFAULT 0 COMMENT '\u662f\u5426\u53d8\u66f4\u8fc7\u5bc6\u7801\uff0c0-\u672a\u53d8\u66f4\uff0c1-\u5df2\u53d8\u66f4'")
    private boolean changed;
    @Column(name="agree_agreement", columnDefinition="bit(0) DEFAULT 0 COMMENT '\u662f\u5426\u540c\u610f\u7528\u6237\u534f\u8bae\u53ca\u6cd5\u5f8b\u516c\u544a (0\u672a\u540c\u610f\uff0c1\u5df2\u540c\u610f)\u9ed8\u8ba40'")
    private Boolean agreeAgreement;
    @Column(name="due_date", columnDefinition="DATETIME  NOT  NULL DEFAULT '9999-12-31 23:59:59' COMMENT '\u6743\u9650\u5230\u671f\u65e5'")
    private LocalDateTime dueDate;
    @Column(name="remark", columnDefinition="VARCHAR(255) NULL DEFAULT NULL COMMENT '\u8bf4\u660e\u5907\u6ce8'")
    private String remark;
    @Column(name="double_check", columnDefinition="bit(1) NULL  DEFAULT b'0' COMMENT '\u662f\u5426\u5f00\u542f\u53cc\u91cd\u6821\u9a8c'")
    private Boolean doubleCheck;
    @Column(name="identity_code_accept_type", columnDefinition="VARCHAR(40) NULL  DEFAULT NULL COMMENT '\u9a8c\u8bc1\u7801\u83b7\u53d6\u65b9\u5f0f\uff0cmobile,email'")
    private String identityCodeAcceptType;
    @Column(name="pw_date", columnDefinition=" datetime default now() comment '\u4e0a\u6b21\u4fee\u6539\u5bc6\u7801\u65f6\u95f4'")
    private LocalDateTime pwDate;
    @Column(name="dev_agreement_signed", columnDefinition="bit(1) default 0 comment '\u662f\u5426\u7b7e\u7f72\u5f00\u53d1\u8005\u4f7f\u7528\u534f\u8bae'")
    private boolean devAgreementSigned;
    @Column(name="source_id", columnDefinition="varchar(120) null comment '\u539f\u7528\u6237id\uff0c\u521b\u5efa\u667a\u5ba2\u4f53\u9a8c\u7528\u6237\u65f6\u4f7f\u7528'")
    private String sourceId;
    @Column(name="referral_code", columnDefinition="varchar(32) null comment '\u63a8\u8350\u4ee3\u53f7'")
    private String referralCode;
    @Transient
    private IntellyIdentityVO identity;
    @Column(name="one_id")
    private String oneId;
    @Column(name="purpose")
    private String purpose;

    public User() {
        this.type = 0;
        this.changed = true;
        this.pwDate = LocalDateTime.now();
        this.purpose = "normal";
    }

    public User(RegisterUserVO user) {
        this(user, 0);
    }

    public User(RegisterUserVO user, Integer cloud) {
        super.setId(user.getId());
        this.name = user.getName();
        this.activated = true;
        this.email = user.getEmail();
        this.telephone = user.getTelephone();
        this.cellphonePrefix = user.getCellphonePrefix();
        this.password = DigestUtils.sha256((String)user.getPassword());
        this.type = 0;
        this.changed = Optional.ofNullable(user.getPasswordChanged()).orElse(Boolean.TRUE);
        this.comeFrom = user.getComeFrom();
        this.agreeAgreement = 2 == cloud || 3 == cloud ? Boolean.TRUE : Optional.ofNullable(user.getAgreeAgreement()).orElse(Boolean.FALSE);
        this.pwDate = LocalDateTime.now();
        this.sourceId = user.getSourceId();
        this.referralCode = user.getReferralCode();
        this.purpose = "normal";
    }

    public User(UserInfo user) {
        super.setSid(user.getSid());
        super.setId(user.getId());
        this.name = user.getName();
        this.activated = true;
        this.email = user.getEmail();
        this.telephone = user.getTelephone();
        this.cellphonePrefix = user.getCellphonePrefix();
        this.password = DigestUtils.sha256((String)user.getPassword());
        this.type = 0;
        this.pwDate = LocalDateTime.now();
        this.purpose = "normal";
    }

    public User(AdInfo adInfo) {
        super.setId(adInfo.getMail());
        this.name = adInfo.getName();
        this.email = adInfo.getMail();
        this.nickname = adInfo.getName();
        this.activated = true;
        this.comeFrom = "digiwin-ad";
        this.type = 0;
        this.changed = true;
        this.agreeAgreement = Boolean.TRUE;
        this.pwDate = LocalDateTime.now();
        this.purpose = "normal";
    }

    public User(String id, String name) {
        this.setId(id);
        this.name = name;
    }

    public static boolean isADAccount(String userId) {
        if (!ObjectUtils.isEmpty((Object)userId)) {
            return userId.toLowerCase().endsWith("@digiwin.com") && userId.length() > "@digiwin.com".length();
        }
        return false;
    }

    public boolean isDevAgreementSigned() {
        return this.devAgreementSigned;
    }

    public void setDevAgreementSigned(boolean devAgreementSigned) {
        this.devAgreementSigned = devAgreementSigned;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getAliasId() {
        return this.aliasId;
    }

    public void setAliasId(String aliasId) {
        this.aliasId = aliasId;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public boolean isEnterprise() {
        return this.enterprise;
    }

    public void setEnterprise(boolean enterprise) {
        this.enterprise = enterprise;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getWechat() {
        return this.wechat;
    }

    public void setWechat(String wechat) {
        this.wechat = wechat;
    }

    public String getHeadImageUrl() {
        return this.headImageUrl;
    }

    public void setHeadImageUrl(String headImageUrl) {
        this.headImageUrl = headImageUrl;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getSex() {
        return this.sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getCellphonePrefix() {
        return this.cellphonePrefix;
    }

    public void setCellphonePrefix(String cellphonePrefix) {
        this.cellphonePrefix = cellphonePrefix;
    }

    public long getDefaultTenantSid() {
        return this.defaultTenantSid;
    }

    public void setDefaultTenantSid(long defaultTenantSid) {
        this.defaultTenantSid = defaultTenantSid;
    }

    public long getChargeSid() {
        return this.chargeSid;
    }

    public void setChargeSid(long chargeSid) {
        this.chargeSid = chargeSid;
    }

    public String getComeFrom() {
        return this.comeFrom;
    }

    public void setComeFrom(String comeFrom) {
        this.comeFrom = comeFrom;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.setPwDate(LocalDateTime.now());
        }
    }

    public Boolean getAgreeAgreement() {
        return this.agreeAgreement;
    }

    public void setAgreeAgreement(Boolean agreeAgreement) {
        this.agreeAgreement = agreeAgreement;
    }

    public LocalDateTime getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDateTime dueDate) {
        this.dueDate = dueDate;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Boolean getDoubleCheck() {
        return this.doubleCheck;
    }

    public void setDoubleCheck(Boolean doubleCheck) {
        this.doubleCheck = doubleCheck;
    }

    public String getIdentityCodeAcceptType() {
        return this.identityCodeAcceptType;
    }

    public void setIdentityCodeAcceptType(String identityCodeAcceptType) {
        this.identityCodeAcceptType = identityCodeAcceptType;
    }

    public LocalDateTime getPwDate() {
        return this.pwDate;
    }

    public void setPwDate(LocalDateTime pwDate) {
        this.pwDate = pwDate;
    }

    public IntellyIdentityVO getIdentity() {
        return this.identity;
    }

    public void setIdentity(IntellyIdentityVO identity) {
        this.identity = identity;
    }

    public static String getIdOfEnterpriseUser(String id) {
        String[] array = id.split("\\$");
        return array[1];
    }

    public static String getTenantIdOfEnterpriseUser(String id) {
        String[] array = id.split("\\$");
        return array[0];
    }

    public void completeIdentity(IntellyIdentityApplication application) {
        this.setName(application.getName());
    }

    public boolean normal() {
        return this.type == 0;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getReferralCode() {
        return this.referralCode;
    }

    public void setReferralCode(String referralCode) {
        this.referralCode = referralCode;
    }

    public String getOneId() {
        return this.oneId;
    }

    public void setOneId(String oneId) {
        this.oneId = oneId;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }
}

