/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.entity;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.user.UserVO;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.DynamicInsert;

@DynamicInsert
@Entity
@Table(name="userrelationwithtenant", uniqueConstraints={@UniqueConstraint(name="uk_userintenant_usersid_tenantsid", columnNames={"USER_SID", "TENANT_SID"})}, indexes={@Index(name="idx_userintenant_tenantsid", columnList="tenant_sid")})
public class UserInTenant
extends BaseEntity {
    @Column(name="TENANT_SID", nullable=false)
    private long tenantSid;
    @Column(name="USER_SID", nullable=false)
    private long userSid;
    @Column(name="visible", columnDefinition="bit(1) DEFAULT 1")
    private boolean visible = true;
    @Column(name="due_date", columnDefinition="DATETIME  NOT  NULL DEFAULT '9999-12-31 23:59:59' COMMENT '\u6743\u9650\u5230\u671f\u65e5'")
    private LocalDateTime dueDate;
    @Column(name="user_type", columnDefinition="bit(1) DEFAULT 0 COMMENT '\u7528\u6237\u6027\u8d28 1\uff1a\u5916\u90e8\u7528\u6237 0\uff1a\u4e00\u822c\u7528\u6237'")
    private boolean userType = false;
    @Column(name="card_id", columnDefinition="varchar(100) DEFAULT NULL COMMENT '\u5361\u7247id'")
    private String cardId;
    @Column(name="tenant_visible", columnDefinition="bit(1) DEFAULT 1")
    private boolean tenantVisible = true;

    public UserInTenant() {
    }

    public UserInTenant(long userSid, long tenantSid) {
        this.userSid = userSid;
        this.tenantSid = tenantSid;
    }

    public UserInTenant(long tenantSid, UserVO userVO) {
        this.tenantSid = tenantSid;
        this.userSid = userVO.getSid();
        this.dueDate = userVO.getDueDate();
        this.visible = userVO.isVisible();
        this.setDisabled(userVO.isDisabled());
        this.userType = userVO.getUserType();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public long getUserSid() {
        return this.userSid;
    }

    public void setUserSid(long userSid) {
        this.userSid = userSid;
    }

    public long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public LocalDateTime getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDateTime dueDate) {
        this.dueDate = dueDate;
    }

    public boolean isUserType() {
        return this.userType;
    }

    public void setUserType(boolean userType) {
        this.userType = userType;
    }

    public String getCardId() {
        return this.cardId;
    }

    public void setCardId(String cardId) {
        this.cardId = cardId;
    }

    public boolean isTenantVisible() {
        return this.tenantVisible;
    }

    public void setTenantVisible(boolean tenantVisible) {
        this.tenantVisible = tenantVisible;
    }
}

