/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.repository;

import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.repository.BaseEntityRepository;
import java.util.List;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface OrgRepository
extends BaseEntityRepository<Org, Long> {
    public List<Org> findByTenantSidAndId(long var1, String var3);

    public List<Org> findByParentSid(long var1);

    @Query(value="select o.sid  from Org o where o.parentSid= :parentSid")
    public List<Long> findOrgSidsByParentSid(@Param(value="parentSid") long var1);

    @Query(value="select o from Org o where o.tenantSid= :tenantSid and o.parentSid=0")
    public List<Org> findRootOrgsInTenant(@Param(value="tenantSid") long var1);

    @Query(value="select o.sid  from Org o where o.parentSid= :parentSid and o.disabled=false")
    public List<Long> findEnableOrgSidsByParentSid(@Param(value="parentSid") long var1);

    @Query(value="select o.sid  from Org o where o.disabled=false and o.orgTypeSid= :orgTypeSid")
    public List<Long> findNotDisOrgSidsByOrgTypeSid(@Param(value="orgTypeSid") long var1);

    @Query(value="select o.sid  from Org o where o.tenantSid= :tenantSid and o.disabled=true ")
    public List<Long> findDisOrgSidsByTenantSid(@Param(value="tenantSid") long var1);

    @Modifying
    @Transactional(rollbackFor={Exception.class})
    @Query(value="update Org o set o.disabled=true  where o.sid in ?1")
    public void batchDisable(List<Long> var1);

    public List<Org> findBySidIn(@Param(value="sids") List<Long> var1);

    public boolean existsByTenantSidAndId(long var1, String var3);

    public List<Org> findByTenantSid(@Param(value="tenantSid") long var1);

    @Query(value="select sid from Org where tenantSid= :tenantSid and uri like concat(:uri,':%')")
    public List<Long> findOrgSidsByTenantSidAndUri(@Param(value="tenantSid") long var1, @Param(value="uri") String var3);

    public Org findByTenantSidAndUri(@Param(value="tenantSid") long var1, @Param(value="uri") String var3);

    public Org findByTenantSidAndSid(long var1, Long var3);
}

